/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.server;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class NormalizedSampleIdentifier {
    private IdentifierParts containerIdentifierParts = new IdentifierParts();
    private IdentifierParts identifierParts = new IdentifierParts();

    public NormalizedSampleIdentifier(Sample sample) {
        Sample container = sample.getContainer();
        if (container != null) {
            this.containerIdentifierParts.extractPartsFrom(container);
        }
        this.identifierParts.extractPartsFrom(sample);
        if (this.identifierParts.code.contains(":")) {
            this.identifierParts.code = this.identifierParts.code.split(":")[1];
        }
    }

    public NormalizedSampleIdentifier(NewSample sample, String homeSpace) {
        String identifier = sample.getIdentifier().toUpperCase();
        this.identifierParts.extractPartsFrom(identifier);
        if (this.identifierParts.codeOnly) {
            if (this.identifierParts.space == null) {
                this.identifierParts.space = this.normalizeSpaceCode(sample.getDefaultSpaceIdentifier());
            }
            if (this.identifierParts.space == null) {
                this.identifierParts.space = this.normalizeSpaceCode(homeSpace);
            }
            if (this.identifierParts.space == null) {
                throw UserFailureException.fromTemplate((String)("Cannot determine space for sample " + sample), (Object[])new Object[0]);
            }
        }
        if (this.identifierParts.code.contains(":")) {
            String[] split = this.identifierParts.code.split(":");
            this.containerIdentifierParts.code = split[0];
            this.identifierParts.code = split[1];
            this.containerIdentifierParts.space = this.identifierParts.space;
            this.containerIdentifierParts.project = this.identifierParts.project;
            if (!identifier.contains("/")) {
                // empty if block
            }
        }
        if (sample.getCurrentContainerIdentifier() != null && this.containerIdentifierParts.space != null) {
            throw new UserFailureException("Container specified twice: " + sample.getIdentifier() + " and " + sample.getCurrentContainerIdentifier());
        }
        if (sample.getCurrentContainerIdentifier() != null) {
            String containerIdentifier = sample.getCurrentContainerIdentifier();
            this.containerIdentifierParts.extractPartsFrom(containerIdentifier);
            if (this.containerIdentifierParts.space == null) {
                this.containerIdentifierParts.space = this.identifierParts.space;
                this.containerIdentifierParts.project = this.identifierParts.project;
            }
        }
    }

    public String getSampleIdentifier() {
        return this.identifierParts.getIdentifier();
    }

    public String getContainerIdentifier() {
        return this.containerIdentifierParts.getIdentifier();
    }

    public String getContainerCode() {
        return this.containerIdentifierParts.code;
    }

    public String getCode() {
        return this.identifierParts.code;
    }

    private String normalizeSpaceCode(String spaceCode) {
        if (spaceCode != null && spaceCode.startsWith("/")) {
            return spaceCode.substring(1);
        }
        return spaceCode;
    }

    public String toString() {
        String sampleIdentifier = this.getSampleIdentifier();
        String containerIdentifier = this.getContainerIdentifier();
        return containerIdentifier == null ? sampleIdentifier : sampleIdentifier + " (Container: " + containerIdentifier + ")";
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        this.appendTo(builder, this.identifierParts);
        this.appendTo(builder, this.containerIdentifierParts);
        return builder.toHashCode();
    }

    private void appendTo(HashCodeBuilder builder, IdentifierParts parts) {
        builder.append((Object)parts.space).append((Object)parts.project).append((Object)parts.code);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NormalizedSampleIdentifier)) {
            return false;
        }
        NormalizedSampleIdentifier that = (NormalizedSampleIdentifier)o;
        EqualsBuilder builder = new EqualsBuilder();
        this.appendTo(builder, this.identifierParts, that.identifierParts);
        this.appendTo(builder, this.containerIdentifierParts, that.containerIdentifierParts);
        return builder.isEquals();
    }

    private void appendTo(EqualsBuilder builder, IdentifierParts parts1, IdentifierParts parts2) {
        builder.append((Object)parts1.space, (Object)parts2.space);
        builder.append((Object)parts1.project, (Object)parts2.project);
        builder.append((Object)parts1.code, (Object)parts2.code);
    }

    private static final class IdentifierParts {
        private String space;
        private String project;
        private String code;
        private boolean codeOnly;

        private IdentifierParts() {
        }

        private void extractPartsFrom(String identifier) {
            if (identifier == null) {
                return;
            }
            if (identifier.startsWith("/")) {
                String[] splittedIdentifier = identifier.split("/");
                this.code = splittedIdentifier[splittedIdentifier.length - 1];
                if (splittedIdentifier.length == 4) {
                    this.project = splittedIdentifier[2];
                    this.space = splittedIdentifier[1];
                } else if (splittedIdentifier.length == 3) {
                    this.space = splittedIdentifier[1];
                }
            } else {
                this.code = identifier;
                this.codeOnly = true;
            }
        }

        private void extractPartsFrom(Sample sample) {
            this.code = sample.getCode();
            Project p = sample.getProject();
            Space s = sample.getSpace();
            if (p != null) {
                this.project = p.getCode();
                Space ps = p.getSpace();
                if (ps != null) {
                    s = ps;
                }
            }
            if (s != null) {
                this.space = s.getCode();
            }
        }

        public String getIdentifier() {
            if (this.code == null) {
                return null;
            }
            if (this.space == null) {
                return "/" + this.code;
            }
            if (this.project == null) {
                return "/" + this.space + "/" + this.code;
            }
            return "/" + this.space + "/" + this.project + "/" + this.code;
        }
    }
}

