/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.IQueryClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module.QueryDatabaseModel;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryDatabase;
import java.util.List;

public final class QueryDatabaseSelectionWidget
extends DropDownList<QueryDatabaseModel, QueryDatabase> {
    private static final String LIST_ITEMS_CALLBACK = "ListItemsCallback";
    public static final String SUFFIX = "database";
    private final IViewContext<IQueryClientServiceAsync> viewContext;
    private final QueryDatabase initialDatabaseOrNull;

    public QueryDatabaseSelectionWidget(IViewContext<IQueryClientServiceAsync> viewContext, QueryDatabase initialDatabaseOrNull) {
        super(viewContext, SUFFIX, "query_database", "name", "query_database", "databases");
        this.viewContext = viewContext;
        this.initialDatabaseOrNull = initialDatabaseOrNull;
        this.setEditable(false);
        this.setCallbackId(QueryDatabaseSelectionWidget.createCallbackId());
        this.setTemplate(GWTUtils.getTooltipTemplate("name", "tooltip"));
    }

    public static String createCallbackId() {
        return QueryDatabaseSelectionWidget.class + LIST_ITEMS_CALLBACK;
    }

    @Override
    protected List<QueryDatabaseModel> convertItems(List<QueryDatabase> result) {
        return QueryDatabaseModel.convert(result);
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<QueryDatabase>> callback) {
        this.viewContext.getService().listQueryDatabases(new ListDatabasesCallback(this.viewContext));
        callback.ignore();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.QUERY);
    }

    private void selectInitialValue() {
        if (this.initialDatabaseOrNull != null) {
            this.trySelect(this.initialDatabaseOrNull);
            this.updateOriginalValue();
        }
    }

    private void trySelect(QueryDatabase database) {
        try {
            GWTUtils.setSelectedItem(this, "name", database.getLabel());
        }
        catch (IllegalArgumentException ex) {
            this.viewContext.log(ex.getMessage());
            GWTUtils.alert("Error", "Query Database '" + database.getLabel() + "' isn't configured.");
        }
    }

    private class ListDatabasesCallback
    extends DropDownList.ListItemsCallback {
        protected ListDatabasesCallback(IViewContext<?> viewContext) {
            super(QueryDatabaseSelectionWidget.this, viewContext);
        }

        @Override
        public void process(List<QueryDatabase> result) {
            super.process(result);
            QueryDatabaseSelectionWidget.this.selectInitialValue();
        }
    }
}

