/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.SampleTypeDisplayID;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IParameterField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IParameterValuesLoader;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ParameterField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material.MaterialTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.report.ReportGeneratedCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.ExpressionUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.IReportInformationProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ParameterValue;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.QueryType;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.IQueryClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module.QueryDatabaseSelectionWidget;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module.SQLQueryField;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.NewQuery;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryDatabase;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryExpression;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryParameterBindings;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class QueryEditor
extends Dialog
implements IDisposableComponent {
    public static final String ID = "openbis_query-module_query_editor";
    private static final FormData FORM_DATA = new FormData("100%");
    private final IViewContext<IQueryClientServiceAsync> viewContext;
    private final TextField<String> nameField;
    private final TextField<String> descriptionField;
    private final SQLQueryField statementField;
    private final CheckBoxField isPublicField;
    private final QueryExpression queryOrNull;
    private final int parentHeight;
    private final SimpleComboBox<QueryType> queryTypeField;
    private final QueryDatabaseSelectionWidget queryDatabaseSelectionWidget;
    private IDisposableComponent reportAsDisposable;
    private MaterialTypeSelectionWidget materialTypeField;
    private SampleTypeSelectionWidget sampleTypeField;
    private ExperimentTypeSelectionWidget experimentTypeField;
    private DataSetTypeSelectionWidget dataSetTypeField;

    private static Button createCancelButton(IViewContext<?> viewContext, final Window window) {
        return new Button(viewContext.getMessage("button_cancel", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                window.hide();
            }
        });
    }

    public QueryEditor(IViewContext<IQueryClientServiceAsync> viewContext, QueryExpression queryOrNull, IDelegatedAction refreshAction, int parentWidth, int parentHeight) {
        this.viewContext = viewContext;
        this.queryOrNull = queryOrNull;
        this.parentHeight = parentHeight;
        this.setHeading(viewContext.getMessage(queryOrNull == null ? "query_create_title" : "query_edit_title", new Object[0]));
        this.setModal(true);
        this.setLayout((Layout)new FitLayout());
        this.setButtons("");
        this.nameField = AbstractRegistrationDialog.createTextField(viewContext.getMessage("name", new Object[0]), true);
        this.nameField.setMaxLength(200);
        this.descriptionField = AbstractRegistrationDialog.createTextField(viewContext.getMessage("description", new Object[0]), false);
        this.descriptionField.setMaxLength(2000);
        this.statementField = this.createStatementField();
        this.isPublicField = new CheckBoxField(viewContext.getMessage("is_public", new Object[0]), false);
        this.queryDatabaseSelectionWidget = new QueryDatabaseSelectionWidget(viewContext, queryOrNull != null ? queryOrNull.getQueryDatabase() : null);
        this.queryTypeField = new QueryTypeComboBox(viewContext);
        this.queryTypeField.addListener(Events.SelectionChange, (Listener)new Listener<SelectionChangedEvent<SimpleComboValue<QueryType>>>(){

            public void handleEvent(SelectionChangedEvent<SimpleComboValue<QueryType>> be) {
                QueryType selectedType = (QueryType)((SimpleComboValue)be.getSelectedItem()).getValue();
                QueryEditor.this.statementField.updateQueryType(selectedType);
                QueryEditor.this.updateFieldsVisibility(selectedType);
            }
        });
        this.createEntityTypeFields();
        if (queryOrNull != null) {
            FieldUtil.setValueWithUnescaping(this.nameField, queryOrNull.getName());
            FieldUtil.setValueWithUnescaping(this.descriptionField, queryOrNull.getDescription());
            FieldUtil.setValueWithUnescaping((Field<String>)this.statementField, queryOrNull.getExpression());
            this.isPublicField.setValue(queryOrNull.isPublic());
            this.queryTypeField.setSimpleValue((Object)queryOrNull.getQueryType());
        } else {
            this.queryTypeField.setSimpleValue((Object)QueryType.GENERIC);
        }
        FormPanel form = this.createFormPanel();
        this.setTopComponent((Component)this.createFormPanel());
        this.addButton(this.createSaveButton(form, refreshAction));
        this.addButton(this.createTestButton(form));
        this.addButton(QueryEditor.createCancelButton(viewContext, (Window)this));
        this.setPosition(5, 70);
        this.setWidth(parentWidth);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void dispose() {
        if (this.reportAsDisposable != null) {
            this.reportAsDisposable.dispose();
        }
    }

    private void createEntityTypeFields() {
        IViewContext<ICommonClientServiceAsync> commonViewContext = this.viewContext.getCommonViewContext();
        String materialTypeInitialCodeOrNull = null;
        String sampleTypeInitialCodeOrNull = null;
        String experimentTypeInitialCodeOrNull = null;
        String dataSetTypeInitialCodeOrNull = null;
        if (this.queryOrNull != null) {
            String entityTypeCode = this.queryOrNull.getEntityTypeCode();
            switch (this.queryOrNull.getQueryType()) {
                case DATA_SET: {
                    dataSetTypeInitialCodeOrNull = entityTypeCode;
                    break;
                }
                case EXPERIMENT: {
                    experimentTypeInitialCodeOrNull = entityTypeCode;
                    break;
                }
                case MATERIAL: {
                    materialTypeInitialCodeOrNull = entityTypeCode;
                    break;
                }
                case SAMPLE: {
                    sampleTypeInitialCodeOrNull = entityTypeCode;
                    break;
                }
            }
        }
        this.materialTypeField = MaterialTypeSelectionWidget.createWithAdditionalOption(commonViewContext, "(all)", materialTypeInitialCodeOrNull, ID);
        this.materialTypeField.setAllowValueNotFromList(true);
        this.materialTypeField.setAllowBlank(false);
        this.sampleTypeField = new SampleTypeSelectionWidget(commonViewContext, ID, false, true, false, sampleTypeInitialCodeOrNull, SampleTypeDisplayID.SAMPLE_QUERY);
        this.sampleTypeField.setAllowValueNotFromList(true);
        this.sampleTypeField.setAllowBlank(false);
        this.dataSetTypeField = new DataSetTypeSelectionWidget(commonViewContext, ID, true, dataSetTypeInitialCodeOrNull);
        this.dataSetTypeField.setAllowValueNotFromList(true);
        this.dataSetTypeField.setAllowBlank(false);
        this.experimentTypeField = new ExperimentTypeSelectionWidget(commonViewContext, ID, true, experimentTypeInitialCodeOrNull);
        this.experimentTypeField.setAllowValueNotFromList(true);
        this.experimentTypeField.setAllowBlank(false);
    }

    private FormPanel createFormPanel() {
        FormPanel form = new FormPanel();
        form.setHeaderVisible(false);
        form.setBorders(true);
        form.setBodyBorder(false);
        form.add(this.nameField, (LayoutData)FORM_DATA);
        form.add((Widget)this.queryDatabaseSelectionWidget, (LayoutData)FORM_DATA);
        form.add(this.queryTypeField, (LayoutData)FORM_DATA);
        form.add((Widget)this.materialTypeField, (LayoutData)FORM_DATA);
        form.add((Widget)this.sampleTypeField, (LayoutData)FORM_DATA);
        form.add((Widget)this.dataSetTypeField, (LayoutData)FORM_DATA);
        form.add((Widget)this.experimentTypeField, (LayoutData)FORM_DATA);
        form.add(this.descriptionField, (LayoutData)FORM_DATA);
        form.add((Widget)this.statementField, (LayoutData)FORM_DATA);
        form.add((Widget)this.isPublicField);
        form.setPadding(20);
        return form;
    }

    private void updateFieldsVisibility(QueryType selectedType) {
        FieldUtil.setVisibility(selectedType == QueryType.DATA_SET, new Field[]{this.dataSetTypeField});
        FieldUtil.setVisibility(selectedType == QueryType.EXPERIMENT, new Field[]{this.experimentTypeField});
        FieldUtil.setVisibility(selectedType == QueryType.MATERIAL, new Field[]{this.materialTypeField});
        FieldUtil.setVisibility(selectedType == QueryType.SAMPLE, new Field[]{this.sampleTypeField});
    }

    private DropDownList<?, ? extends EntityType> tryGetEntityTypeField(QueryType selectedQueryType) {
        switch (selectedQueryType) {
            case DATA_SET: {
                return this.dataSetTypeField;
            }
            case EXPERIMENT: {
                return this.experimentTypeField;
            }
            case MATERIAL: {
                return this.materialTypeField;
            }
            case SAMPLE: {
                return this.sampleTypeField;
            }
        }
        return null;
    }

    private String tryExtractEntityTypeCode(QueryType selectedQueryType) {
        DropDownList<?, EntityType> entityTypeFieldOrNull = this.tryGetEntityTypeField(selectedQueryType);
        if (entityTypeFieldOrNull == null) {
            return null;
        }
        EntityType entityTypeOrNull = entityTypeFieldOrNull.tryGetSelected();
        String entityTypeCode = entityTypeOrNull == null ? entityTypeFieldOrNull.getRawValue() : entityTypeOrNull.getCode();
        return EntityType.isAllTypesCode(entityTypeCode) ? null : entityTypeCode;
    }

    private SQLQueryField createStatementField() {
        SQLQueryField field = new SQLQueryField(this.viewContext, true, 10);
        field.setMaxLength(2000);
        return field;
    }

    private Button createSaveButton(final FormPanel form, final IDelegatedAction refreshAction) {
        Button button = new Button(this.viewContext.getMessage("button_save", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (form.isValid()) {
                    QueryEditor.this.register((AsyncCallback<Void>)new AbstractAsyncCallback<Void>(QueryEditor.this.viewContext){

                        @Override
                        protected void process(Void result) {
                            QueryEditor.this.hide();
                            refreshAction.execute();
                        }
                    });
                }
            }
        });
        return button;
    }

    private Button createTestButton(final FormPanel form) {
        Button testButton = new Button(this.viewContext.getMessage("button_test_query", new Object[0]));
        testButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                if (form.isValid()) {
                    QueryDatabase queryDatabase = (QueryDatabase)QueryEditor.this.queryDatabaseSelectionWidget.tryGetSelected();
                    List<String> parameters = ExpressionUtil.extractParameters((String)QueryEditor.this.statementField.getValue());
                    if ((parameters = ExpressionUtil.createDistinctParametersList(parameters)).size() > 0) {
                        new BindingsDialog(QueryEditor.this.viewContext, parameters, queryDatabase, new QueryExecutor(){

                            @Override
                            public void execute(QueryParameterBindings parameterBindings) {
                                QueryEditor.this.runQuery(parameterBindings);
                            }
                        }).show();
                    } else {
                        QueryEditor.this.runQuery(new QueryParameterBindings());
                    }
                }
            }
        });
        return testButton;
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[0];
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
    }

    protected void register(AsyncCallback<Void> registrationCallback) {
        String name = (String)this.nameField.getValue();
        String description = (String)this.descriptionField.getValue();
        String statement = (String)this.statementField.getValue();
        boolean isPublic = this.isPublicField.getValue();
        QueryType queryType = (QueryType)this.queryTypeField.getSimpleValue();
        QueryDatabase queryDatabase = (QueryDatabase)this.queryDatabaseSelectionWidget.tryGetSelected();
        String entityTypeOrNull = this.tryExtractEntityTypeCode(queryType);
        if (this.queryOrNull == null) {
            NewQuery query = new NewQuery();
            query.setName(name);
            query.setDescription(description);
            query.setExpression(statement);
            query.setPublic(isPublic);
            query.setQueryType(queryType);
            query.setQueryDatabase(queryDatabase);
            query.setEntityTypeCode(entityTypeOrNull);
            this.viewContext.getService().registerQuery(query, registrationCallback);
        } else {
            this.queryOrNull.setName(name);
            this.queryOrNull.setDescription(description);
            this.queryOrNull.setExpression(statement);
            this.queryOrNull.setPublic(isPublic);
            this.queryOrNull.setQueryType(queryType);
            this.queryOrNull.setQueryDatabase(queryDatabase);
            this.queryOrNull.setEntityTypeCode(entityTypeOrNull);
            this.viewContext.getService().updateQuery(this.queryOrNull, registrationCallback);
        }
    }

    private void runQuery(QueryParameterBindings parameterBindings) {
        String sqlStatement = (String)this.statementField.getValue();
        QueryDatabase queryDatabase = (QueryDatabase)this.queryDatabaseSelectionWidget.tryGetSelected();
        if (sqlStatement != null && sqlStatement.length() > 0 && queryDatabase != null) {
            IReportInformationProvider reportInformation = this.createReportInformationProvider(sqlStatement);
            this.viewContext.getService().createQueryResultsReport(queryDatabase, sqlStatement, parameterBindings, ReportGeneratedCallback.create(this.viewContext.getCommonViewContext(), reportInformation, reportInformation.getKey(), this.createDisplayQueryResultsAction()));
        }
    }

    private IReportInformationProvider createReportInformationProvider(final String sqlQuery) {
        return new IReportInformationProvider(){

            @Override
            public String getDownloadURL() {
                return null;
            }

            @Override
            public String getKey() {
                return Integer.toString(sqlQuery.hashCode());
            }
        };
    }

    private ReportGeneratedCallback.IOnReportComponentGeneratedAction createDisplayQueryResultsAction() {
        return new ReportGeneratedCallback.IOnReportComponentGeneratedAction(){

            @Override
            public void execute(IDisposableComponent reportComponent) {
                QueryEditor.this.removeAll();
                QueryEditor.this.dispose();
                QueryEditor.this.add(reportComponent.getComponent());
                QueryEditor.this.reportAsDisposable = reportComponent;
                if (QueryEditor.this.getHeight() < QueryEditor.this.parentHeight) {
                    QueryEditor.this.setHeight(QueryEditor.this.parentHeight);
                }
                QueryEditor.this.layout();
            }
        };
    }

    static class QueryTypeComboBox
    extends SimpleComboBox<QueryType> {
        public QueryTypeComboBox(IMessageProvider messages) {
            this.setFireChangeEventOnSetValue(true);
            this.setAllowBlank(false);
            this.setEditable(false);
            this.setTriggerAction(ComboBox.TriggerAction.ALL);
            this.setFieldLabel(messages.getMessage("query_type", new Object[0]));
            this.add(Arrays.asList(QueryType.values()));
        }
    }

    private static final class BindingsDialog
    extends Dialog {
        private final List<IParameterField> parameterFields;
        private final QueryExecutor queryExecutor;

        public BindingsDialog(final IViewContext<IQueryClientServiceAsync> viewContext, List<String> parameters, final QueryDatabase queryDatabase, QueryExecutor queryExecutor) {
            this.queryExecutor = queryExecutor;
            this.setHeading(viewContext.getMessage("query_parameters_binding_dialog_title", new Object[0]));
            this.setModal(true);
            this.setScrollMode(Style.Scroll.AUTO);
            this.setHideOnButtonClick(true);
            this.setButtons("");
            final FormPanel form = new FormPanel();
            form.setHeaderVisible(false);
            form.setBorders(false);
            form.setBodyBorder(false);
            form.setLabelWidth(150);
            form.setFieldWidth(250);
            this.parameterFields = new ArrayList<IParameterField>();
            IParameterValuesLoader parameterValuesloader = new IParameterValuesLoader(){

                @Override
                public void loadData(String queryExpression, AbstractAsyncCallback<List<ParameterValue>> listParameterValuesCallback) {
                    ((IQueryClientServiceAsync)viewContext.getService()).listParameterValues(queryDatabase, queryExpression, listParameterValuesCallback);
                }
            };
            for (String parameter : parameters) {
                IParameterField parameterField = ParameterField.create(viewContext, parameter, null, IDelegatedAction.DO_NOTHING, parameterValuesloader);
                this.parameterFields.add(parameterField);
                form.add(parameterField.asWidget());
            }
            this.add((Widget)form, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
            this.addButton(new Button(viewContext.getMessage("button_submit", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

                public final void componentSelected(ButtonEvent ce) {
                    if (form.isValid()) {
                        this.prepareBindingsAndExecuteQuery();
                        this.hide();
                    }
                }
            }));
            this.addButton(QueryEditor.createCancelButton(viewContext, (Window)this));
            this.setWidth(500);
        }

        private void prepareBindingsAndExecuteQuery() {
            QueryParameterBindings bindings = new QueryParameterBindings();
            for (IParameterField field : this.parameterFields) {
                bindings.addBinding(field.getParameterWithValue());
            }
            this.queryExecutor.execute(bindings);
        }
    }

    private static interface QueryExecutor {
        public void execute(QueryParameterBindings var1);
    }
}

