/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.QueryType;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.IQueryClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module.QueryModel;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryExpression;
import java.util.List;

public final class QuerySelectionWidget
extends DropDownList<QueryModel, QueryExpression> {
    private static final String LIST_ITEMS_CALLBACK = "ListItemsCallback";
    public static final String SUFFIX = "query";
    private final IViewContext<IQueryClientServiceAsync> viewContext;
    private final String initialQueryNameOrNull;
    private final QueryType queryType;
    private final BasicEntityType entityTypeOrNull;

    public QuerySelectionWidget(IViewContext<IQueryClientServiceAsync> viewContext, String initialQueryNameOrNull, QueryType queryType, BasicEntityType entityTypeOrNull) {
        super(viewContext, SUFFIX, SUFFIX, "name", SUFFIX, "queries");
        this.viewContext = viewContext;
        this.initialQueryNameOrNull = initialQueryNameOrNull;
        this.queryType = queryType;
        this.entityTypeOrNull = entityTypeOrNull;
        this.setCallbackId(QuerySelectionWidget.createCallbackId());
        this.setTemplate(GWTUtils.getTooltipTemplate("name", "tooltip"));
    }

    public static String createCallbackId() {
        return QuerySelectionWidget.class + LIST_ITEMS_CALLBACK;
    }

    @Override
    protected List<QueryModel> convertItems(List<QueryExpression> result) {
        return QueryModel.convert(result);
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<QueryExpression>> callback) {
        this.viewContext.getService().listQueries(this.queryType, this.entityTypeOrNull, new ListQueriesCallback(this.viewContext));
        callback.ignore();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.QUERY);
    }

    private void selectInitialValue() {
        if (this.initialQueryNameOrNull != null) {
            this.trySelectByName(this.initialQueryNameOrNull);
            this.updateOriginalValue();
        }
    }

    private void trySelectByName(String queryName) {
        try {
            GWTUtils.setSelectedItem(this, "name", queryName);
        }
        catch (IllegalArgumentException ex) {
            GWTUtils.alert("Error", "Query '" + queryName + "' doesn't exist.");
        }
    }

    private class ListQueriesCallback
    extends DropDownList.ListItemsCallback {
        protected ListQueriesCallback(IViewContext<?> viewContext) {
            super(QuerySelectionWidget.this, viewContext);
        }

        @Override
        public void process(List<QueryExpression> result) {
            super.process(result);
            QuerySelectionWidget.this.selectInitialValue();
        }
    }
}

