/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IParameterField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IParameterValuesLoader;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ParameterField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ParameterValue;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.QueryType;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.IQueryClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.QueryParameterValue;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module.AbstractQueryProviderToolbar;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module.QueryModel;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module.QuerySelectionWidget;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryDatabase;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryExpression;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryParameterBindings;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonGroup;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RunCannedQueryToolbar
extends AbstractQueryProviderToolbar {
    private static final int MAX_PARAMETER_COLUMNS = 6;
    private static final String INITIAL_PARAMETER_NAME_PREFIX = "_";
    private final ContentPanel parameterContainer;
    private final QuerySelectionWidget querySelectionWidget;
    private final Button resetButton;
    private final Collection<IParameterField> parameterFields;
    private final Map<String, QueryParameterValue> initialParameterValues;
    private final Map<String, String> initialFixedParameters;

    public static final RunCannedQueryToolbar createGeneric(IViewContext<IQueryClientServiceAsync> viewContext, String initialQueryNameOrNull, Map<String, QueryParameterValue> initialParameterValues) {
        return new RunCannedQueryToolbar(viewContext, initialQueryNameOrNull, initialParameterValues, QueryType.GENERIC, null);
    }

    public static final RunCannedQueryToolbar createTyped(IViewContext<IQueryClientServiceAsync> viewContext, String initialQueryNameOrNull, Map<String, QueryParameterValue> initialParameterValues, QueryType queryType, BasicEntityType entityTypeOrNull) {
        return new RunCannedQueryToolbar(viewContext, initialQueryNameOrNull, initialParameterValues, queryType, entityTypeOrNull);
    }

    private RunCannedQueryToolbar(IViewContext<IQueryClientServiceAsync> viewContext, String initialQueryNameOrNull, Map<String, QueryParameterValue> initialParameterValues, QueryType queryType, BasicEntityType entityTypeOrNull) {
        super(viewContext);
        this.initialParameterValues = initialParameterValues;
        this.initialFixedParameters = new HashMap<String, String>();
        this.querySelectionWidget = new QuerySelectionWidget(viewContext, initialQueryNameOrNull, queryType, entityTypeOrNull);
        this.parameterContainer = new ButtonGroup(6);
        this.parameterFields = new HashSet<IParameterField>();
        this.resetButton = new Button(viewContext.getMessage("button_reset", new Object[0]));
        this.add((Component)new LabelToolItem(viewContext.getMessage("query", new Object[0]) + ": "));
        this.add((Component)this.querySelectionWidget);
        this.add((Component)this.parameterContainer);
        this.add((Component)this.executeButton);
        this.add((Component)this.resetButton);
        this.querySelectionWidget.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<QueryModel>(){

            public void selectionChanged(SelectionChangedEvent<QueryModel> se) {
                RunCannedQueryToolbar.this.updateParameterFields();
                RunCannedQueryToolbar.this.tryExecuteQuery();
            }
        });
        this.querySelectionWidget.addPostRefreshCallback(new IDataRefreshCallback(){

            @Override
            public void postRefresh(boolean wasSuccessful) {
                RunCannedQueryToolbar.this.updateParameterFields();
                RunCannedQueryToolbar.this.tryExecuteQuery();
            }
        });
        this.resetButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                RunCannedQueryToolbar.this.resetParameterFields();
                RunCannedQueryToolbar.this.tryExecuteQuery();
            }
        });
    }

    protected void updateParameterFields() {
        boolean queriesAvailable = this.querySelectionWidget.getStore().getCount() > 0;
        this.setEnabled(queriesAvailable);
        this.executeButton.hide();
        this.removeAllParameterFields();
        QueryExpression queryOrNull = (QueryExpression)this.querySelectionWidget.tryGetSelected();
        if (queryOrNull != null) {
            this.createAndAddQueryParameterFields(queryOrNull);
            this.executeButton.show();
            this.updateExecuteButtonEnabledState();
        }
        boolean parametersAvailable = this.parameterContainer.getItemCount() > 0;
        this.resetButton.setVisible(parametersAvailable);
        this.parameterContainer.setVisible(parametersAvailable);
        this.layout();
    }

    private void createAndAddQueryParameterFields(final QueryExpression query) {
        this.parameterContainer.hide();
        IDelegatedAction updateExecuteButtonAction = new IDelegatedAction(){

            @Override
            public void execute() {
                RunCannedQueryToolbar.this.updateExecuteButtonEnabledState();
            }
        };
        IParameterValuesLoader parameterValuesloader = new IParameterValuesLoader(){

            @Override
            public void loadData(String queryExpression, AbstractAsyncCallback<List<ParameterValue>> listParameterValuesCallback) {
                ((IQueryClientServiceAsync)RunCannedQueryToolbar.this.viewContext.getService()).listParameterValues(query.getQueryDatabase(), queryExpression, listParameterValuesCallback);
            }
        };
        for (String parameterName : query.getParameters()) {
            String strippedParameterName = RunCannedQueryToolbar.stripMetadata(parameterName);
            QueryParameterValue initialValueOrNull = this.tryGetInitialValue(strippedParameterName);
            if (initialValueOrNull != null && initialValueOrNull.isFixed()) {
                this.addInitialBinding(strippedParameterName, initialValueOrNull.getValue());
                continue;
            }
            this.addParameterField(ParameterField.create(this.viewContext, parameterName, initialValueOrNull == null ? null : initialValueOrNull.getValue(), updateExecuteButtonAction, parameterValuesloader));
        }
    }

    private void addInitialBinding(String parameter, String value) {
        this.initialFixedParameters.put(parameter, value);
    }

    private QueryParameterValue tryGetInitialValue(String parameter) {
        return this.initialParameterValues.get(INITIAL_PARAMETER_NAME_PREFIX + parameter);
    }

    private void addParameterField(IParameterField parameterField) {
        this.parameterFields.add(parameterField);
        this.parameterContainer.add(parameterField.asWidget());
    }

    private void removeAllParameterFields() {
        this.parameterContainer.removeAll();
        this.parameterFields.clear();
    }

    private void updateExecuteButtonEnabledState() {
        this.executeButton.setEnabled(this.isQueryValid());
    }

    private void resetParameterFields() {
        for (IParameterField field : this.parameterFields) {
            field.asWidget().reset();
        }
        this.updateExecuteButtonEnabledState();
    }

    @Override
    protected boolean isQueryValid() {
        if (!this.querySelectionWidget.isValid()) {
            return false;
        }
        boolean valid = true;
        for (IParameterField field : this.parameterFields) {
            valid = field.asWidget().isValid() && valid;
        }
        return valid;
    }

    @Override
    public Long tryGetQueryId() {
        QueryExpression selectedQueryOrNull = (QueryExpression)this.querySelectionWidget.tryGetSelected();
        return selectedQueryOrNull == null ? null : selectedQueryOrNull.getId();
    }

    @Override
    public String tryGetSQLQuery() {
        QueryExpression selectedQueryOrNull = (QueryExpression)this.querySelectionWidget.tryGetSelected();
        return selectedQueryOrNull == null ? null : selectedQueryOrNull.getExpression();
    }

    @Override
    public QueryDatabase tryGetQueryDatabase() {
        QueryExpression selectedQueryOrNull = (QueryExpression)this.querySelectionWidget.tryGetSelected();
        return selectedQueryOrNull == null ? null : selectedQueryOrNull.getQueryDatabase();
    }

    @Override
    public QueryParameterBindings tryGetQueryParameterBindings() {
        QueryParameterBindings bindings = new QueryParameterBindings();
        for (String key : this.initialFixedParameters.keySet()) {
            bindings.addBinding(key, this.initialFixedParameters.get(key));
        }
        for (IParameterField field : this.parameterFields) {
            bindings.addBinding(field.getParameterWithValue());
        }
        return bindings;
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return this.querySelectionWidget.getRelevantModifications();
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.querySelectionWidget.update(observedModifications);
    }

    private static String stripMetadata(String parameterName) {
        int indexOfSeparator = parameterName.indexOf(ParameterField.PARAMETER_METADATA_SEPARATOR);
        return indexOfSeparator > -1 ? parameterName.substring(0, indexOfSeparator) : parameterName;
    }
}

