/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MultilineVarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.QueryType;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.Validator;

public class SQLQueryField
extends MultilineVarcharField {
    private static final String EMPTY_TEXT = "SELECT ... \nFROM ... \nWHERE ...";
    private static final String EMPTY_TEXT_WITH_KEY = "SELECT ... \nFROM ... \nWHERE ... '${key}' ...";
    private static final String EMPTY_TEXT_WITH_KEY_AND_TYPE = "SELECT ... \nFROM ... \nWHERE ... '${key}' ... ... '${type}'";
    private static final String TYPE_REGEX = "\\$\\{type(::[^{}]+){0,1}\\}";
    private static final String KEY_REGEX = "\\$\\{key(::[^{}]+){0,1}\\}";
    private static final String ANY_REGEX = "(.|[\\n\\r])*";
    private static final String SELECT_REGEX = "^(select|SELECT)(.|[\\n\\r])*";
    private static final String SELECT_WITH_KEY_REGEX = "^(select|SELECT)(.|[\\n\\r])*\\$\\{key(::[^{}]+){0,1}\\}(.|[\\n\\r])*";
    private static final String SELECT_WITH_KEY_AND_TYPE_REGEX = "^(select|SELECT)(.|[\\n\\r])*\\$\\{key(::[^{}]+){0,1}\\}(.|[\\n\\r])*\\$\\{type(::[^{}]+){0,1}\\}(.|[\\n\\r])*";
    private static final String REGEX_TEXT_MSG = "SQL query should begin with a 'SELECT' keyword.";
    private static final String REGEX_TEXT_WITH_KEY_MSG = "SQL query should begin with a 'SELECT' keyword. Magic parameter '${key}' is required.";
    private static final String REGEX_TEXT_WITH_KEY_AND_TYPE_MSG = "SQL query should begin with a 'SELECT' keyword. Magic parameter '${key}' is required. Magic parameter '${type}' required.";
    private static final String SINGLE_QUERY_MSG = "SQL query should not contain ';' in the middle.";
    private static final String BLANK_TEXT_MSG = "SQL query text required";

    public SQLQueryField(IMessageProvider messageProvider, boolean mandatory, int lines) {
        super(messageProvider.getMessage("sql_query", new Object[0]), mandatory, lines);
        this.updateQueryType(QueryType.GENERIC);
        this.treatTabKeyAsInput();
    }

    public SQLQueryField(IMessageProvider messageProvider, boolean mandatory) {
        this(messageProvider, mandatory, 5);
    }

    public void updateQueryType(QueryType type) {
        this.setEmptyText(SQLQueryField.createEmptyText(type));
        this.setRegex(SQLQueryField.createRegex(type));
        this.setValidator(new SingleSQLQueryValidator());
        this.getMessages().setRegexText(SQLQueryField.createRegexText(type));
        this.getMessages().setBlankText(SQLQueryField.createBlankText(type));
        this.validate();
    }

    private static String createBlankText(QueryType type) {
        return BLANK_TEXT_MSG;
    }

    private static String createRegexText(QueryType type) {
        switch (type) {
            case GENERIC: {
                return REGEX_TEXT_MSG;
            }
            case DATA_SET: 
            case SAMPLE: 
            case EXPERIMENT: {
                return REGEX_TEXT_WITH_KEY_MSG;
            }
            case MATERIAL: {
                return REGEX_TEXT_WITH_KEY_AND_TYPE_MSG;
            }
        }
        return null;
    }

    private static String createRegex(QueryType type) {
        switch (type) {
            case GENERIC: {
                return SELECT_REGEX;
            }
            case DATA_SET: 
            case SAMPLE: 
            case EXPERIMENT: {
                return SELECT_WITH_KEY_REGEX;
            }
            case MATERIAL: {
                return SELECT_WITH_KEY_AND_TYPE_REGEX;
            }
        }
        return null;
    }

    private static String createEmptyText(QueryType type) {
        switch (type) {
            case GENERIC: {
                return EMPTY_TEXT;
            }
            case DATA_SET: 
            case SAMPLE: 
            case EXPERIMENT: {
                return EMPTY_TEXT_WITH_KEY;
            }
            case MATERIAL: {
                return EMPTY_TEXT_WITH_KEY_AND_TYPE;
            }
        }
        return null;
    }

    protected class SingleSQLQueryValidator
    implements Validator {
        protected SingleSQLQueryValidator() {
        }

        public String validate(Field<?> field, String fieldValue) {
            int indexOfSemicolon = fieldValue.trim().indexOf(59);
            if (indexOfSemicolon >= 0 && indexOfSemicolon < fieldValue.length() - 1) {
                return SQLQueryField.SINGLE_QUERY_MSG;
            }
            return null;
        }
    }
}

