/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.server;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.common.utilities.Counters;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DateTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DoubleTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IntegerTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.StringTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.generic.shared.util.DataTypeUtils;
import ch.systemsx.cisd.openbis.plugin.query.server.IDAO;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryParameterBindings;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.support.JdbcUtils;

public class DAO
extends JdbcDaoSupport
implements IDAO {
    private static final int FETCH_SIZE = 1000;
    private static final int MAX_ROWS = 100000;
    private static final int QUERY_TIMEOUT_SECS = 300;
    private static final String ENTITY_COLUMN_NAME_SUFFIX = "_KEY";
    private static final Map<String, Integer> SQL_TYPE_CODE_TO_TYPE_MAP = new HashMap<String, Integer>();
    private static final Map<Integer, String> SQL_TYPE_TO_TYPE_CODE_MAP = new HashMap<Integer, String>();
    private static Map<String, EntityKind> entityKindByColumnName;

    private static EntityKind tryGetEntityKind(String columnName) {
        return entityKindByColumnName.get(columnName.toUpperCase());
    }

    public DAO(DataSource dataSource) {
        this.setDataSource(dataSource);
        this.afterPropertiesSet();
    }

    public static void checkQuery(String sqlQuery) {
        if (!sqlQuery.toLowerCase().trim().startsWith("select")) {
            throw new UserFailureException("Sorry, only select statements are allowed.");
        }
        int indexOfSemicolon = sqlQuery.trim().indexOf(59);
        if (indexOfSemicolon >= 0 && indexOfSemicolon < sqlQuery.trim().length() - 1) {
            throw new UserFailureException("Sorry, only one query statement is allowed: A ';' somewhere in the middle has been found.");
        }
    }

    @Override
    public TableModel query(String sqlQuery, QueryParameterBindings bindingsOrNull) {
        DAO.checkQuery(sqlQuery);
        PreparedStatementCallback callback = new PreparedStatementCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                ResultSet resultSet = null;
                try {
                    resultSet = ps.executeQuery();
                    ResultSetMetaData metaData = ps.getMetaData();
                    ArrayList<TableModelColumnHeader> headers = new ArrayList<TableModelColumnHeader>();
                    int columnCount = metaData.getColumnCount();
                    Counters counters = new Counters();
                    for (int i = 1; i <= columnCount; ++i) {
                        int count;
                        String columnName;
                        String id = columnName = JdbcUtils.lookupColumnName((ResultSetMetaData)metaData, (int)i);
                        EntityKind entityKindOrNull = DAO.tryGetEntityKind(columnName);
                        if (entityKindOrNull != null) {
                            columnName = entityKindOrNull.getDescription();
                            id = entityKindOrNull.name();
                        }
                        if ((count = counters.count((Object)id)) > 1) {
                            id = id + count;
                        }
                        TableModelColumnHeader header = new TableModelColumnHeader(columnName, id, i - 1);
                        header.setDataType(DataTypeUtils.getDataTypeCode(metaData.getColumnType(i)));
                        header.setEntityKind(entityKindOrNull);
                        headers.add(header);
                    }
                    ArrayList<TableModelRow> rows = new ArrayList<TableModelRow>();
                    int rowCounter = 0;
                    String messageOrNull = null;
                    while (resultSet.next()) {
                        if (++rowCounter > 100000) {
                            messageOrNull = String.format("Result size is limited to a maximum of %d.", 100000);
                            break;
                        }
                        rows.add(this.createRow(resultSet, columnCount));
                    }
                    TableModel tableModel = new TableModel(headers, rows, messageOrNull);
                    return tableModel;
                }
                finally {
                    JdbcUtils.closeResultSet((ResultSet)resultSet);
                }
            }

            private TableModelRow createRow(ResultSet resultSet, int columnCount) throws SQLException {
                ArrayList<ISerializableComparable> cells = new ArrayList<ISerializableComparable>();
                for (int i = 1; i <= columnCount; ++i) {
                    Object value = JdbcUtils.getResultSetValue((ResultSet)resultSet, (int)i);
                    if (value instanceof Integer || value instanceof Long) {
                        cells.add(new IntegerTableCell(((Number)value).longValue()));
                        continue;
                    }
                    if (value instanceof Number) {
                        Number number = (Number)value;
                        cells.add(new DoubleTableCell(number.doubleValue()));
                        continue;
                    }
                    if (value instanceof java.util.Date) {
                        java.util.Date date = (java.util.Date)value;
                        cells.add(new DateTableCell(date));
                        continue;
                    }
                    String string = value == null ? "" : value.toString();
                    cells.add(new StringTableCell(string));
                }
                TableModelRow row = new TableModelRow(cells);
                return row;
            }
        };
        JdbcTemplate template = this.getJdbcTemplate();
        template.setFetchSize(1000);
        template.setMaxRows(100001);
        template.setQueryTimeout(300);
        PreparedStatementCreator resolvedQuery = DAO.createSQLPreparedStatement(sqlQuery, bindingsOrNull);
        return (TableModel)template.execute(resolvedQuery, callback);
    }

    private static PreparedStatementCreator createSQLPreparedStatement(final String sqlQuery, final QueryParameterBindings bindingsOrNull) {
        return new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                HashMap<Integer, Map.Entry<String, String>> indexMap = new HashMap<Integer, Map.Entry<String, String>>();
                Template template = new Template(sqlQuery);
                HashSet<String> arrayVariableNames = new HashSet<String>();
                this.addToSet(template.replaceBrackets("'{", "}'", "", ""), arrayVariableNames);
                template.replaceBrackets("'", "'", "", "");
                this.addToSet(template.replaceBrackets("{", "}", "", ""), arrayVariableNames);
                for (String string : arrayVariableNames) {
                    Template.IToken token = template.tryGetRightNeighbor(string);
                    if (token == null || token.tryGetValue() == null || token.tryGetValue().startsWith("::text[]")) continue;
                    token.setSubString(0, 0, "::text[]", "");
                }
                if (bindingsOrNull != null) {
                    for (Map.Entry entry : bindingsOrNull.getBindings().entrySet()) {
                        template.bind((String)entry.getKey(), "?");
                        int index = template.tryGetIndex((String)entry.getKey());
                        if (index < 0) continue;
                        indexMap.put(index, entry);
                    }
                }
                PreparedStatement psm = con.prepareStatement(template.createText());
                ParameterTypeProvider parameterTypeProvider = new ParameterTypeProvider(template, indexMap, psm.getParameterMetaData());
                for (int i = 1; i <= parameterTypeProvider.getParameterCount(); ++i) {
                    Map.Entry entry = (Map.Entry)indexMap.get(i - 1);
                    if (entry == null) {
                        throw new SQLDataException("No variable found for parameter " + i);
                    }
                    String strValue = (String)entry.getValue();
                    try {
                        switch (parameterTypeProvider.getParameterType(i)) {
                            case -7: 
                            case 16: {
                                psm.setBoolean(i, Boolean.parseBoolean(strValue));
                                break;
                            }
                            case -6: {
                                psm.setByte(i, Byte.parseByte(strValue));
                                break;
                            }
                            case 5: {
                                psm.setShort(i, Short.parseShort(strValue));
                                break;
                            }
                            case 4: {
                                psm.setInt(i, Integer.parseInt(strValue));
                                break;
                            }
                            case -5: {
                                psm.setLong(i, Long.parseLong(strValue));
                                break;
                            }
                            case 6: 
                            case 7: {
                                psm.setFloat(i, Float.parseFloat(strValue));
                                break;
                            }
                            case 8: {
                                psm.setDouble(i, Double.parseDouble(strValue));
                                break;
                            }
                            case 2: 
                            case 3: {
                                psm.setBigDecimal(i, new BigDecimal(strValue));
                                break;
                            }
                            case -16: 
                            case -15: 
                            case -9: 
                            case -1: 
                            case 1: 
                            case 12: {
                                psm.setString(i, strValue);
                                break;
                            }
                            case 2003: {
                                psm.setString(i, arrayVariableNames.contains(entry.getKey()) ? "{" + strValue + "}" : strValue);
                                break;
                            }
                            case 92: {
                                psm.setTime(i, Time.valueOf(strValue));
                                break;
                            }
                            case 91: {
                                psm.setDate(i, Date.valueOf(strValue));
                                break;
                            }
                            case 93: {
                                psm.setTimestamp(i, Timestamp.valueOf(strValue));
                                break;
                            }
                            default: {
                                throw new SQLDataException("Unsupported SQL type " + parameterTypeProvider.getParameterTypeName(i) + "(" + parameterTypeProvider.getParameterType(i) + ") for variable " + (String)entry.getKey());
                            }
                        }
                        continue;
                    }
                    catch (RuntimeException ex) {
                        throw new SQLDataException("Invalid value '" + (String)entry.getValue() + "' for variable " + (String)entry.getKey(), ex);
                    }
                }
                return psm;
            }

            private void addToSet(List<Template.IToken> tokens, Set<String> nameSet) {
                for (Template.IToken token : tokens) {
                    nameSet.add(token.tryGetName());
                }
            }
        };
    }

    static {
        SQL_TYPE_CODE_TO_TYPE_MAP.put("ARRAY", 2003);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("BIGINT", -5);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("BINARY", -2);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("BIT", -7);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("BLOB", 2004);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("BOOLEAN", 16);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("CHAR", 1);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("CLOB", 2005);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("DATALINK", 70);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("DATE", 91);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("DECIMAL", 3);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("DISTINCT", 2001);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("DOUBLE", 8);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("FLOAT", 6);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("INTEGER", 4);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("JAVA_OBJECT", 2000);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("LONGNVARCHAR", -16);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("LONGVARBINARY", -4);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("LONGVARCHAR", -1);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("NCHAR", -15);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("NCLOB", 2011);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("NULL", 0);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("NUMERIC", 2);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("NVARCHAR", -9);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("OTHER", 1111);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("REAL", 7);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("REF", 2006);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("ROWID", -8);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("SMALLINT", 5);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("SQLXML", 2009);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("STRUCT", 2002);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("TIME", 92);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("TIMESTAMP", 93);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("TINYINT", -6);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("VARBINARY", -3);
        SQL_TYPE_CODE_TO_TYPE_MAP.put("VARCHAR", 12);
        for (Map.Entry<String, Integer> entry : SQL_TYPE_CODE_TO_TYPE_MAP.entrySet()) {
            SQL_TYPE_TO_TYPE_CODE_MAP.put(entry.getValue(), entry.getKey());
        }
        SQL_TYPE_CODE_TO_TYPE_MAP.put("STRING", 12);
        entityKindByColumnName = new HashMap<String, EntityKind>();
        for (EntityKind entityKind : EntityKind.values()) {
            entityKindByColumnName.put(entityKind.name() + ENTITY_COLUMN_NAME_SUFFIX, entityKind);
        }
    }

    private static class ParameterTypeProvider {
        private static final String TYPE_PREFIX = "type=";
        private static final String META_DATA_SEPARATOR = "::";
        private final Template template;
        private final Map<Integer, Map.Entry<String, String>> indexMap;
        private final ParameterMetaData paramMD;

        ParameterTypeProvider(Template template, Map<Integer, Map.Entry<String, String>> indexMap, ParameterMetaData paramMD) {
            this.template = template;
            this.indexMap = indexMap;
            this.paramMD = paramMD;
        }

        int getParameterCount() throws SQLException {
            return this.paramMD.getParameterCount();
        }

        int getParameterType(int param) throws SQLException {
            Map.Entry<String, String> entry = this.indexMap.get(param - 1);
            String overrideTypeCode = this.tryGetOverrideTypeCode(entry);
            if (overrideTypeCode != null) {
                Integer paramType = (Integer)SQL_TYPE_CODE_TO_TYPE_MAP.get(overrideTypeCode);
                if (paramType == null) {
                    throw new SQLDataException("Invalid SQL type code '" + overrideTypeCode + "'");
                }
                return paramType;
            }
            return this.paramMD.getParameterType(param);
        }

        private String tryGetOverrideTypeCode(Map.Entry<String, String> entry) {
            String[] splitMD;
            String md = this.template.tryGetMetadata(entry.getKey());
            if (md == null) {
                return null;
            }
            for (String field : splitMD = md.split(META_DATA_SEPARATOR)) {
                if (!field.startsWith(TYPE_PREFIX)) continue;
                return field.substring(TYPE_PREFIX.length()).toUpperCase();
            }
            return null;
        }

        String getParameterTypeName(int param) throws SQLException {
            return (String)SQL_TYPE_TO_TYPE_CODE_MAP.get(this.getParameterType(param));
        }
    }
}

