/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.server;

import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.shared.AbstractServerLogger;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.QueryType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.query.shared.IQueryServer;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.IQueryUpdates;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.NewQuery;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryDatabase;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryExpression;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryParameterBindings;
import java.util.List;

class QueryServerLogger
extends AbstractServerLogger
implements IQueryServer {
    QueryServerLogger(ISessionManager<Session> sessionManager, IInvocationLoggerContext context) {
        super(sessionManager, context);
    }

    @Override
    public int initDatabases(String sessionToken) {
        this.logAccess(sessionToken, "init_databases");
        return 0;
    }

    public String tryToGetQueryDatabaseLabel(String sessionToken) {
        this.logAccess(sessionToken, "try_to_get_query_database_label");
        return null;
    }

    public List<String> listQueryDatabaseLabels(String sessionToken) {
        this.logAccess(sessionToken, "list_query_database_labels");
        return null;
    }

    @Override
    public List<QueryDatabase> listQueryDatabases(String sessionToken) {
        this.logAccess(sessionToken, "list_query_databases");
        return null;
    }

    @Override
    public List<QueryExpression> listQueries(String sessionToken, QueryType queryType, BasicEntityType entityTypeOrNull) {
        this.logAccess(sessionToken, "list_queries", "QUERY_TYPE(%s) ENTITY_TYPE(%s)", new Object[]{queryType, entityTypeOrNull});
        return null;
    }

    @Override
    public void registerQuery(String sessionToken, NewQuery expression) {
        this.logTracking(sessionToken, "register_query", "EXPRESSION(%s)", expression.getName());
    }

    @Override
    public void deleteQueries(String sessionToken, List<TechId> filterIds) {
        this.logTracking(sessionToken, "delete_queries", "QUERIES(%s)", filterIds.size());
    }

    @Override
    public void updateQuery(String sessionToken, IQueryUpdates updates) {
        this.logTracking(sessionToken, "update_query", "ID(%s) QUERY_NAME(%s)", updates.getId(), updates.getName());
    }

    @Override
    public TableModel queryDatabase(String sessionToken, QueryDatabase database, String sqlQuery, QueryParameterBindings bindings, boolean onlyPerform) {
        this.logAccess(sessionToken, "query_database", "DB(%s) SQL(%s) BINDINGS(%s) ACTION(%s)", database, sqlQuery, bindings, onlyPerform ? "perform" : "create & perform");
        return null;
    }

    @Override
    public TableModel queryDatabase(String sessionToken, TechId queryId, QueryParameterBindings bindings) {
        this.logAccess(sessionToken, "query_database", "QUERY(%s) BINDINGS(%s)", queryId, bindings);
        return null;
    }
}

