/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.server.authorization;

import ch.systemsx.cisd.openbis.generic.server.authorization.DefaultAccessController;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.IAuthorizationChecker;
import java.util.List;
import java.util.Set;

public class AuthorizationChecker
implements IAuthorizationChecker {
    private IAuthorizationConfig authorizationConfig;

    public AuthorizationChecker(IAuthorizationConfig authorizationConfig) {
        this.authorizationConfig = authorizationConfig;
    }

    @Override
    public boolean isAuthorized(PersonPE person, SpacePE dataSpaceOrNull, RoleWithHierarchy minimalRole) {
        if (person != null) {
            List<RoleWithIdentifier> userRoles = AuthorizationChecker.getUserRoles(person, minimalRole);
            if (userRoles.size() > 0) {
                if (dataSpaceOrNull == null) {
                    return true;
                }
                return AuthorizationChecker.isSpaceMatching(userRoles, dataSpaceOrNull);
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isAuthorized(PersonPE person, SpacePE dataSpaceOrNull, ProjectPE dataProjectOrNull, RoleWithHierarchy minimalRole) {
        if (person == null) {
            return false;
        }
        if (dataProjectOrNull == null) {
            return dataSpaceOrNull == null;
        }
        if (this.authorizationConfig.isProjectLevelEnabled() && this.authorizationConfig.isProjectLevelUser(person.getUserId())) {
            List<RoleWithIdentifier> userRoles = AuthorizationChecker.getUserRoles(person, minimalRole);
            return AuthorizationChecker.isProjectMatching(userRoles, dataProjectOrNull);
        }
        return false;
    }

    private static List<RoleWithIdentifier> getUserRoles(PersonPE person, RoleWithHierarchy minimalRole) {
        Set<RoleWithHierarchy> requiredRoles = minimalRole.getRoles();
        List<RoleWithIdentifier> userRoles = DefaultAccessController.getUserRoles(person);
        DefaultAccessController.retainMatchingRoleWithIdentifiers(userRoles, requiredRoles);
        return userRoles;
    }

    private static boolean isSpaceMatching(List<RoleWithIdentifier> userRoles, SpacePE requiredSpace) {
        for (RoleWithIdentifier role : userRoles) {
            RoleWithHierarchy.RoleLevel roleGroup = role.getRoleLevel();
            if (roleGroup.equals((Object)RoleWithHierarchy.RoleLevel.SPACE) && role.getAssignedSpace().equals(requiredSpace)) {
                return true;
            }
            if (!roleGroup.equals((Object)RoleWithHierarchy.RoleLevel.INSTANCE)) continue;
            return true;
        }
        return false;
    }

    private static boolean isProjectMatching(List<RoleWithIdentifier> userRoles, ProjectPE requiredProject) {
        for (RoleWithIdentifier role : userRoles) {
            RoleWithHierarchy.RoleLevel roleGroup = role.getRoleLevel();
            if (roleGroup.equals((Object)RoleWithHierarchy.RoleLevel.PROJECT) && role.getAssignedProject().equals(requiredProject)) {
                return true;
            }
            if (!roleGroup.equals((Object)RoleWithHierarchy.RoleLevel.INSTANCE)) continue;
            return true;
        }
        return false;
    }
}

