/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.server.authorization;

import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.AuthorizationChecker;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.QueryResultFilter;
import ch.systemsx.cisd.openbis.plugin.query.shared.DatabaseDefinition;
import java.util.Map;
import org.apache.log4j.Logger;

public class QueryAccessController {
    private static final Logger authorizationLog = LogFactory.getLogger((LogCategory)LogCategory.AUTH, QueryAccessController.class);
    private static IDAOFactory daoFactory;
    private static Map<String, DatabaseDefinition> definitionsByDbKey;

    public static void initialize(IDAOFactory factory, Map<String, DatabaseDefinition> definitions) {
        daoFactory = factory;
        definitionsByDbKey = definitions;
    }

    public static void checkWriteAccess(Session session, String dbKey, String operation) {
        DatabaseDefinition database = definitionsByDbKey.get(dbKey);
        PersonPE person = session.tryGetPerson();
        SpacePE dataSpaceOrNull = database.tryGetDataSpace();
        RoleWithHierarchy minimalRole = database.getCreatorMinimalRole();
        QueryAccessController.checkAuthorization(session, operation, database, person, dataSpaceOrNull, minimalRole);
    }

    public static void checkReadAccess(Session session, String dbKey) {
        DatabaseDefinition database = definitionsByDbKey.get(dbKey);
        PersonPE person = session.tryGetPerson();
        SpacePE dataSpaceOrNull = database.tryGetDataSpace();
        RoleWithHierarchy minimalRole = null;
        minimalRole = dataSpaceOrNull == null ? RoleWithHierarchy.PROJECT_OBSERVER : RoleWithHierarchy.SPACE_OBSERVER;
        QueryAccessController.checkAuthorization(session, "perform", database, person, dataSpaceOrNull, minimalRole);
    }

    private static void checkAuthorization(Session session, String operation, DatabaseDefinition database, PersonPE person, SpacePE dataSpaceOrNull, RoleWithHierarchy minimalRole) {
        if (!QueryAccessController.isAuthorized(person, dataSpaceOrNull, minimalRole)) {
            String errorMsg = QueryAccessController.createErrorMessage(operation, session.getUserName(), dataSpaceOrNull, minimalRole, database.getLabel());
            throw QueryAccessController.createAuthorizationError(session, operation, errorMsg);
        }
    }

    static boolean isAuthorized(PersonPE person, SpacePE dataSpaceOrNull, RoleWithHierarchy minimalRole) {
        return new AuthorizationChecker(daoFactory.getAuthorizationConfig()).isAuthorized(person, dataSpaceOrNull, minimalRole);
    }

    private static String createErrorMessage(String operation, String userName, SpacePE dataSpaceOrNull, RoleWithHierarchy minimalRole, String database) {
        String minimalRoleDescription = minimalRole.name();
        if (dataSpaceOrNull != null) {
            minimalRoleDescription = minimalRoleDescription + " in space " + dataSpaceOrNull.getCode();
        }
        return String.format("User '%s' does not have enough privileges to %s a query in database '%s'. One needs to be at least %s.", userName, operation, database, minimalRoleDescription);
    }

    private static AuthorizationFailureException createAuthorizationError(Session session, String operation, String errorMessage) {
        String groupCode = session.tryGetHomeGroupCode();
        authorizationLog.info((Object)String.format("[USER:'%s' SPACE:%s]: Authorization failure while trying to %s a query: %s", session.getUserName(), groupCode == null ? "<UNDEFINED>" : "'" + groupCode + "'", operation, errorMessage));
        return new AuthorizationFailureException(errorMessage);
    }

    public static TableModel filterResults(PersonPE person, String dbKey, IDAOFactory factory, TableModel table) {
        DatabaseDefinition database = definitionsByDbKey.get(dbKey);
        if (database.tryGetDataSpace() != null) {
            return table;
        }
        return new QueryResultFilter(factory).filterResults(person, table);
    }
}

