/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.DataSetDataLoader;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.ExperimentDataLoader;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.IEntityDataLoader;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.IEntityDataLoaderFactory;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.SampleDataLoader;

class EntityDataLoaderFactory
implements IEntityDataLoaderFactory {
    private final IDAOFactory factory;

    public EntityDataLoaderFactory(IDAOFactory factory) {
        this.factory = factory;
    }

    @Override
    public IEntityDataLoader create(EntityKind kind) {
        switch (kind) {
            case EXPERIMENT: {
                return new ExperimentDataLoader(this.factory.getExperimentDAO());
            }
            case SAMPLE: {
                return new SampleDataLoader(this.factory.getSampleDAO());
            }
            case DATA_SET: {
                return new DataSetDataLoader(this.factory.getDataDAO());
            }
            case MATERIAL: {
                throw new UnsupportedOperationException();
            }
        }
        throw new IllegalArgumentException();
    }
}

