/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IExperimentDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.IEntityDataLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ExperimentDataLoader
implements IEntityDataLoader {
    private final IExperimentDAO dao;

    public ExperimentDataLoader(IExperimentDAO dao) {
        this.dao = dao;
    }

    @Override
    public Map<String, SpacePE> loadGroups(Set<String> keys) {
        HashMap<String, SpacePE> map = new HashMap<String, SpacePE>();
        List<ExperimentPE> experiments = this.dao.listByPermID(keys);
        for (ExperimentPE e : experiments) {
            map.put(e.getPermId(), e.getProject().getSpace());
        }
        return map;
    }

    @Override
    public Map<String, ProjectPE> loadProjects(Set<String> keys) {
        HashMap<String, ProjectPE> map = new HashMap<String, ProjectPE>();
        List<ExperimentPE> experiments = this.dao.listByPermID(keys);
        for (ExperimentPE e : experiments) {
            map.put(e.getPermId(), e.getProject());
        }
        return map;
    }
}

