/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.AuthorizationChecker;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.IAuthorizationChecker;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.EntityDataLoaderFactory;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.IEntityDataLoaderFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryResultFilter {
    private final IEntityDataLoaderFactory dataLoaderFactory;
    private final IAuthorizationChecker authorizationChecker;
    private static final EntityKind[] FILTRABLE_ENTITY_KINDS = new EntityKind[]{EntityKind.EXPERIMENT, EntityKind.SAMPLE, EntityKind.DATA_SET};

    public QueryResultFilter(IDAOFactory daoFactory) {
        this.dataLoaderFactory = new EntityDataLoaderFactory(daoFactory);
        this.authorizationChecker = new AuthorizationChecker(daoFactory.getAuthorizationConfig());
    }

    @Private
    QueryResultFilter(IEntityDataLoaderFactory dataLoaderFactory, IAuthorizationChecker authorizationChecker) {
        this.dataLoaderFactory = dataLoaderFactory;
        this.authorizationChecker = authorizationChecker;
    }

    public TableModel filterResults(PersonPE person, TableModel table) {
        for (EntityKind kind : FILTRABLE_ENTITY_KINDS) {
            this.filterByKind(table, person, kind);
        }
        return table;
    }

    private void filterByKind(TableModel table, PersonPE person, EntityKind kind) {
        List<Integer> columnsToFilter = QueryResultFilter.getColumnsToFilter(table, kind);
        Set<String> entityIdentifiers = QueryResultFilter.getValues(table, columnsToFilter);
        Map<String, SpacePE> entitySpaces = this.loadGroups(entityIdentifiers, kind);
        Map<String, ProjectPE> entityProjects = this.loadProjects(entityIdentifiers, kind);
        Iterator<TableModelRow> rowIterator = table.getRows().iterator();
        block0: while (rowIterator.hasNext()) {
            TableModelRow row = rowIterator.next();
            for (int c : columnsToFilter) {
                ISerializableComparable value = row.getValues().get(c);
                if (value == null) continue;
                SpacePE entitySpace = entitySpaces.get(value.toString());
                ProjectPE entityProject = entityProjects.get(value.toString());
                if (this.canAccessSpace(person, entitySpace) || this.canAccessProject(person, entitySpace, entityProject)) continue;
                rowIterator.remove();
                continue block0;
            }
        }
    }

    private static Set<String> getValues(TableModel table, List<Integer> columns) {
        HashSet<String> values = new HashSet<String>();
        for (TableModelRow row : table.getRows()) {
            for (int c : columns) {
                ISerializableComparable value = row.getValues().get(c);
                if (value == null) continue;
                values.add(value.toString());
            }
        }
        return values;
    }

    private static List<Integer> getColumnsToFilter(TableModel table, EntityKind kind) {
        ArrayList<Integer> columns = new ArrayList<Integer>();
        for (int i = 0; i < table.getHeader().size(); ++i) {
            TableModelColumnHeader header = table.getHeader().get(i);
            EntityKind headerEntityKindOrNull = header.tryGetEntityKind();
            if (headerEntityKindOrNull == null || !headerEntityKindOrNull.equals((Object)kind)) continue;
            columns.add(i);
        }
        return columns;
    }

    private Map<String, SpacePE> loadGroups(Set<String> values, EntityKind kind) {
        return this.dataLoaderFactory.create(kind).loadGroups(values);
    }

    private Map<String, ProjectPE> loadProjects(Set<String> values, EntityKind kind) {
        return this.dataLoaderFactory.create(kind).loadProjects(values);
    }

    private boolean canAccessSpace(PersonPE person, SpacePE space) {
        return this.authorizationChecker.isAuthorized(person, space, RoleWithHierarchy.SPACE_OBSERVER);
    }

    private boolean canAccessProject(PersonPE person, SpacePE space, ProjectPE project) {
        return this.authorizationChecker.isAuthorized(person, space, project, RoleWithHierarchy.PROJECT_OBSERVER);
    }
}

