/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.IEntityDataLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SampleDataLoader
implements IEntityDataLoader {
    private final ISampleDAO dao;

    public SampleDataLoader(ISampleDAO dao) {
        this.dao = dao;
    }

    @Override
    public Map<String, SpacePE> loadGroups(Set<String> keys) {
        HashMap<String, SpacePE> map = new HashMap<String, SpacePE>();
        List<SamplePE> samples = this.dao.listByPermID(keys);
        for (SamplePE s : samples) {
            map.put(s.getPermId(), s.getSpace());
        }
        return map;
    }

    @Override
    public Map<String, ProjectPE> loadProjects(Set<String> keys) {
        HashMap<String, ProjectPE> map = new HashMap<String, ProjectPE>();
        List<SamplePE> samples = this.dao.listByPermID(keys);
        for (SamplePE s : samples) {
            ProjectPE project = null;
            if (s.getExperiment() != null) {
                project = s.getExperiment().getProject();
            } else if (s.getProject() != null) {
                project = s.getProject();
            }
            map.put(s.getPermId(), project);
        }
        return map;
    }
}

