/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application;

import ch.systemsx.cisd.cifex.client.Configuration;
import ch.systemsx.cisd.cifex.client.ICIFEXService;
import ch.systemsx.cisd.cifex.client.ICIFEXServiceAsync;
import ch.systemsx.cisd.cifex.client.InvalidSessionException;
import ch.systemsx.cisd.cifex.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.cifex.client.application.Model;
import ch.systemsx.cisd.cifex.client.application.PageController;
import ch.systemsx.cisd.cifex.client.application.ServletPathConstants;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.ui.PageControllerHelper;
import ch.systemsx.cisd.cifex.client.application.utils.GWTUtils;
import ch.systemsx.cisd.cifex.shared.basic.dto.CurrentUserInfoDTO;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.AnchorLayout;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;

public final class CIFEXEntryPoint
implements EntryPoint {
    private final Layout junk = new AnchorLayout();

    private static final ICIFEXServiceAsync createCIFEXService() {
        ICIFEXServiceAsync service = (ICIFEXServiceAsync)GWT.create(ICIFEXService.class);
        ServiceDefTarget endpoint = (ServiceDefTarget)service;
        endpoint.setServiceEntryPoint(ServletPathConstants.CIFEX_SERVLET_NAME);
        return service;
    }

    private final ViewContext createViewContext(ICIFEXServiceAsync cifexService) {
        PageController pageController = new PageController();
        ViewContext viewContext = new ViewContext(pageController, pageController, cifexService, new Model());
        pageController.setViewContext(viewContext);
        return viewContext;
    }

    public final void onModuleLoad() {
        final ICIFEXServiceAsync cifexService = CIFEXEntryPoint.createCIFEXService();
        final ViewContext viewContext = this.createViewContext(cifexService);
        String paramString = GWTUtils.getParamString();
        if (!StringUtils.isBlank((String)paramString)) {
            viewContext.getModel().setUrlParams(GWTUtils.parseParamString(paramString));
        }
        cifexService.getConfiguration((AsyncCallback<Configuration>)new AbstractAsyncCallback<Configuration>(viewContext){

            public final void onSuccess(Configuration result) {
                viewContext.getModel().setConfiguration(result);
                cifexService.getCurrentUser(new AsyncCallback<CurrentUserInfoDTO>(){

                    public final void onSuccess(CurrentUserInfoDTO currentUser) {
                        PageControllerHelper.activatePageBasedOnCurrentContext(viewContext, currentUser);
                    }

                    public final void onFailure(Throwable caught) {
                        if (caught instanceof InvalidSessionException) {
                            viewContext.getPageController().showLoginPage();
                        }
                    }
                });
            }
        });
    }
}

