/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application;

import ch.systemsx.cisd.cifex.client.Configuration;
import ch.systemsx.cisd.cifex.client.application.HTMLRequestCallback;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.WidgetFactory;
import ch.systemsx.cisd.cifex.client.application.page.HelpDialogController;
import ch.systemsx.cisd.cifex.client.application.utils.DOMUtils;
import ch.systemsx.cisd.cifex.client.application.utils.InfoDictionary;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;

final class FooterPanel
extends HorizontalPanel {
    FooterPanel(ViewContext context) {
        Configuration configuration = context.getModel().getConfiguration();
        assert (configuration != null) : "Must not be null reached this point.";
        Html applicationDescription = new Html(HelpDialogController.FOOTER_APPLICATION_DESCRIPTION);
        Html contactAdministrator = new Html(FooterPanel.createContactAdministrator(configuration));
        Html version = new Html(FooterPanel.createVersionDiv(configuration));
        Widget disclaimerLink = this.createDisclaimerLink();
        Widget documentationLink = this.createFAQLink();
        this.add((Widget)applicationDescription);
        this.add((Component)this.createSeparator());
        this.add((Widget)version);
        this.add((Component)this.createSeparator());
        this.add((Widget)contactAdministrator);
        this.add((Component)this.createSeparator());
        this.add(disclaimerLink);
        this.add((Component)this.createSeparator());
        this.add(documentationLink);
    }

    Html createSeparator() {
        return new Html("&nbsp;-&nbsp;");
    }

    private final Widget createDisclaimerLink() {
        return WidgetFactory.getLinkWidget(MessageDictionary.msg(MessageDictionary.HELP_DISCLAIMER_LABEL), new ClickHandler(){

            public void onClick(ClickEvent event) {
                try {
                    new RequestBuilder(RequestBuilder.GET, "disclaimer.html").sendRequest(null, (RequestCallback)new HTMLRequestCallback(MessageDictionary.msg(MessageDictionary.HELP_DISCLAIMER_TITLE)));
                }
                catch (RequestException ex) {
                    FooterPanel.this.showErrorMessage(ex);
                }
            }
        });
    }

    private final Widget createFAQLink() {
        return WidgetFactory.getLinkWidget(MessageDictionary.msg(MessageDictionary.HELP_FAQ_LABEL), new ClickHandler(){

            public void onClick(ClickEvent event) {
                try {
                    new RequestBuilder(RequestBuilder.GET, "faq.html").sendRequest(null, (RequestCallback)new HTMLRequestCallback(MessageDictionary.msg(MessageDictionary.HELP_FAQ_TITLE), 1000, 640));
                }
                catch (RequestException ex) {
                    FooterPanel.this.showErrorMessage(ex);
                }
            }
        });
    }

    private static final String createVersionDiv(Configuration configuration) {
        Element versionDiv = DOM.createDiv();
        DOM.setElementAttribute((Element)versionDiv, (String)"class", (String)"cifex-light-div");
        DOM.setInnerText((Element)versionDiv, (String)("(Version: " + configuration.getSystemVersion() + ")"));
        return DOM.toString((Element)versionDiv);
    }

    private static final String createContactAdministrator(Configuration configuration) {
        return DOMUtils.createEmailAnchor(InfoDictionary.info(InfoDictionary.SUPPORT_EMAIL), MessageDictionary.msg(MessageDictionary.HELP_CONTACT_SUPPORT_LABEL));
    }

    private final void showErrorMessage(Throwable ex) {
        String message = ex.getMessage();
        String msg = StringUtils.isBlank((String)message) ? MessageDictionary.msg(MessageDictionary.UNKNOWN_FAILURE_MSG, ex.getClass().getName()) : message;
        MessageBox.alert((String)MessageDictionary.msg(MessageDictionary.MESSAGE_BOX_ERROR_TITLE), (String)msg, null);
    }
}

