/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.model;

import ch.systemsx.cisd.cifex.client.application.model.AbstractUserGridModel;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class FileShareUserGridModel
extends AbstractUserGridModel {
    private static final String ID_PREFIX = "id:";
    private static final long serialVersionUID = 1L;
    public static final String SHARE_FILE = "shareFile";

    public FileShareUserGridModel(UserInfoDTO currentUser, UserInfoDTO user, boolean checkedUser) {
        super(currentUser);
        this.set("id", user.getID());
        this.set(SHARE_FILE, new Boolean(checkedUser));
        this.set("userCode", user.getUserCode());
        this.set("userEmail", user.getEmail());
        this.set("fullName", user.getUserFullName());
        this.set("registrator", user.getRegistrator());
        this.set("status", this.getUserRoleDescription(user));
        this.set("active", new Boolean(user.isActive()));
    }

    public static final List<FileShareUserGridModel> convert(UserInfoDTO currentUser, List<UserInfoDTO> users, ListStore<FileShareUserGridModel> storeOrNull) {
        if (users == null) {
            return null;
        }
        HashMap<String, Boolean> checkStatusMap = new HashMap<String, Boolean>();
        if (storeOrNull != null) {
            int i = 0;
            while (i < storeOrNull.getCount()) {
                FileShareUserGridModel m = (FileShareUserGridModel)storeOrNull.getAt(i);
                Boolean checkedUser = (Boolean)m.get(SHARE_FILE);
                String userCode = (String)m.get("userCode");
                if (userCode != null) {
                    checkStatusMap.put(ID_PREFIX + userCode, checkedUser);
                }
                checkStatusMap.put((String)m.get("userEmail"), checkedUser);
                ++i;
            }
        }
        ArrayList<FileShareUserGridModel> result = new ArrayList<FileShareUserGridModel>();
        for (UserInfoDTO user : users) {
            Boolean checkedUserValue;
            String userCodeOrNull = user.getUserCode();
            Boolean bl = checkedUserValue = StringUtils.isBlank((String)userCodeOrNull) ? null : (Boolean)checkStatusMap.get(ID_PREFIX + userCodeOrNull);
            if (checkedUserValue == null) {
                checkedUserValue = (Boolean)checkStatusMap.get(user.getEmail());
            }
            boolean checkedUser = !Boolean.FALSE.equals(checkedUserValue);
            result.add(new FileShareUserGridModel(currentUser, user, checkedUser));
        }
        return result;
    }

    @Override
    public long getID() {
        return (Long)this.get("id");
    }

    public static final List<ColumnConfig> getColumnConfigs() {
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        configs.add(FileShareUserGridModel.createIdColumnConfig());
        configs.add(FileShareUserGridModel.createShareFileCheckboxColumnConfig());
        configs.add(FileShareUserGridModel.createUserCodeColumnConfig());
        configs.add(FileShareUserGridModel.createUserEmailColumnConfig());
        configs.add(FileShareUserGridModel.createFullNameColumnConfig());
        configs.add(FileShareUserGridModel.createRegistratorColumnConfig());
        configs.add(FileShareUserGridModel.createSortableColumnConfig("status", MessageDictionary.msg(MessageDictionary.LIST_USERS_STATUS_COLUMN_HEADER), 195));
        return configs;
    }

    private static final ColumnConfig createShareFileCheckboxColumnConfig() {
        ColumnConfig columnConfig = FileShareUserGridModel.createSortableColumnConfig(SHARE_FILE, MessageDictionary.msg(MessageDictionary.LIST_USERS_FILESHARING_SHAREFLAG_COLUMN_HEADER), 45);
        columnConfig.setFixed(true);
        columnConfig.setRenderer((GridCellRenderer)new GridCellRenderer<FileShareUserGridModel>(){

            public Object render(FileShareUserGridModel model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<FileShareUserGridModel> store, Grid<FileShareUserGridModel> grid) {
                Object propertyValue = model.get(property);
                boolean checked = (Boolean)propertyValue;
                return "<img class=\"checkbox\" src=\"js/ext/resources/images/default/menu/" + (checked ? "checked.gif" : "unchecked.gif") + "\"/>";
            }
        });
        return columnConfig;
    }
}

