/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.page;

import ch.systemsx.cisd.cifex.client.application.HTMLRequestCallback;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.WidgetFactory;
import ch.systemsx.cisd.cifex.client.application.page.MainPageTabPanel;
import ch.systemsx.cisd.cifex.client.application.utils.DateTimeUtils;
import ch.systemsx.cisd.cifex.client.application.utils.ImageUtils;
import ch.systemsx.cisd.cifex.client.application.utils.InfoDictionary;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Viewport;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableRowLayout;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Widget;

public final class MainPage
extends Viewport {
    private static final int MAX_NAME_DISPLAY_LENGTH = 50;
    private static final int LOGO_WIDTH_IN_PIXELS = 81;
    private static final int HEADER_HEIGHT_IN_PIXELS = 50;
    private static final int BORDER_WIDTH_IN_PIXELS = 5;
    public static final String CISD_LOGO_TITLE = "CISD - Center for Information Sciences and Databases";
    private final ViewContext context;
    private final MainPageTabPanel tabPanel;

    public MainPage(ViewContext context, MainPageTabPanel tabPanel) {
        this.setLayout((Layout)new BorderLayout());
        this.context = context;
        this.tabPanel = tabPanel;
        BorderLayoutData headerLayoutData = new BorderLayoutData(Style.LayoutRegion.NORTH, 50.0f);
        headerLayoutData.setMargins(new Margins(5));
        this.add(this.createHeaderWidget(), (LayoutData)headerLayoutData);
        BorderLayoutData centerLayoutData = new BorderLayoutData(Style.LayoutRegion.CENTER);
        centerLayoutData.setMargins(new Margins(0, 5, 5, 5));
        this.add((Widget)this.tabPanel, (LayoutData)centerLayoutData);
    }

    private Widget createHeaderWidget() {
        LayoutContainer container = new LayoutContainer();
        TableRowLayout layout = new TableRowLayout();
        layout.setWidth("100%");
        container.setLayout((Layout)layout);
        Image cifexLogo = ImageUtils.getCIFEXLogoImageSmall();
        cifexLogo.setTitle(CISD_LOGO_TITLE);
        cifexLogo.setPixelSize(81, 50);
        Anchor cifexLogoLinked = new Anchor(cifexLogo.getElement().getString(), true, InfoDictionary.info(InfoDictionary.HEADER_WEBPAGE_LINK), "_blank");
        container.add((Widget)cifexLogoLinked, (LayoutData)new TableData(Style.HorizontalAlignment.LEFT, Style.VerticalAlignment.BOTTOM));
        container.add(this.createUserInfoWidget(), (LayoutData)new TableData(Style.HorizontalAlignment.RIGHT, Style.VerticalAlignment.MIDDLE));
        return container;
    }

    private Widget createUserInfoWidget() {
        boolean hasModifyableSettings;
        UserInfoDTO user = this.context.getModel().getUser();
        LayoutContainer container = new LayoutContainer();
        RowLayout layout = new RowLayout();
        container.setLayout((Layout)layout);
        container.add((Widget)this.userDescriptionInlineHTML(user));
        boolean bl = hasModifyableSettings = !user.isExternallyAuthenticated() && user.isPermanent();
        if (hasModifyableSettings) {
            container.add((Widget)new InlineHTML(" | "));
            container.add(this.createEditSettingsWidget());
        }
        container.add((Widget)new InlineHTML(" | "));
        container.add(this.createFAQWidget());
        container.add((Widget)new InlineHTML(" | "));
        container.add(this.createDisclamerWidget());
        container.add((Widget)new InlineHTML(" | "));
        container.add(this.createHelpWidget());
        container.add((Widget)new InlineHTML(" | "));
        container.add(this.createLogoutWidget());
        return container;
    }

    private InlineHTML userDescriptionInlineHTML(UserInfoDTO user) {
        boolean isTemporary;
        StringBuffer buffer = new StringBuffer();
        buffer.append(StringUtils.abbreviate((String)user.getUserCode(), (int)50));
        buffer.append(" (");
        String fullUserName = user.getUserFullName();
        if (fullUserName != null) {
            buffer.append(StringUtils.abbreviate((String)fullUserName, (int)50));
        } else {
            buffer.append(StringUtils.abbreviate((String)user.getEmail(), (int)50));
        }
        buffer.append(")");
        boolean bl = isTemporary = !user.isAdmin() && !user.isPermanent();
        if (isTemporary) {
            buffer.append("<i>&lt;valid until ");
            buffer.append(DateTimeUtils.formatDate(user.getExpirationDate()));
            buffer.append("&gt;</i>");
        }
        InlineHTML html = new InlineHTML(buffer.toString());
        if (user.isAdmin()) {
            html.setTitle("administrator");
        } else if (user.isPermanent()) {
            html.setTitle("regular user");
        } else {
            html.setTitle("temporary user");
        }
        return html;
    }

    private Widget createEditSettingsWidget() {
        Anchor html = this.clickableHTMLWidget(MessageDictionary.msg(MessageDictionary.PROFILE_LINK_LABEL), MessageDictionary.msg(MessageDictionary.PROFILE_LINK_TOOPTIP));
        html.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MainPage.this.context.getPageController().showEditCurrentUserPage();
            }
        });
        return html;
    }

    private Widget createLogoutWidget() {
        Anchor html = this.clickableHTMLWidget(MessageDictionary.msg(MessageDictionary.LOGOUT_LINK_LABEL), MessageDictionary.msg(MessageDictionary.LOGOUT_LINK_TOOLTIP));
        html.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MainPage.this.context.logoutAndShowLoginPage();
            }
        });
        return html;
    }

    private Widget createHelpWidget() {
        Anchor html = this.clickableHTMLWidget(MessageDictionary.msg(MessageDictionary.HELP_LINK_LABEL), MessageDictionary.msg(MessageDictionary.HELP_LINK_TOOLTIP));
        html.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MainPage.this.context.getPageController().showHelpPage();
            }
        });
        return html;
    }

    private Widget createFAQWidget() {
        Anchor html = this.clickableHTMLWidget(MessageDictionary.msg(MessageDictionary.HELP_FAQ_LABEL), MessageDictionary.msg(MessageDictionary.HELP_FAQ_TITLE));
        html.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                try {
                    new RequestBuilder(RequestBuilder.GET, "faq.html").sendRequest(null, (RequestCallback)new HTMLRequestCallback(MessageDictionary.msg(MessageDictionary.HELP_FAQ_TITLE), 1000, 640));
                }
                catch (RequestException ex) {
                    MainPage.this.showErrorMessage(ex);
                }
            }
        });
        return html;
    }

    private Widget createDisclamerWidget() {
        Anchor html = this.clickableHTMLWidget(MessageDictionary.msg(MessageDictionary.HELP_DISCLAIMER_LABEL), MessageDictionary.msg(MessageDictionary.HELP_DISCLAIMER_TITLE));
        html.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                try {
                    new RequestBuilder(RequestBuilder.GET, "disclaimer.html").sendRequest(null, (RequestCallback)new HTMLRequestCallback(MessageDictionary.msg(MessageDictionary.HELP_DISCLAIMER_TITLE)));
                }
                catch (RequestException ex) {
                    MainPage.this.showErrorMessage(ex);
                }
            }
        });
        return html;
    }

    private Anchor clickableHTMLWidget(String title, String tooltip) {
        return WidgetFactory.createClickableHTMLWidget(title, tooltip);
    }

    private final void showErrorMessage(Throwable ex) {
        String message = ex.getMessage();
        String msg = StringUtils.isBlank((String)message) ? MessageDictionary.msg(MessageDictionary.UNKNOWN_FAILURE_MSG, ex.getClass().getName()) : message;
        MessageBox.alert((String)MessageDictionary.msg(MessageDictionary.MESSAGE_BOX_ERROR_TITLE), (String)msg, null);
    }
}

