/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.page;

import ch.systemsx.cisd.cifex.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.cifex.client.application.EditUserDialog;
import ch.systemsx.cisd.cifex.client.application.IHistoryController;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.grid.GridWidget;
import ch.systemsx.cisd.cifex.client.application.model.AbstractFileGridModel;
import ch.systemsx.cisd.cifex.client.application.model.UserGridModel;
import ch.systemsx.cisd.cifex.client.application.page.UpdateAdminFileAsyncCallback;
import ch.systemsx.cisd.cifex.client.application.page.UpdateUploadedFileAsyncCallback;
import ch.systemsx.cisd.cifex.client.application.page.UserGridRefresherCallback;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;

final class UserActionGridCellListener
implements Listener<GridEvent<UserGridModel>> {
    private final ViewContext viewContext;
    private final GridWidget<UserGridModel> userGridWidget;
    private final GridWidget<AbstractFileGridModel> fileGridOrNull;

    UserActionGridCellListener(ViewContext viewContext, GridWidget<AbstractFileGridModel> filesGrid, GridWidget<UserGridModel> userGridWidget) {
        this.viewContext = viewContext;
        this.fileGridOrNull = filesGrid;
        this.userGridWidget = userGridWidget;
    }

    private static final String getUserDescription(UserGridModel model) {
        String fullName = (String)model.get("fullName");
        String userCode = (String)model.get("userCode");
        if (StringUtils.isBlank((String)fullName)) {
            return userCode;
        }
        return fullName;
    }

    public void handleEvent(GridEvent<UserGridModel> be) {
        Grid<UserGridModel> grid = this.userGridWidget.getGrid();
        int rowIndex = be.getRowIndex();
        int colIndex = be.getColIndex();
        Event e = be.getEvent();
        if (grid.getColumnModel().getDataIndex(colIndex).equals("action")) {
            UserGridModel model = (UserGridModel)grid.getStore().getAt(rowIndex);
            final long userId = (Long)model.get("id");
            final String userCode = (String)model.get("userCode");
            String userDescription = UserActionGridCellListener.getUserDescription(model);
            EventTarget element = e.getEventTarget();
            if (element == null) {
                return;
            }
            String targetId = DOM.getElementAttribute((com.google.gwt.user.client.Element)((com.google.gwt.user.client.Element)Element.as((JavaScriptObject)e.getEventTarget())), (String)"id");
            if ("delete".equals(targetId)) {
                assert (!userCode.equals(this.viewContext.getModel().getUser().getUserCode())) : "An user can not delete himself.";
                MessageBox.confirm((String)MessageDictionary.msg(MessageDictionary.DELETE_USER_MSGBOX_TITLE), (String)MessageDictionary.msg(MessageDictionary.DELETE_USER_CONFIRM_LABEL, userDescription), (Listener)new Listener<MessageBoxEvent>(){

                    public void handleEvent(MessageBoxEvent messageEvent) {
                        if (messageEvent.getButtonClicked().getItemId().equals("yes")) {
                            UserActionGridCellListener.this.viewContext.getCifexService().deleteUser(userId, new DeleteUserAsyncCallback(UserActionGridCellListener.this.viewContext, UserActionGridCellListener.this.userGridWidget, userId));
                        }
                    }
                });
            } else if ("edit".equals(targetId)) {
                if (userCode.equals(this.viewContext.getModel().getUser().getUserCode())) {
                    this.viewContext.getPageController().showEditCurrentUserPage();
                    return;
                }
                this.viewContext.getCifexService().tryFindUserByUserCode(userCode, new FindUserAsyncCallback(this.viewContext, this.userGridWidget, userCode));
            } else if ("change_user_code".equals(targetId)) {
                assert (!userCode.equals(this.viewContext.getModel().getUser().getUserCode())) : "A user cannot change his own code.";
                MessageBox.prompt((String)MessageDictionary.msg(MessageDictionary.RENAME_USER_MSGBOX_TITLE), (String)userCode, (Listener)new Listener<MessageBoxEvent>(){

                    public void handleEvent(MessageBoxEvent messageEvent) {
                        String userCodeAfterRenaming = messageEvent.getValue();
                        if (messageEvent.getButtonClicked().getItemId().equals("ok") && !StringUtils.isBlank((String)userCodeAfterRenaming)) {
                            if (!StringUtils.matches((String)"^([a-zA-Z0-9_\\.\\-\\@])+$", (String)userCodeAfterRenaming)) {
                                MessageBox.alert((String)MessageDictionary.msg(MessageDictionary.VALIDATION_INVALID_USER_CODE_TITLE), (String)MessageDictionary.msg(MessageDictionary.VALIDATION_INVALID_USER_CODE_MSG), null);
                            } else {
                                MessageBox.confirm((String)MessageDictionary.msg(MessageDictionary.RENAME_USER_CONFIRM_MSGBOX_TITLE), (String)MessageDictionary.msg(MessageDictionary.RENAME_USER_CONFIRM_LABEL, userCode, userCodeAfterRenaming), (Listener)new RenamingConfirmCallback(userCode, userCodeAfterRenaming, UserActionGridCellListener.this.userGridWidget));
                            }
                        }
                    }
                });
            }
        }
    }

    private final class DeleteUserAsyncCallback
    extends AbstractAsyncCallback<Void> {
        private final GridWidget<UserGridModel> grid;
        private final long id;

        public DeleteUserAsyncCallback(ViewContext context, GridWidget<UserGridModel> grid, long id) {
            super(context);
            this.grid = grid;
            this.id = id;
        }

        public final void onSuccess(Void dummy) {
            this.grid.removeItem(this.id);
        }
    }

    private final class FindUserAsyncCallback
    extends AbstractAsyncCallback<UserInfoDTO> {
        private final GridWidget<UserGridModel> grid;
        private final String userCode;

        public FindUserAsyncCallback(ViewContext context, GridWidget<UserGridModel> grid, String userCode) {
            super(context);
            this.grid = grid;
            this.userCode = userCode;
        }

        public final void onSuccess(UserInfoDTO resultOrNull) {
            if (resultOrNull == null) {
                MessageBox.alert((String)MessageDictionary.msg(MessageDictionary.MESSAGE_BOX_ERROR_TITLE), (String)MessageDictionary.msg(MessageDictionary.UNKNOWN_USER_MSG, this.userCode), null);
            }
            new EditUserDialog(UserActionGridCellListener.this.viewContext, resultOrNull, this.grid).show();
        }
    }

    private final class RenamingConfirmCallback
    implements Listener<MessageBoxEvent> {
        private final String userCode;
        private final String userCodeAfterRenaming;
        private final GridWidget<UserGridModel> userGrid;

        private RenamingConfirmCallback(String userCode, String userCodeAfterRenaming, GridWidget<UserGridModel> userGrid) {
            this.userCode = userCode;
            this.userCodeAfterRenaming = userCodeAfterRenaming;
            this.userGrid = userGrid;
        }

        public void handleEvent(MessageBoxEvent be) {
            if (be.getButtonClicked().getItemId().equals("yes")) {
                UserActionGridCellListener.this.viewContext.getCifexService().changeUserCode(this.userCode, this.userCodeAfterRenaming, new UsersFilesRefresherCallback(UserActionGridCellListener.this.viewContext, this.userGrid, UserActionGridCellListener.this.fileGridOrNull));
            }
        }
    }

    private static final class UsersFilesRefresherCallback
    extends AbstractAsyncCallback<Void> {
        private final GridWidget<UserGridModel> userGrid;
        private final GridWidget<AbstractFileGridModel> fileGrid;
        private final ViewContext context;

        public UsersFilesRefresherCallback(ViewContext context, GridWidget<UserGridModel> userGrid, GridWidget<AbstractFileGridModel> fileGridOrNull) {
            super(context);
            this.userGrid = userGrid;
            this.fileGrid = fileGridOrNull;
            this.context = context;
        }

        public void onSuccess(Void result) {
            boolean adminView = false;
            if (this.context.getHistoryController().getCurrentPage() == IHistoryController.Page.ADMIN_PAGE) {
                adminView = true;
            }
            new UserGridRefresherCallback(this.context, this.userGrid).onSuccess(result);
            if (this.fileGrid != null) {
                if (adminView) {
                    new UpdateAdminFileAsyncCallback(this.fileGrid, this.context).onSuccess(result);
                } else {
                    new UpdateUploadedFileAsyncCallback(this.fileGrid, this.context).onSuccess(result);
                }
            }
        }
    }
}

