/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.ui;

import ch.systemsx.cisd.cifex.client.ICIFEXServiceAsync;
import ch.systemsx.cisd.cifex.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.ui.UserWidget;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import com.extjs.gxt.ui.client.widget.MessageBox;

public class EditUserWidget
extends UserWidget {
    public EditUserWidget(ViewContext context, boolean addStatusField, UserInfoDTO user, boolean withButton) {
        super(context, addStatusField, user, withButton);
    }

    protected void finishEditing() {
    }

    @Override
    public final boolean submitForm() {
        ICIFEXServiceAsync cifexService = this.context.getCifexService();
        if (!this.arePasswordsEqual()) {
            return false;
        }
        if (this.isValid()) {
            if (this.buttonOrNull != null) {
                this.buttonOrNull.disable();
            }
            UserInfoDTO user = this.createFromFields();
            cifexService.updateUser(user, StringUtils.nullIfBlank((String)((String)this.passwordField.getValue())), this.sendUpdateInformation != null && this.sendUpdateInformation.getValue() != false, new UpdateUserAsyncCallBack());
            return true;
        }
        MessageBox.alert((String)MessageDictionary.msg(MessageDictionary.MESSAGE_BOX_ERROR_TITLE), (String)MessageDictionary.msg(MessageDictionary.CREATE_USER_INVALID_DATA_MSG), null);
        return false;
    }

    @Override
    public final String getSubmitButtonLabel() {
        return MessageDictionary.msg(MessageDictionary.EDIT_USER_UPDATE_BUTTON_LABEL);
    }

    private final class UpdateUserAsyncCallBack
    extends AbstractAsyncCallback<UserInfoDTO> {
        UpdateUserAsyncCallBack() {
            super(EditUserWidget.this.context);
        }

        @Override
        public final void onFailure(Throwable caught) {
            super.onFailure(caught);
            if (EditUserWidget.this.buttonOrNull != null) {
                EditUserWidget.this.buttonOrNull.enable();
            }
        }

        public final void onSuccess(UserInfoDTO result) {
            if (EditUserWidget.this.buttonOrNull != null) {
                EditUserWidget.this.buttonOrNull.enable();
            }
            UserInfoDTO currentUser = EditUserWidget.this.context.getModel().getUser();
            if (result.getID() == currentUser.getID()) {
                currentUser.updateFrom(result);
            }
            EditUserWidget.this.finishEditing();
        }
    }
}

