/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.ui;

import ch.systemsx.cisd.cifex.client.Configuration;
import ch.systemsx.cisd.cifex.client.application.UserUtils;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.ui.FormColumn;
import ch.systemsx.cisd.cifex.client.application.utils.CifexValidator;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.DateField;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.form.Validator;
import com.extjs.gxt.ui.client.widget.layout.ColumnData;
import com.extjs.gxt.ui.client.widget.layout.ColumnLayout;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import java.util.Date;

public abstract class UserWidget
extends LayoutContainer {
    private static final int FIELD_WIDTH = 175;
    public static final int TOTAL_WIDTH = 800;
    public static final int COLUMN_WIDTH = 370;
    protected final ViewContext context;
    protected final UserInfoDTO editUser;
    protected final boolean addStatusField;
    protected Button buttonOrNull;
    protected TextField<String> emailField;
    protected TextField<String> usernameField;
    protected TextField<String> userCodeField;
    protected TextField<String> passwordField;
    protected TextField<String> validatePasswordField;
    protected TextArea commentArea;
    protected CheckBox sendUpdateInformation;
    protected CheckBox userIsActiveField;
    protected CheckBox userIsExternallyAuthenticatedField;
    protected TextField<String> maxFileSizeField;
    protected TextField<String> maxFileCountField;
    protected TextField<String> fileRetentionField;
    protected TextField<String> userRetentionField;
    protected DateField expirationDateField;
    protected SimpleComboBox<String> statusField;
    private final boolean withButton;
    private FormPanel formPanel;

    public UserWidget(ViewContext context, boolean addStatusField) {
        this(context, addStatusField, null, true);
    }

    UserWidget(ViewContext context, boolean addStatusField, UserInfoDTO user, boolean withButton) {
        this.setLayout((Layout)new FlowLayout(5));
        this.setBorders(false);
        this.setWidth(800);
        this.context = context;
        this.addStatusField = addStatusField;
        this.editUser = user;
        this.withButton = withButton;
        this.createCreateUserForm();
    }

    protected UserInfoDTO createFromFields() {
        String text;
        Configuration config = this.context.getModel().getConfiguration();
        UserInfoDTO user = new UserInfoDTO();
        if (this.editUser != null) {
            user.setID(this.editUser.getID());
            user.updateFrom(this.editUser);
        }
        user.setEmail((String)this.emailField.getValue());
        user.setUserFullName((String)this.usernameField.getValue());
        user.setUserCode((String)this.userCodeField.getValue());
        if (this.addStatusField) {
            user.setAdmin(this.isAdminStatus());
        }
        user.setExpirationDate(this.tryGetExpirationDate(this.userExpires()));
        if (this.maxFileCountField != null) {
            text = (String)this.maxFileCountField.getValue();
            if (StringUtils.isBlank((String)text)) {
                user.setMaxFileCountPerQuotaGroup(config.getMaxFileCountPerQuotaGroup());
                user.setCustomMaxFileCountPerQuotaGroup(false);
            } else {
                user.setMaxFileCountPerQuotaGroup("unlimited".equals(text) ? null : new Integer(text));
                user.setCustomMaxFileCountPerQuotaGroup(true);
            }
        }
        if (this.maxFileSizeField != null) {
            text = (String)this.maxFileSizeField.getValue();
            if (StringUtils.isBlank((String)text)) {
                user.setMaxFileSizePerQuotaGroupInMB(config.getMaxFileSizePerQuotaGroupInMB());
                user.setCustomMaxFileSizePerQuotaGroup(false);
            } else {
                user.setMaxFileSizePerQuotaGroupInMB("unlimited".equals(text) ? null : new Long(text));
                user.setCustomMaxFileSizePerQuotaGroup(true);
            }
        }
        if (this.userIsActiveField != null) {
            user.setActive(this.userIsActiveField.getValue());
        }
        if (this.fileRetentionField != null) {
            text = (String)this.fileRetentionField.getValue();
            if (StringUtils.isBlank((String)text)) {
                user.setMaxFileRetention(config.getMaxFileRetention());
                user.setCustomMaxFileRetention(false);
            } else {
                user.setMaxFileRetention(new Integer(text));
                user.setCustomMaxFileRetention(true);
            }
        }
        if (this.userRetentionField != null) {
            text = (String)this.userRetentionField.getValue();
            if (StringUtils.isBlank((String)text)) {
                user.setMaxUserRetention(config.getMaxUserRetention());
                user.setCustomMaxUserRetention(false);
            } else {
                user.setMaxUserRetention(new Integer(text));
                user.setCustomMaxUserRetention(true);
            }
        }
        if (this.userIsExternallyAuthenticatedField != null) {
            user.setExternallyAuthenticated(this.userIsExternallyAuthenticatedField.getValue());
        }
        return user;
    }

    private boolean userExpires() {
        if (this.statusField != null) {
            return this.isTemporaryStatus();
        }
        if (this.editUser != null) {
            return !this.editUser.isPermanent();
        }
        return true;
    }

    private FormColumn createRightColumn(FormData formData) {
        FormColumn right = new FormColumn(formData);
        right.setStyleAttribute("paddingRight", "20px");
        UserInfoDTO currentUser = this.context.getModel().getUser();
        if (currentUser.isAdmin()) {
            this.fileRetentionField = this.createFileRetention();
            right.addField((Field<?>)this.fileRetentionField);
            this.userRetentionField = this.createUserRetention();
            right.addField((Field<?>)this.userRetentionField);
        }
        this.emailField = this.createEmailField();
        right.addField((Field<?>)this.emailField);
        this.passwordField = this.createPasswordField();
        right.addField((Field<?>)this.passwordField);
        this.validatePasswordField = this.createValidatePasswordField();
        right.addField((Field<?>)this.validatePasswordField);
        if (this.addStatusField) {
            this.statusField = this.createStatusComboBox();
            right.addField((Field<?>)this.statusField);
        }
        if (!currentUser.equals(this.editUser)) {
            this.expirationDateField = this.createExpirationDateField();
            right.addField((Field<?>)this.expirationDateField);
        }
        if (this.editUser == null && currentUser.isAdmin()) {
            this.userIsActiveField = this.createUserIsActiveCheckbox();
            right.addField((Field<?>)this.userIsActiveField);
        }
        return right;
    }

    private Date tryGetExpirationDate(boolean userExpires) {
        if (userExpires) {
            if (this.expirationDateField != null) {
                return (Date)this.expirationDateField.getValue();
            }
            return UserUtils.getDefaultUserExpirationDate(this.context);
        }
        return null;
    }

    private FormColumn createLeftColumn(FormData formData) {
        FormColumn left = new FormColumn(formData);
        left.setStyleAttribute("paddingRight", "20px");
        this.userCodeField = this.createUserCodeField();
        left.addField((Field<?>)this.userCodeField);
        this.usernameField = this.createUsernameField();
        left.addField((Field<?>)this.usernameField);
        if (this.editUser == null) {
            this.commentArea = this.createCommentArea();
            left.addField((Field<?>)this.commentArea);
        } else if (!this.editingMyself()) {
            this.sendUpdateInformation = this.createSendUserInformationCheckbox();
            left.addField((Field<?>)this.sendUpdateInformation);
        }
        UserInfoDTO currentUser = this.context.getModel().getUser();
        if (currentUser.isAdmin()) {
            this.maxFileSizeField = this.createMaxFileSizeField();
            left.addField((Field<?>)this.maxFileSizeField);
            this.maxFileCountField = this.createMaxFileCountField();
            left.addField((Field<?>)this.maxFileCountField);
        }
        if (this.editUser != null && !this.editingMyself() && currentUser.isAdmin()) {
            this.userIsActiveField = this.createUserIsActiveCheckbox();
            left.addField((Field<?>)this.userIsActiveField);
        }
        if (this.editUser != null && !this.editingMyself() && currentUser.isAdmin() && this.context.getModel().getConfiguration().getSystemHasExternalAuthentication().booleanValue()) {
            this.userIsExternallyAuthenticatedField = this.createUserIsExternallyAuthenticatedCheckbox();
            left.addField((Field<?>)this.userIsExternallyAuthenticatedField);
        }
        return left;
    }

    protected final void createCreateUserForm() {
        FormData formData = new FormData("95%");
        this.formPanel = new FormPanel();
        this.formPanel.setHeaderVisible(false);
        this.formPanel.setFrame(false);
        this.formPanel.setBodyBorder(false);
        this.formPanel.setBorders(false);
        this.formPanel.setButtonAlign(Style.HorizontalAlignment.CENTER);
        LayoutContainer main = new LayoutContainer();
        main.setLayout((Layout)new ColumnLayout());
        main.add((Widget)this.createLeftColumn(formData), (LayoutData)new ColumnData(370.0));
        main.add((Widget)this.createRightColumn(formData), (LayoutData)new ColumnData(370.0));
        this.formPanel.add((Widget)main);
        this.tryCreateButton((LayoutContainer)this.formPanel);
        if (this.editUser != null && this.editUser.isExternallyAuthenticated()) {
            this.disableInternalFields(true);
        }
        this.add((Component)this.formPanel);
    }

    public boolean isValid() {
        return this.formPanel.isValid();
    }

    protected boolean editingMyself() {
        return this.editUser != null && this.editUser.getUserCode().equals(this.context.getModel().getUser().getUserCode());
    }

    private final void tryCreateButton(LayoutContainer panel) {
        if (!this.withButton) {
            return;
        }
        this.buttonOrNull = new Button(this.getSubmitButtonLabel());
        panel.add((Widget)this.buttonOrNull);
        this.buttonOrNull.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                UserWidget.this.submitForm();
            }
        });
    }

    protected final boolean arePasswordsEqual() {
        if (!this.equalOrBothNull()) {
            MessageBox.alert((String)MessageDictionary.msg(MessageDictionary.MESSAGE_BOX_ERROR_TITLE), (String)MessageDictionary.msg(MessageDictionary.CREATE_USER_PASSWD_MISMATCH_MSG), null);
            return false;
        }
        return true;
    }

    private boolean equalOrBothNull() {
        return this.passwordField.getValue() == null && this.validatePasswordField.getValue() == null || ((String)this.passwordField.getValue()).equals(this.validatePasswordField.getValue());
    }

    private final boolean isStatus(String status) {
        assert (this.statusField != null) : "Undefined status field.";
        return ((String)this.statusField.getSimpleValue()).equals(status);
    }

    protected final boolean isTemporaryStatus() {
        return this.isStatus(MessageDictionary.msg(MessageDictionary.CREATE_USER_ROLE_TEMP_TAG));
    }

    protected final boolean isPermanentStatus() {
        return this.isStatus(MessageDictionary.msg(MessageDictionary.CREATE_USER_ROLE_REGULAR_TAG));
    }

    protected final boolean isAdminStatus() {
        return this.isStatus(MessageDictionary.msg(MessageDictionary.CREATE_USER_ROLE_ADMIN_TAG));
    }

    private final TextField<String> createUserCodeField() {
        TextField<String> textField = this.createTextField(MessageDictionary.msg(MessageDictionary.USER_ID_LABEL));
        textField.setAllowBlank(false);
        textField.setValidator(CifexValidator.getUserCodeFieldValidator());
        textField.setValidateOnBlur(false);
        if (this.editUser != null && this.editUser.getUserCode() != null) {
            textField.setValue((Object)this.editUser.getUserCode());
            textField.setEnabled(false);
        }
        return textField;
    }

    private TextField<String> createTextField(String label) {
        TextField fieldConfig = new TextField();
        fieldConfig.setFieldLabel(label);
        fieldConfig.setWidth(175);
        fieldConfig.setName(label);
        return fieldConfig;
    }

    private final TextField<String> createEmailField() {
        TextField<String> textField = this.createTextField(MessageDictionary.msg(MessageDictionary.LIST_USERS_EMAIL_COLUMN_HEADER));
        textField.setValidator(CifexValidator.getEmailFieldValidator());
        boolean allowBlankEmail = this.editUser == null && this.context.getModel().getUser().isAdmin() && this.context.getModel().getConfiguration().getSystemHasExternalAuthentication() != false;
        textField.setAllowBlank(allowBlankEmail);
        if (this.editUser != null && this.editUser.getEmail() != null) {
            textField.setValue((Object)this.editUser.getEmail());
        }
        return textField;
    }

    private void disableInternalFields(boolean isDisabled) {
        boolean enabled = !isDisabled;
        this.usernameField.setEnabled(enabled);
        this.passwordField.setEnabled(enabled);
        this.validatePasswordField.setEnabled(enabled);
        this.emailField.setEnabled(enabled);
    }

    private final TextField<String> createUsernameField() {
        TextField<String> textField = this.createTextField(MessageDictionary.msg(MessageDictionary.LIST_USERS_FULLNAME_COLUMN_HEADER));
        textField.setAllowBlank(true);
        textField.setValidateOnBlur(false);
        if (this.editUser != null && this.editUser.getUserFullName() != null) {
            textField.setValue((Object)this.editUser.getUserFullName());
        }
        return textField;
    }

    private final TextField<String> createPasswordField() {
        TextField<String> textField = this.createTextField(MessageDictionary.msg(MessageDictionary.CREATE_USER_PASSWD_LABEL));
        textField.setPassword(true);
        textField.setAllowBlank(true);
        textField.setMinLength(4);
        return textField;
    }

    private final TextField<String> createValidatePasswordField() {
        TextField<String> textField = this.createTextField(MessageDictionary.msg(MessageDictionary.CREATE_USER_REPEAT_PASSWD_LABEL));
        textField.setPassword(true);
        textField.setAllowBlank(true);
        textField.setMinLength(4);
        return textField;
    }

    private final TextArea createCommentArea() {
        TextArea textArea = new TextArea();
        textArea.setAllowBlank(true);
        textArea.setFieldLabel(MessageDictionary.msg(MessageDictionary.CREATE_USER_COMMENT_LABEL));
        textArea.setName("user-comment");
        textArea.setPreventScrollbars(true);
        textArea.setWidth(175);
        return textArea;
    }

    private TextField<String> createMaxFileSizeField() {
        TextField<String> textField = this.createTextField(MessageDictionary.msg(MessageDictionary.CREATE_USER_MAX_FILESIZE_LABEL));
        textField.setValidator(new Validator(){

            public String validate(Field<?> field, String value) {
                if (value == null) {
                    return "Field required";
                }
                if (value.length() == 0) {
                    return null;
                }
                if ("unlimited".equals(value)) {
                    return null;
                }
                try {
                    long size = Long.parseLong(value);
                    return size > 0L ? null : "No files specified";
                }
                catch (NumberFormatException numberFormatException) {
                    return "Incorrect number";
                }
            }
        });
        if (this.editUser != null && this.editUser.isCustomMaxFileSizePerQuotaGroup()) {
            if (this.editUser.getMaxFileSizePerQuotaGroupInMB() != null) {
                textField.setValue((Object)this.editUser.getMaxFileSizePerQuotaGroupInMB().toString());
            } else {
                textField.setValue((Object)"unlimited");
            }
        }
        return textField;
    }

    private TextField<String> createMaxFileCountField() {
        TextField<String> textField = this.createTextField(MessageDictionary.msg(MessageDictionary.CREATE_USER_MAX_FILECOUNT_LABEL));
        textField.setValidator(new Validator(){

            public String validate(Field<?> field, String value) {
                if (value == null) {
                    return "Field required";
                }
                if (value.length() == 0) {
                    return null;
                }
                if ("unlimited".equals(value)) {
                    return null;
                }
                try {
                    int size = Integer.parseInt(value);
                    return size > 0 ? null : "No files specified";
                }
                catch (NumberFormatException numberFormatException) {
                    return "Incorrect number";
                }
            }
        });
        if (this.editUser != null && this.editUser.isCustomMaxFileCountPerQuotaGroup()) {
            if (this.editUser.getMaxFileCountPerQuotaGroup() != null) {
                textField.setValue((Object)this.editUser.getMaxFileCountPerQuotaGroup().toString());
            } else {
                textField.setValue((Object)"unlimited");
            }
        }
        return textField;
    }

    private TextField<String> createFileRetention() {
        TextField<String> textField = this.createTextField(MessageDictionary.msg(MessageDictionary.CREATE_USER_FILE_RETENTION_LABEL));
        textField.setValidator(new Validator(){

            public String validate(Field<?> field, String value) {
                if (value == null) {
                    return "Field required";
                }
                if (value.length() == 0) {
                    return null;
                }
                try {
                    int duration = Integer.parseInt(value);
                    return duration > 0 ? null : "Incorrect duration";
                }
                catch (NumberFormatException numberFormatException) {
                    return "Incorrect number";
                }
            }
        });
        if (this.editUser != null && this.editUser.isCustomMaxFileRetention()) {
            int maxFileRetentionDuration = this.editUser.getMaxFileRetention();
            textField.setValue((Object)Integer.toString(maxFileRetentionDuration));
        }
        return textField;
    }

    private TextField<String> createUserRetention() {
        TextField<String> textField = this.createTextField(MessageDictionary.msg(MessageDictionary.CREATE_USER_USER_RETENTION_LABEL));
        textField.setValidator(new Validator(){

            public String validate(Field<?> field, String value) {
                if (value == null) {
                    return "Field required";
                }
                if (value.length() == 0) {
                    return null;
                }
                try {
                    int duration = Integer.parseInt(value);
                    return duration > 0 ? null : "Incorrect duration";
                }
                catch (NumberFormatException numberFormatException) {
                    return "Incorrect number";
                }
            }
        });
        if (this.editUser != null && this.editUser.isCustomMaxUserRetention()) {
            int userRetentionDuration = this.editUser.getMaxUserRetention();
            textField.setValue((Object)Integer.toString(userRetentionDuration));
        }
        return textField;
    }

    private final CheckBox createSendUserInformationCheckbox() {
        CheckBox checkbox = new CheckBox();
        checkbox.setBoxLabel("");
        checkbox.setValue(Boolean.valueOf(true));
        checkbox.setName("send-user-information");
        checkbox.setFieldLabel(MessageDictionary.msg(MessageDictionary.EDIT_USER_NOTIFY_LABEL));
        checkbox.setWidth(175);
        return checkbox;
    }

    private final CheckBox createUserIsActiveCheckbox() {
        CheckBox checkBox = new CheckBox();
        checkBox.setBoxLabel("");
        if (this.editUser != null) {
            checkBox.setValue(Boolean.valueOf(this.editUser.isActive()));
        } else {
            checkBox.setValue(Boolean.valueOf(true));
        }
        checkBox.setName("user-is-active");
        checkBox.setFieldLabel(MessageDictionary.msg(MessageDictionary.USER_ACTIVE_LABEL));
        checkBox.setWidth(175);
        return checkBox;
    }

    private final CheckBox createUserIsExternallyAuthenticatedCheckbox() {
        CheckBox checkBox = new CheckBox();
        checkBox.setBoxLabel("");
        checkBox.setValue(Boolean.valueOf(this.editUser.isExternallyAuthenticated()));
        checkBox.setName("external_authentication");
        checkBox.setId("external_authentication");
        checkBox.setFieldLabel(MessageDictionary.msg(MessageDictionary.EDIT_USER_EXTERNAL_AUTHENTICATION_LABEL));
        checkBox.setWidth(175);
        return checkBox;
    }

    private final SimpleComboBox<String> createStatusComboBox() {
        SimpleComboBox comboBox = new SimpleComboBox();
        String adminRoleName = MessageDictionary.msg(MessageDictionary.CREATE_USER_ROLE_ADMIN_TAG);
        String permanentRoleName = MessageDictionary.msg(MessageDictionary.CREATE_USER_ROLE_REGULAR_TAG);
        String temporaryRoleName = MessageDictionary.msg(MessageDictionary.CREATE_USER_ROLE_TEMP_TAG);
        comboBox.add((Object)adminRoleName);
        comboBox.add((Object)permanentRoleName);
        comboBox.add((Object)temporaryRoleName);
        comboBox.setWidth(175);
        comboBox.setTriggerAction(ComboBox.TriggerAction.ALL);
        comboBox.setFieldLabel(MessageDictionary.msg(MessageDictionary.CREATE_USER_STATUS_LABEL));
        comboBox.setForceSelection(true);
        comboBox.setEditable(false);
        comboBox.setAllowBlank(false);
        String value = permanentRoleName;
        if (this.editUser != null) {
            if (this.editUser.isAdmin()) {
                value = adminRoleName;
            } else if (!this.editUser.isPermanent()) {
                value = temporaryRoleName;
            }
        }
        comboBox.setSimpleValue((Object)value);
        return comboBox;
    }

    private final DateField createExpirationDateField() {
        final DateField dateField = new DateField();
        dateField.setFieldLabel(MessageDictionary.msg(MessageDictionary.CREATE_USER_EXPIRATION_DATE_LABEL));
        long registrationTimeOrNow = this.editUser != null ? this.editUser.getRegistrationDate().getTime() : System.currentTimeMillis();
        Date minExpirationDate = new Date(registrationTimeOrNow);
        CalendarUtil.addDaysToDate((Date)minExpirationDate, (int)1);
        dateField.setMinValue(minExpirationDate);
        if (!this.context.getModel().getUser().isAdmin()) {
            Date maxExpirationDate = new Date(registrationTimeOrNow);
            CalendarUtil.addDaysToDate((Date)maxExpirationDate, (int)this.context.getModel().getUser().getMaxUserRetention());
            dateField.setMaxValue(maxExpirationDate);
        }
        dateField.getPropertyEditor().setFormat(DateTimeFormat.getFormat((String)"yyyy-MM-dd"));
        dateField.setToolTip(MessageDictionary.msg(MessageDictionary.CREATE_USER_EXPIRATION_DATE_TOOLTIP));
        dateField.setAllowBlank(false);
        if (this.statusField == null || this.isTemporaryStatus()) {
            if (this.editUser != null) {
                dateField.setValue((Object)this.editUser.getExpirationDate());
            } else {
                dateField.setValue((Object)UserUtils.getDefaultUserExpirationDate(this.context));
            }
        } else {
            dateField.disable();
        }
        if (dateField.getValue() == null) {
            dateField.setValue((Object)UserUtils.getDefaultUserExpirationDate(this.context));
        }
        if (this.statusField != null) {
            this.statusField.addListener(Events.Select, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    if (UserWidget.this.isTemporaryStatus()) {
                        dateField.enable();
                    } else {
                        dateField.disable();
                    }
                }
            });
        }
        return dateField;
    }

    abstract String getSubmitButtonLabel();

    abstract boolean submitForm();
}

