/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.cifex.rpc.ICIFEXRPCService;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXOperation;
import ch.systemsx.cisd.cifex.rpc.client.gui.IProgressListener;
import ch.systemsx.cisd.common.concurrent.ExecutionResult;
import ch.systemsx.cisd.common.concurrent.ExecutionStatus;
import ch.systemsx.cisd.common.concurrent.IMonitoringProxyLogger;
import ch.systemsx.cisd.common.concurrent.MonitoringProxy;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.MasqueradingException;
import ch.systemsx.cisd.common.time.TimingParameters;
import java.io.File;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractUploadDownload
implements ICIFEXOperation {
    protected static final int PROGRESS_REPORT_BLOCK_SIZE = 131072;
    protected static final int PROGRESS_UPDATE_MIN_INTERVAL_MILLIS = 1000;
    private static final long TIMEOUT_MILLIS = 20000L;
    protected static final int MAX_RETRIES = 600;
    private static final long WAIT_AFTER_FAILURE_MILLIS = 10000L;
    protected static final TimingParameters TIMING = TimingParameters.create((long)20000L, (int)600, (long)10000L);
    protected final ICIFEXRPCService service;
    protected final String sessionID;
    protected final Set<IProgressListener> listeners = new LinkedHashSet<IProgressListener>();
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    protected final AtomicBoolean inProgress = new AtomicBoolean(false);
    protected final boolean reportFinalException;

    protected abstract MonitoringProxy<?> getProxyForOperation();

    public AbstractUploadDownload(ICIFEXRPCService service, String sessionID) {
        this(service, sessionID, true);
    }

    public AbstractUploadDownload(ICIFEXRPCService service, String sessionID, boolean reportFinalException) {
        this.service = service;
        this.sessionID = sessionID;
        this.reportFinalException = reportFinalException;
        this.checkService();
    }

    protected void checkService() throws InvalidSessionException, EnvironmentFailureException {
        int serverVersion = this.service.getVersion();
        if (5 != serverVersion) {
            throw new EnvironmentFailureException("This client has the wrong service version for the server (client: 5, server: " + serverVersion + ").");
        }
        this.service.checkSession(this.sessionID);
    }

    @Override
    public boolean isInProgress() {
        return this.inProgress.get();
    }

    @Override
    public void cancel() {
        this.getProxyForOperation().cancelCurrentOperations();
        this.cancelled.set(true);
    }

    protected void resetCancel() {
        this.cancelled.set(false);
        Thread.interrupted();
    }

    protected boolean isCancelled() {
        boolean cancelCalled = this.cancelled.get();
        this.resetCancel();
        return cancelCalled || Thread.interrupted();
    }

    protected void fireStartedEvent(File file, String operationName, long fileSize, Long fileIdOrNull) {
        for (IProgressListener listener : this.listeners) {
            try {
                listener.start(file, operationName, fileSize, fileIdOrNull);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    protected void fireProgressEvent(long numberOfBytes, long fileSize) {
        int percentage = (int)(numberOfBytes * 100L / Math.max(1L, fileSize));
        for (IProgressListener listener : this.listeners) {
            try {
                listener.reportProgress(percentage, numberOfBytes);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    protected void fireFinishedEvent(boolean successful) {
        for (IProgressListener listener : this.listeners) {
            try {
                listener.finished(successful);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    protected void fireExceptionEvent(Throwable throwable) {
        for (IProgressListener listener : this.listeners) {
            try {
                listener.exceptionOccured(throwable);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    protected void fireWarningEvent(String warningMessage) {
        for (IProgressListener listener : this.listeners) {
            try {
                listener.warningOccured(warningMessage);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    static class InvocationLogger
    implements IMonitoringProxyLogger {
        private final AbstractUploadDownload uploadDownload;
        private final boolean reportFinalException;

        public InvocationLogger(AbstractUploadDownload uploadDownload, boolean reportFinalException) {
            this.uploadDownload = uploadDownload;
            this.reportFinalException = reportFinalException;
        }

        public void log(Method method, ExecutionResult<Object> result, boolean willRetry) {
            if (result.getStatus() == ExecutionStatus.EXCEPTION) {
                Throwable originalException = result.tryGetException();
                this.logException(willRetry, originalException);
            }
            if (result.getStatus() == ExecutionStatus.TIMED_OUT) {
                this.uploadDownload.fireWarningEvent("Remote operation timed out" + (willRetry ? ", will retry soon." : "."));
            }
        }

        private void logException(boolean willRetry, Throwable originalException) {
            if (willRetry) {
                String warningMessage = this.getMessageForThrowable(this.unwrapException(originalException));
                this.uploadDownload.fireWarningEvent(warningMessage);
            } else if (this.reportFinalException) {
                this.uploadDownload.fireExceptionEvent(originalException);
            }
        }

        private String getMessageForThrowable(Throwable th) {
            if (th instanceof MasqueradingException) {
                return th.toString();
            }
            if (th.getMessage() != null) {
                return "Remote operation failed: " + th.getClass().getSimpleName() + ": '" + th.getMessage() + "', will retry soon...";
            }
            return "Remote operation failed: " + th.getClass().getSimpleName() + ", will retry soon...";
        }

        private Throwable unwrapException(Throwable oirginalException) {
            return oirginalException instanceof Exception ? CheckedExceptionTunnel.unwrapIfNecessary((Exception)((Exception)oirginalException)) : oirginalException;
        }
    }
}

