/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.cifex.rpc.CRCCheckumMismatchException;
import ch.systemsx.cisd.cifex.rpc.ICIFEXRPCService;
import ch.systemsx.cisd.cifex.rpc.client.AbstractUploadDownload;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXDownloader;
import ch.systemsx.cisd.cifex.rpc.client.gui.IProgressListener;
import ch.systemsx.cisd.cifex.rpc.io.ISimpleChecksummingProgressListener;
import ch.systemsx.cisd.cifex.rpc.io.ResumingAndChecksummingOutputStream;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileInfoDTO;
import ch.systemsx.cisd.common.concurrent.IMonitoringProxyLogger;
import ch.systemsx.cisd.common.concurrent.MonitoringProxy;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFileOverwriteStrategy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.remoting.RemoteAccessException;

public final class Downloader
extends AbstractUploadDownload
implements ICIFEXDownloader {
    private final MonitoringProxy<IFileDownloader> proxyForOperation = this.createFileDownloaderProxy();
    private final IFileDownloader retryingFileDownloader = (IFileDownloader)this.proxyForOperation.get();

    public static ICIFEXDownloader create(ICIFEXRPCService service, String sessionID) {
        return new Downloader(service, sessionID);
    }

    private Downloader(ICIFEXRPCService service, String sessionID) {
        super(service, sessionID, false);
    }

    @Override
    protected MonitoringProxy<?> getProxyForOperation() {
        return this.proxyForOperation;
    }

    private MonitoringProxy<IFileDownloader> createFileDownloaderProxy() {
        IFileDownloader downloader = new IFileDownloader(){

            @Override
            public boolean download(FileInfoDTO fileInfo, File file, MonitoringProxy.IMonitorCommunicator communcator) {
                Downloader.this.doDownloadFile(fileInfo, file, communcator);
                return true;
            }

            @Override
            public FileInfoDTO getFileInfo(long fileID) {
                return Downloader.this.service.getFileInfo(Downloader.this.sessionID, fileID);
            }
        };
        AbstractUploadDownload.InvocationLogger logger = new AbstractUploadDownload.InvocationLogger(this, this.reportFinalException);
        return MonitoringProxy.create(IFileDownloader.class, (Object)downloader).exceptionClassSuitableForRetrying(RemoteAccessException.class).timing(TIMING).errorValueOnInterrupt().invocationLog((IMonitoringProxyLogger)logger);
    }

    @Override
    public void addProgressListener(IProgressListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public File download(long fileID, File directoryToDownloadOrNull, String fileNameOrNull) {
        return this.download(fileID, directoryToDownloadOrNull, fileNameOrNull, false);
    }

    @Override
    public File download(long fileID, File directoryToDownloadOrNull, String fileNameOrNull, final boolean overwriteOutFile) {
        return this.download(fileID, directoryToDownloadOrNull, fileNameOrNull, new IFileOverwriteStrategy(){

            public boolean overwriteAllowed(File outputFile) {
                return overwriteOutFile;
            }
        });
    }

    @Override
    public File download(long fileID, File directoryToDownloadOrNull, String fileNameOrNull, IFileOverwriteStrategy fileOverwriteStrategy) {
        this.resetCancel();
        try {
            this.inProgress.set(true);
            FileInfoDTO fileInfo = this.retryingFileDownloader.getFileInfo(fileID);
            File directory = directoryToDownloadOrNull != null ? directoryToDownloadOrNull : new File(".");
            String fileName = fileNameOrNull != null ? fileNameOrNull : fileInfo.getName();
            File file = new File(directory, fileName);
            FileUtilities.checkOutputFile((File)file, (IFileOverwriteStrategy)fileOverwriteStrategy);
            this.fireStartedEvent(file, "Downloading", fileInfo.getSize(), fileID);
            boolean ok = this.retryingFileDownloader.download(fileInfo, file, MonitoringProxy.MONITOR_COMMUNICATOR);
            this.fireFinishedEvent(ok);
            File file2 = file;
            return file2;
        }
        catch (Exception ex) {
            this.fireFinishedEvent(false);
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        finally {
            this.inProgress.set(false);
        }
    }

    private void doDownloadFile(FileInfoDTO fileInfo, File file, final MonitoringProxy.IMonitorCommunicator communicator) {
        InputStream input = null;
        final long fileSize = fileInfo.getSize();
        long fileID = fileInfo.getID();
        ResumingAndChecksummingOutputStream output = null;
        long clientFileSize = file.length();
        if (this.isCancelled() || communicator.isCancelled()) {
            throw new InterruptedExceptionUnchecked();
        }
        try {
            try {
                input = this.service.download(this.sessionID, fileID, clientFileSize);
                output = new ResumingAndChecksummingOutputStream(file, 131072L, new ISimpleChecksummingProgressListener(){
                    long lastUpdated = System.currentTimeMillis();

                    @Override
                    public void update(long bytesWritten, int crc32Value) {
                        if (Downloader.this.isCancelled() || communicator.isCancelled()) {
                            throw new InterruptedExceptionUnchecked();
                        }
                        communicator.update();
                        long now = System.currentTimeMillis();
                        if (now - this.lastUpdated > 1000L || bytesWritten == fileSize) {
                            Downloader.this.fireProgressEvent(bytesWritten, fileSize);
                            this.lastUpdated = now;
                        }
                    }

                    @Override
                    public void exceptionThrown(IOException e) {
                    }
                }, clientFileSize);
                if (this.isCancelled() || communicator.isCancelled()) {
                    throw new InterruptedExceptionUnchecked();
                }
                IOUtils.copyLarge((InputStream)input, (OutputStream)output);
                if (communicator.isCancelled()) {
                    throw new InterruptedExceptionUnchecked();
                }
                int crc32Value = output.getCrc32Value();
                if (fileInfo.getCrc32Value() != null && crc32Value != fileInfo.getCrc32Value()) {
                    file.delete();
                    throw new CRCCheckumMismatchException(fileInfo.getName(), crc32Value, (int)fileInfo.getCrc32Value(), "File has been deleted");
                }
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
                }
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
    }

    private static interface IFileDownloader {
        public FileInfoDTO getFileInfo(long var1);

        public boolean download(FileInfoDTO var1, File var2, MonitoringProxy.IMonitorCommunicator var3);
    }
}

