/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client;

import ch.systemsx.cisd.cifex.rpc.client.ClientConfigurationFiles;
import ch.systemsx.cisd.common.io.PropertyIOUtils;
import java.io.File;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;

public class PersistenceStore {
    private static final String USER_HOME_PATH = SystemUtils.getUserHome().getPath();
    private static final String WORKING_DIRECTORY_KEY = "working-directory";
    private static final String DELETE_ENCRYPTED_FILES_KEY = "delete-encrypted-files";
    private static final Properties userProperties = PersistenceStore.getProperties();

    private PersistenceStore() {
    }

    public static Properties getProperties() {
        if (ClientConfigurationFiles.USER_PROPERTIES_FILE.exists()) {
            try {
                return PropertyIOUtils.loadProperties((File)ClientConfigurationFiles.USER_PROPERTIES_FILE);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return PersistenceStore.createDefaultProperties();
            }
        }
        return PersistenceStore.createDefaultProperties();
    }

    private static Properties createDefaultProperties() {
        Properties result = new Properties();
        PersistenceStore.enrichPropertiesWithDefaults(result);
        return result;
    }

    private static void enrichPropertiesWithDefaults(Properties properties) {
        if (properties.getProperty(WORKING_DIRECTORY_KEY) == null) {
            properties.setProperty(WORKING_DIRECTORY_KEY, USER_HOME_PATH);
        }
        if (properties.getProperty(DELETE_ENCRYPTED_FILES_KEY) == null) {
            properties.setProperty(DELETE_ENCRYPTED_FILES_KEY, Boolean.TRUE.toString());
        }
    }

    public static File getWorkingDirectory() {
        return new File(userProperties.getProperty(WORKING_DIRECTORY_KEY));
    }

    public static void setWorkingDirectory(File workingDirectory) {
        userProperties.setProperty(WORKING_DIRECTORY_KEY, workingDirectory.getAbsolutePath());
    }

    public static boolean isDeleteEncryptedFiles() {
        return "true".equalsIgnoreCase(userProperties.getProperty(DELETE_ENCRYPTED_FILES_KEY));
    }

    public static void setDeleteEncryptedFiles(boolean deleteEncryptedFiles) {
        userProperties.setProperty(DELETE_ENCRYPTED_FILES_KEY, Boolean.toString(deleteEncryptedFiles));
    }

    public static void saveProperties() {
        try {
            PropertyIOUtils.saveProperties((File)ClientConfigurationFiles.USER_PROPERTIES_FILE, (Properties)userProperties);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

