/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client;

import ch.systemsx.cisd.cifex.rpc.ICIFEXRPCService;
import ch.systemsx.cisd.cifex.rpc.client.CIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.IncompatibleAPIVersionsException;
import ch.systemsx.cisd.common.spring.HttpInvokerUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class RPCServiceFactory {
    private static final int SERVER_TIMEOUT_MIN = 120;

    private RPCServiceFactory() {
    }

    public static ICIFEXComponent createCIFEXComponent(String serviceURL, boolean getServerCertificateFromServer) throws IncompatibleAPIVersionsException {
        ClassLoader classLoader = RPCServiceFactory.class.getClassLoader();
        ICIFEXRPCService service = RPCServiceFactory.createService(serviceURL, getServerCertificateFromServer);
        ServiceInvocationHandler invocationHandler = new ServiceInvocationHandler(service);
        ICIFEXRPCService proxy = (ICIFEXRPCService)Proxy.newProxyInstance(classLoader, new Class[]{ICIFEXRPCService.class}, (InvocationHandler)invocationHandler);
        int apiServerVersion = proxy.getVersion();
        int apiMinClientVersion = proxy.getMinClientVersion();
        if (5 < apiMinClientVersion || 5 > apiServerVersion) {
            throw new IncompatibleAPIVersionsException(5, apiServerVersion, apiMinClientVersion);
        }
        return new CIFEXComponent(proxy);
    }

    private static ICIFEXRPCService createService(String serviceURL, boolean getServerCertificateFromServer) {
        return (ICIFEXRPCService)HttpInvokerUtils.createStreamSupportingServiceStub(ICIFEXRPCService.class, (String)serviceURL, (long)120000L);
    }

    private static final class ServiceInvocationHandler
    implements InvocationHandler {
        private final ICIFEXRPCService service;

        private ServiceInvocationHandler(ICIFEXRPCService service) {
            this.service = service;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.service, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
        }
    }
}

