/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.cli;

import ch.systemsx.cisd.cifex.rpc.client.ClientConfigurationFiles;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.cli.AbstractCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.MinimalParameters;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;

public abstract class AbstractCommandWithSessionToken
extends AbstractCommand {
    private static final long ONE_MINUTE = 60000L;
    private MinimalParameters parameters;
    protected String[] arguments;

    private static String tryCheckAndGetSessionToken() {
        if (ClientConfigurationFiles.SESSION_TOKEN_FILE.exists()) {
            return FileUtilities.loadToString((File)ClientConfigurationFiles.SESSION_TOKEN_FILE).trim();
        }
        System.err.println("You are not logged in. Please call '" + MinimalParameters.getCommandPrepender() + "login' to start a session.");
        return null;
    }

    AbstractCommandWithSessionToken(String name) {
        super(name);
    }

    protected abstract int execute(String var1, ICIFEXComponent var2, String[] var3) throws UserFailureException, EnvironmentFailureException;

    protected abstract boolean isHelpRequest(String[] var1);

    protected MinimalParameters getParameters() {
        if (this.parameters == null) {
            this.parameters = new MinimalParameters(this.arguments, this.getName());
        }
        return this.parameters;
    }

    @Override
    public final int execute(String[] args) throws UserFailureException, EnvironmentFailureException {
        if (this.isHelpRequest(args)) {
            return 0;
        }
        this.arguments = args;
        final String sessionToken = AbstractCommandWithSessionToken.tryCheckAndGetSessionToken();
        if (sessionToken == null) {
            return 1;
        }
        final ICIFEXComponent serviceOrNull = this.tryGetComponent();
        if (serviceOrNull == null) {
            return 2;
        }
        new Timer("keep-alive ping", true).schedule(new TimerTask(){

            @Override
            public void run() {
                serviceOrNull.checkSession(sessionToken);
            }
        }, 60000L, 60000L);
        return this.execute(sessionToken, serviceOrNull, args);
    }
}

