/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.cli;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.cifex.BuildAndEnvironmentInfo;
import ch.systemsx.cisd.cifex.rpc.client.cli.ComputeCRC32Checksum;
import ch.systemsx.cisd.cifex.rpc.client.cli.DecryptCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.EncryptCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.FileDeletionCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.FileDownloadAllCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.FileDownloadCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.FileUploadCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.GeneratePassphraseCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.ICommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.InitializeCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.ListDownloadFilesCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.ListOwnedFilesCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.LoginCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.LogoutCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.MinimalParameters;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.MasqueradingException;
import ch.systemsx.cisd.common.exceptions.SystemExitException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.openpgp.PGPDataValidationException;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;

public class CIFEXClient {
    @Private
    static IExitHandler exitHandler;
    private static final Map<String, ICommand> commands;

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        exitHandler = SystemExit.SYSTEM_EXIT;
        commands = CIFEXClient.createCommands();
    }

    private static final void printUsage() {
        String cmd = String.valueOf(MinimalParameters.getCommandPrepender()) + " <command>";
        System.err.println("Usage: " + cmd + " <options> ");
        System.err.println();
        System.err.println("Available commands are: ");
        System.err.println();
        CIFEXClient.printCommands();
        System.err.println();
        System.err.println("Type '" + cmd + " --help' for help on a specific command");
    }

    private static final void printCommands() {
        for (String command : commands.keySet()) {
            System.err.println(command);
        }
    }

    private static final void printVersion() {
        System.err.println(String.valueOf(MinimalParameters.getCommandPrepender()) + " version " + BuildAndEnvironmentInfo.INSTANCE.getFullVersion() + " (Service version " + 5 + ")");
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 1 && "--version".equals(args[0])) {
            CIFEXClient.printVersion();
            exitHandler.exit(1);
        }
        Set<String> commandNames = commands.keySet();
        if (args.length == 0 || !commandNames.contains(args[0])) {
            CIFEXClient.printUsage();
            exitHandler.exit(1);
        }
        String[] newArgs = (String[])ArrayUtils.remove((Object[])args, (int)0);
        ICommand command = commands.get(args[0]);
        try {
            exitHandler.exit(command.execute(newArgs));
        }
        catch (InvalidSessionException ex) {
            System.err.println("Your session is no longer valid. Please login again. [server said: '" + ex.getMessage() + "']");
            exitHandler.exit(1);
        }
        catch (UserFailureException ex) {
            System.err.println();
            System.err.println(ex.getMessage());
            exitHandler.exit(1);
        }
        catch (EnvironmentFailureException ex) {
            System.err.println();
            System.err.println(String.valueOf(ex.getMessage()) + " (environment failure)");
            exitHandler.exit(1);
        }
        catch (RemoteConnectFailureException remoteConnectFailureException) {
            System.err.println();
            System.err.println("Remote server cannot be reached (environment failure)");
            exitHandler.exit(1);
        }
        catch (RemoteAccessException ex) {
            System.err.println();
            Throwable cause = ex.getCause();
            if (cause != null) {
                if (cause instanceof UnknownHostException) {
                    System.err.println(String.format("Given host '%s' can not be reached  (environment failure)", cause.getMessage()));
                } else if (cause instanceof IllegalArgumentException) {
                    System.err.println(cause.getMessage());
                } else if (cause instanceof SSLHandshakeException) {
                    System.err.println(String.format("Validation of SSL certificate failed [%s=%s] (configuration failure)", "javax.net.ssl.trustStore", StringUtils.defaultString((String)System.getProperty("javax.net.ssl.trustStore"))));
                } else {
                    ex.printStackTrace();
                }
            } else {
                ex.printStackTrace();
            }
            exitHandler.exit(1);
        }
        catch (SystemExitException systemExitException) {
            exitHandler.exit(1);
        }
        catch (MasqueradingException e) {
            System.err.println((Object)e);
            exitHandler.exit(1);
        }
        catch (Exception e) {
            Exception ex = CheckedExceptionTunnel.unwrapIfNecessary((Exception)e);
            System.err.println();
            if (ex instanceof PGPDataValidationException) {
                System.err.println("Decryption failed (wrong passphrase).");
            } else {
                ex.printStackTrace();
            }
            exitHandler.exit(1);
        }
    }

    private static final Map<String, ICommand> createCommands() {
        TreeMap<String, ICommand> map = new TreeMap<String, ICommand>();
        CIFEXClient.registerCommand(map, InitializeCommand.getInstance());
        CIFEXClient.registerCommand(map, LoginCommand.getInstance());
        CIFEXClient.registerCommand(map, LogoutCommand.getInstance());
        CIFEXClient.registerCommand(map, ListDownloadFilesCommand.getInstance());
        CIFEXClient.registerCommand(map, ListOwnedFilesCommand.getInstance());
        CIFEXClient.registerCommand(map, FileDownloadCommand.getInstance());
        CIFEXClient.registerCommand(map, FileDownloadAllCommand.getInstance());
        CIFEXClient.registerCommand(map, FileUploadCommand.getInstance());
        CIFEXClient.registerCommand(map, FileDeletionCommand.getInstance());
        CIFEXClient.registerCommand(map, ComputeCRC32Checksum.getInstance());
        CIFEXClient.registerCommand(map, EncryptCommand.getInstance());
        CIFEXClient.registerCommand(map, DecryptCommand.getInstance());
        CIFEXClient.registerCommand(map, GeneratePassphraseCommand.getInstance());
        return map;
    }

    private static void registerCommand(Map<String, ICommand> map, ICommand command) {
        String name = command.getName();
        assert (!map.containsKey(name)) : "A command named '" + name + "' has already been registered";
        map.put(name, command);
    }
}

