/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.cli;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.cifex.rpc.client.ClientConfigurationFiles;
import ch.systemsx.cisd.cifex.rpc.client.cli.AbstractCommand;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class InitializeCommand
extends AbstractCommand {
    private static final String NAME = "init";
    private static InitializeCommand instance;

    private InitializeCommand() {
        super(NAME);
    }

    public static final synchronized InitializeCommand getInstance() {
        if (instance == null) {
            instance = new InitializeCommand();
        }
        return instance;
    }

    @Override
    public int execute(String[] arguments) throws UserFailureException, EnvironmentFailureException {
        try {
            URL url;
            System.out.println("This command initializes the client for a given server.");
            String baseURL = this.getConsoleReader().readLine("Server Base URL (e.g. 'https://myserver:8443'): ");
            if (StringUtils.isBlank((String)baseURL)) {
                System.err.println("No server base URL has been specified.");
                System.exit(1);
            }
            if (baseURL.endsWith("/")) {
                baseURL = baseURL.substring(0, baseURL.length() - 1);
            }
            if ((url = new URL(baseURL)).getPort() < 0) {
                if ("https".equals(url.getProtocol())) {
                    baseURL = String.valueOf(baseURL) + ":443";
                } else if ("http".equals(url.getProtocol())) {
                    baseURL = String.valueOf(baseURL) + ":80";
                } else {
                    System.err.println("URL does not contain given.");
                    System.exit(1);
                }
            }
            FileUtils.writeStringToFile((File)ClientConfigurationFiles.BASE_URL_FILE, (String)baseURL);
            if (this.tryGetComponent(baseURL, true) == null) {
                return 2;
            }
            return 0;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }
}

