/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.cli;

import ch.systemsx.cisd.cifex.rpc.client.ClientConfigurationFiles;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.cli.AbstractCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.MinimalParameters;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import java.io.File;

public final class LogoutCommand
extends AbstractCommand {
    private static final String NAME = "logout";
    private static LogoutCommand instance;

    private LogoutCommand() {
        super(NAME);
    }

    public static final synchronized LogoutCommand getInstance() {
        if (instance == null) {
            instance = new LogoutCommand();
        }
        return instance;
    }

    @Override
    public final int execute(String[] arguments) throws UserFailureException, EnvironmentFailureException {
        if (ClientConfigurationFiles.SESSION_TOKEN_FILE.exists()) {
            block5: {
                try {
                    String sessionToken = FileUtilities.loadToString((File)ClientConfigurationFiles.SESSION_TOKEN_FILE).trim();
                    MinimalParameters parameters = new MinimalParameters(arguments, NAME);
                    parameters.assertArgsEmpty();
                    ICIFEXComponent cifexOrNull = this.tryGetComponent();
                    if (cifexOrNull != null) {
                        cifexOrNull.logout(sessionToken);
                    }
                    ClientConfigurationFiles.SESSION_TOKEN_FILE.delete();
                    if (cifexOrNull != null) break block5;
                    return 2;
                }
                catch (InvalidSessionException invalidSessionException) {
                    ClientConfigurationFiles.SESSION_TOKEN_FILE.delete();
                    return 0;
                }
            }
            System.out.println("Successfully logged out.");
        }
        return 0;
    }
}

