/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.cli;

import ch.systemsx.cisd.args4j.Argument;
import ch.systemsx.cisd.args4j.CmdLineException;
import ch.systemsx.cisd.args4j.CmdLineParser;
import ch.systemsx.cisd.args4j.ExampleMode;
import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MinimalParameters {
    private static final String CIFEX_WINDOWS_COMMAND_PREPEND = "cifex.bat ";
    private static final String CIFEX_UNIX_COMMAND_PREPEND = "cifex.sh ";
    private static final String ARGS_NOT_EMPTY = "No arguments allowed.";
    @Argument
    private final List<String> args = new ArrayList<String>();
    private final CmdLineParser parser = new CmdLineParser((Object)this);
    private final IExitHandler exitHandler;
    private final String programCall;
    private final String genericArgs;
    private boolean helpRequest;

    public MinimalParameters(String[] args, String commandName) {
        this(args, commandName, "");
    }

    public MinimalParameters(String[] args, String commandName, String genericArgs) {
        this(args, commandName, genericArgs, SystemExit.SYSTEM_EXIT);
    }

    public MinimalParameters(String[] args, String commandName, String genericArgs, IExitHandler exitHandler) {
        this.exitHandler = exitHandler;
        this.programCall = String.valueOf(MinimalParameters.getCommandPrepender()) + commandName;
        this.genericArgs = genericArgs;
        try {
            this.parser.parseArgument(args);
        }
        catch (CmdLineException ex) {
            throw new UserFailureException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static String getCommandPrepender() {
        if (OSUtilities.isUnix()) {
            return CIFEX_UNIX_COMMAND_PREPEND;
        }
        return CIFEX_WINDOWS_COMMAND_PREPEND;
    }

    public boolean isHelpRequest() {
        return this.helpRequest;
    }

    @Option(name="h", longName="help", usage="Show this help text", skipForExample=true)
    public void printHelp(boolean exit) {
        this.parser.printHelp(this.programCall, "[option [...]]", this.genericArgs, ExampleMode.ALL);
        this.helpRequest = true;
        if (exit) {
            this.exitHandler.exit(0);
        }
    }

    public final List<String> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public final void assertArgsEmpty() {
        if (this.args.size() != 0) {
            System.err.println(ARGS_NOT_EMPTY);
            this.printHelp(true);
        }
    }
}

