/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.gui;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.PersistenceStore;
import ch.systemsx.cisd.cifex.rpc.client.gui.CIFEXCommunicationState;
import ch.systemsx.cisd.cifex.rpc.client.gui.IProgressListener;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.lang.WordUtils;
import org.springframework.remoting.RemoteAccessException;

public abstract class AbstractSwingGUI {
    private static final int MESSAGE_WRAP_MAX_CHAR = 100;
    protected final ICIFEXComponent cifex;
    protected final String sessionId;
    protected final Thread shutdownHook;
    private final JFrame windowFrame;
    private static final long KEEP_ALIVE_PERIOD_MILLIS = 60000L;

    protected AbstractSwingGUI(CIFEXCommunicationState communicationState) {
        this.cifex = communicationState.getCifex();
        this.sessionId = communicationState.getSessionId();
        this.windowFrame = new JFrame(this.getTitle());
        this.windowFrame.setDefaultCloseOperation(0);
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                PersistenceStore.setWorkingDirectory(AbstractSwingGUI.this.getWorkingDirectory());
                PersistenceStore.setDeleteEncryptedFiles(AbstractSwingGUI.this.isDeleteEncryptedFile());
                PersistenceStore.saveProperties();
                try {
                    AbstractSwingGUI.this.cifex.logout(AbstractSwingGUI.this.sessionId);
                }
                catch (InvalidSessionException invalidSessionException) {}
            }
        };
        this.addShutdownHook();
        this.startSessionKeepAliveTimer(60000L);
        this.addWindowCloseHook();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                String message = String.valueOf(throwable.getClass().getSimpleName()) + "[Thread: " + thread.getName() + "]: " + throwable.getMessage();
                AbstractSwingGUI.notifyUserOfThrowable(AbstractSwingGUI.this.windowFrame, message, "Unexpected Error", throwable);
            }
        });
    }

    protected JFrame getWindowFrame() {
        return this.windowFrame;
    }

    protected void logout() {
        if (this.cancel()) {
            this.cifex.logout(this.sessionId);
            System.exit(0);
        }
    }

    private void startSessionKeepAliveTimer(long checkTimeIntervalMillis) {
        Timer timer = new Timer("Session Keep Alive", true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    AbstractSwingGUI.this.cifex.checkSession(AbstractSwingGUI.this.sessionId);
                }
                catch (RemoteAccessException ex) {
                    System.err.println("Error connecting to the server");
                    ex.printStackTrace();
                }
                catch (InvalidSessionException invalidSessionException) {
                    JOptionPane.showMessageDialog(AbstractSwingGUI.this.windowFrame, "Your session has expired on the server. Please log in again", "Error connecting to server", 0);
                    Runtime.getRuntime().removeShutdownHook(AbstractSwingGUI.this.shutdownHook);
                    System.exit(1);
                }
            }
        }, 0L, checkTimeIntervalMillis);
    }

    private void addWindowCloseHook() {
        this.windowFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractSwingGUI.this.logout();
            }
        });
    }

    protected abstract File getWorkingDirectory();

    protected abstract boolean isDeleteEncryptedFile();

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    protected abstract String getTitle();

    protected abstract boolean cancel();

    static String notifyUserOfThrowable(Frame parentFrame, String fileName, String operationName, Throwable throwable, String lastExceptionMessageOrNull) {
        Throwable th = throwable instanceof Error ? throwable : CheckedExceptionTunnel.unwrapIfNecessary((Exception)((Exception)throwable));
        String message = th instanceof UserFailureException ? th.getMessage() : String.valueOf(operationName) + " file '" + fileName + "' failed:\n" + th.getClass().getSimpleName() + ": " + th.getMessage();
        String title = "Error " + operationName + " File";
        if (!message.equals(lastExceptionMessageOrNull)) {
            AbstractSwingGUI.notifyUserOfThrowable(parentFrame, message, title, throwable);
        }
        return message;
    }

    static void notifyUserOfThrowable(final Frame parentFrame, final String message, final String title, Throwable throwable) {
        Throwable th = throwable instanceof Error ? throwable : CheckedExceptionTunnel.unwrapIfNecessary((Exception)((Exception)throwable));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(parentFrame, WordUtils.wrap((String)message, (int)100), title, 0);
            }
        });
        th.printStackTrace();
    }

    protected IProgressListener createErrorLogListener() {
        return new IProgressListener(){
            private File currentFile;
            private String currentOperationName;
            private String lastExceptionMessage;
            private String lastWarningMessage;

            @Override
            public void exceptionOccured(Throwable throwable) {
                this.lastExceptionMessage = AbstractSwingGUI.notifyUserOfThrowable(AbstractSwingGUI.this.getWindowFrame(), this.currentFile.getName(), this.currentOperationName, throwable, this.lastExceptionMessage);
            }

            @Override
            public void warningOccured(final String warningMessage) {
                if (!warningMessage.equals(this.lastWarningMessage)) {
                    this.lastWarningMessage = warningMessage;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(AbstractSwingGUI.this.getWindowFrame(), WordUtils.wrap((String)warningMessage, (int)100), "Warning", 2);
                        }
                    });
                }
            }

            @Override
            public void finished(boolean successful) {
                this.lastWarningMessage = null;
                this.lastExceptionMessage = null;
            }

            @Override
            public void reportProgress(int percentage, long numberOfBytes) {
                this.lastWarningMessage = null;
                this.lastExceptionMessage = null;
            }

            @Override
            public void start(File file, String operationName, long fileSize, Long fileIdOrNull) {
                this.currentFile = file;
                this.currentOperationName = operationName;
                this.lastExceptionMessage = null;
                this.lastWarningMessage = null;
            }
        };
    }

    protected static void setLookAndFeelToNative() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {}
    }

    protected static void showErrorsAndWarningsIfAny(JFrame frame, String firstMessageOrNull, List<String> warningMessages, List<Throwable> exceptions) {
        String message = firstMessageOrNull == null ? "" : String.valueOf(firstMessageOrNull) + "\n";
        message = String.valueOf(message) + AbstractSwingGUI.joinMessages(warningMessages, exceptions);
        if (exceptions.size() > 0) {
            AbstractSwingGUI.showErrorMessage(frame, message);
        } else if (warningMessages.size() > 0) {
            AbstractSwingGUI.showWarningMessage(frame, message);
        }
    }

    private static void showErrorMessage(JFrame frame, String message) {
        AbstractSwingGUI.showMessageDialog(frame, message, "Error", 0);
    }

    private static void showWarningMessage(JFrame frame, String message) {
        AbstractSwingGUI.showMessageDialog(frame, message, "Warning", 2);
    }

    private static void showMessageDialog(JFrame frame, String message, String title, int messageType) {
        JOptionPane.showMessageDialog(frame, message, title, messageType);
    }

    private static String joinMessages(List<String> warningMessages, List<Throwable> exceptions) {
        StringBuffer sb = new StringBuffer();
        AbstractSwingGUI.addErrorMessages(exceptions, sb);
        AbstractSwingGUI.addWarningMessages(warningMessages, sb);
        return sb.toString();
    }

    private static void addErrorMessages(List<Throwable> exceptions, StringBuffer sb) {
        if (exceptions.size() > 0) {
            if (exceptions.size() > 1) {
                sb.append("Following errors occured: \n");
            }
            for (Throwable exception : exceptions) {
                sb.append(AbstractSwingGUI.getErrorMessage(exception));
                sb.append("\n");
            }
        }
    }

    private static void addWarningMessages(List<String> warningMessages, StringBuffer sb) {
        if (warningMessages.size() > 0) {
            sb.append("Following warnings occured (you can most probably ignore them): \n");
            String lastWarningMessage = "";
            for (String warningMessage : warningMessages) {
                if (lastWarningMessage.equals(warningMessage)) continue;
                sb.append(warningMessage);
                sb.append("\n");
                lastWarningMessage = warningMessage;
            }
        }
    }

    private static String getErrorMessage(Throwable throwable) {
        String message = throwable instanceof UserFailureException ? throwable.getMessage() : "ERROR: " + throwable;
        return message;
    }
}

