/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.gui;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public class ClipboardUtils {
    private ClipboardUtils() {
    }

    public static void copyToClipboard(String text) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(text);
        clipboard.setContents(data, data);
    }

    public static String tryPasteClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contentOrNull = clipboard.getContents(null);
        try {
            return contentOrNull == null || !contentOrNull.isDataFlavorSupported(DataFlavor.stringFlavor) ? null : contentOrNull.getTransferData(DataFlavor.stringFlavor).toString();
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }
}

