/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.gui;

import ch.systemsx.cisd.cifex.rpc.client.gui.FileDownloadClient;
import ch.systemsx.cisd.cifex.rpc.client.gui.FileDownloadClientModel;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class DownloadStatusTableCellRenderer
implements TableCellRenderer {
    private final JButton downloadButton = new JButton("Download");
    private final JPanel downloadPanel = new JPanel();
    private final JProgressBar progressBar = new JProgressBar();
    private final JLabel progressLabel = new JLabel();
    private final JPanel progressPanel = new JPanel();
    private final JLabel decryptingLabel = new JLabel("Decrypting\u2026");
    private final JPanel decryptingPanel = new JPanel();
    private final JButton retryButton = new JButton("Retry Download");
    private final JLabel retryLabel = new JLabel("<html><i>Download Failed</i></html>");
    private final JPanel retryPanel = new JPanel();
    private final JLabel completedLabel = new JLabel("Finished");
    private final JPanel completedPanel = new JPanel();
    private final JButton decryptButton = new JButton("Decrypt");
    private final JLabel completedDownloadLabel = new JLabel("Finished Download");
    private final JPanel completedDownloadPanel = new JPanel();
    private final FileDownloadClient.IDecryptionChecker decryptionChecker;

    public DownloadStatusTableCellRenderer(FileDownloadClientModel tableModel) {
        this.decryptionChecker = tableModel.getDecryptionChecker();
        this.createDownloadPanel();
        this.createProgressPanel();
        this.createRetryPanel();
        this.createDecryptingPanel();
        this.createCompletedPanel();
        this.createCompletedNotDecryptedPanel();
    }

    private void createCompletedPanel() {
        this.completedPanel.setLayout(new GridLayout(1, 0));
        this.completedLabel.setFont(this.completedLabel.getFont().deriveFont(0));
        this.completedPanel.add(this.completedLabel);
        this.completedPanel.setOpaque(true);
    }

    private void createCompletedNotDecryptedPanel() {
        this.completedDownloadPanel.setLayout(new GridLayout(2, 0));
        this.completedDownloadLabel.setFont(this.completedDownloadLabel.getFont().deriveFont(0));
        this.completedDownloadPanel.add(this.completedDownloadLabel);
        this.completedDownloadPanel.add(this.decryptButton);
        this.completedDownloadPanel.setOpaque(true);
    }

    private void createDecryptingPanel() {
        this.decryptingPanel.setLayout(new GridLayout(1, 0));
        this.decryptingPanel.setFont(this.decryptingLabel.getFont().deriveFont(0));
        this.decryptingPanel.add(this.decryptingLabel);
        this.decryptingPanel.setOpaque(true);
    }

    private void createRetryPanel() {
        this.retryPanel.setLayout(new GridLayout(2, 0));
        this.retryLabel.setFont(this.retryLabel.getFont().deriveFont(0));
        this.retryPanel.add(this.retryLabel);
        this.retryPanel.add(this.retryButton);
        this.retryPanel.setOpaque(true);
    }

    private void createProgressPanel() {
        this.progressPanel.setLayout(new GridLayout(2, 0));
        this.progressPanel.add(this.progressBar);
        this.progressLabel.setFont(this.progressLabel.getFont().deriveFont(0));
        this.progressPanel.add(this.progressLabel);
        this.progressPanel.setOpaque(true);
    }

    private void createDownloadPanel() {
        this.downloadPanel.setLayout(new GridLayout(1, 0));
        this.downloadPanel.add(this.downloadButton);
        this.downloadPanel.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JPanel panel;
        FileDownloadClientModel.FileDownloadInfo fileInfo = (FileDownloadClientModel.FileDownloadInfo)value;
        if (fileInfo == null) {
            return null;
        }
        Color backgroundColor = isSelected ? table.getSelectionBackground() : table.getBackground();
        switch (fileInfo.getStatus()) {
            case TO_DOWNLOAD: {
                panel = this.downloadPanel;
                break;
            }
            case QUEUED_FOR_DECRYPTION: 
            case DECRYPTING: {
                panel = this.decryptingPanel;
                break;
            }
            case COMPLETED_DOWNLOAD_AND_DECRYPTION: {
                panel = this.completedPanel;
                break;
            }
            case COMPLETED_DOWNLOAD: {
                panel = this.decryptionChecker.willDecrypt() ? this.completedDownloadPanel : this.completedPanel;
                break;
            }
            case QUEUED_FOR_DOWNLOAD: 
            case DOWNLOADING: {
                panel = this.progressPanel;
                this.progressBar.setValue(fileInfo.getPercentageDownloaded());
                this.progressLabel.setText(this.getAmountDownloadedStringForFileInfo(fileInfo, false));
                break;
            }
            case STALLED: {
                panel = this.progressPanel;
                this.progressBar.setValue(fileInfo.getPercentageDownloaded());
                this.progressLabel.setText(this.getAmountDownloadedStringForFileInfo(fileInfo, true));
                break;
            }
            case FAILED: {
                panel = this.retryPanel;
                break;
            }
            default: {
                throw new RuntimeException("Unknown status: " + (Object)((Object)fileInfo.getStatus()));
            }
        }
        panel.setBackground(backgroundColor);
        return panel;
    }

    String getAmountDownloadedStringForFileInfo(FileDownloadClientModel.FileDownloadInfo fileInfo, boolean stalled) {
        StringBuffer sb = new StringBuffer();
        String eta = DateTimeUtils.renderDuration((long)fileInfo.getEstimatedTimeOfArrival());
        sb.append(fileInfo.getPercentageDownloaded());
        if (stalled) {
            sb.append("% (stalled)");
        } else {
            sb.append("% (remaining: ");
            sb.append(eta);
            sb.append(")");
        }
        return sb.toString();
    }
}

