/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.gui;

import ch.systemsx.cisd.base.utilities.OSUtilities;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;

public class FileChooserUtils {
    public static File[] tryChooseFile(Frame parentFrame, File initialDirectory, FileChooserMode mode) {
        if (OSUtilities.isMacOS()) {
            if (mode == FileChooserMode.Directory) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
            }
            FileDialog fileChooser = new FileDialog(parentFrame, FileChooserUtils.getTitle(mode));
            if (mode == FileChooserMode.Files) {
                fileChooser.setMultipleMode(true);
            }
            fileChooser.setModal(true);
            fileChooser.setMode(0);
            fileChooser.setDirectory(initialDirectory.getAbsolutePath());
            fileChooser.setVisible(true);
            File[] newFiles = fileChooser.getFiles();
            if (mode == FileChooserMode.Directory) {
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            }
            return newFiles;
        }
        JFileChooser fileChooser = new JFileChooser(initialDirectory);
        if (mode == FileChooserMode.Files) {
            fileChooser.setMultiSelectionEnabled(true);
        }
        fileChooser.setFileSelectionMode(mode == FileChooserMode.Directory ? 1 : 0);
        fileChooser.setDialogTitle(FileChooserUtils.getTitle(mode));
        int returnVal = fileChooser.showOpenDialog(parentFrame);
        if (returnVal == 0) {
            return fileChooser.getSelectedFiles();
        }
        return null;
    }

    private static String getTitle(FileChooserMode mode) {
        switch (mode) {
            case File: {
                return "Select a file";
            }
            case Files: {
                return "Select one or more files";
            }
            case Directory: {
                return "Select a directory";
            }
        }
        return null;
    }

    public static enum FileChooserMode {
        File,
        Files,
        Directory;

    }
}

