/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.gui;

import ch.systemsx.cisd.cifex.rpc.client.gui.CIFEXCommunicationState;
import ch.systemsx.cisd.cifex.rpc.client.gui.FileClientLoginForm;
import ch.systemsx.cisd.cifex.rpc.client.gui.FileDownloadClient;
import ch.systemsx.cisd.cifex.rpc.client.gui.FileUploadClient;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class FileClientMain {
    private static final String TITLE = "CIFEX";
    private static final int WIDTH = 830;
    private static final int HEIGHT = 550;

    public static void main(String[] args) {
        FileClientMain.setLookAndFeelToNative();
        FileClientMain.launchLogin();
    }

    private static void setLookAndFeelToNative() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {}
    }

    private static void launchLogin() {
        final Preferences prefs = Preferences.userNodeForPackage(FileClientLoginForm.class);
        String serverValue = prefs.get("PREF_NAME_SERVER", null);
        String userValue = prefs.get("PREF_NAME_USER", null);
        final FileClientLoginForm loginForm = new FileClientLoginForm();
        loginForm.getLoginButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String serverURL = loginForm.getServerURLField().getText();
                String userName = loginForm.getUserNameField().getText();
                String password = new String(loginForm.getPasswordField().getPassword());
                String cifexRPCService = "cifex/rpc-service";
                if (!serverURL.endsWith("/")) {
                    cifexRPCService = "/" + cifexRPCService;
                }
                String[] args = new String[]{String.valueOf(serverURL) + cifexRPCService, userName, password};
                try {
                    if (password.isEmpty()) {
                        throw new Exception("Password can't be empty.");
                    }
                    CIFEXCommunicationState commState = new CIFEXCommunicationState(args);
                    FileClientMain.displayMainView(commState);
                    loginForm.setVisible(false);
                    prefs.put("PREF_NAME_SERVER", serverURL);
                    prefs.put("PREF_NAME_USER", userName);
                    prefs.flush();
                }
                catch (Exception ex) {
                    JFrame frame = new JFrame(FileClientMain.TITLE);
                    String message = ex.getMessage();
                    if (message == null || message.length() == 0) {
                        message = ex.toString();
                    }
                    JOptionPane.showMessageDialog(frame, message, "Error", 0);
                }
            }
        });
        if (serverValue != null) {
            loginForm.getServerURLField().setText(serverValue);
            loginForm.getUserNameField().setText(userValue);
        }
        loginForm.setVisible(true);
    }

    private static JFrame displayMainView(CIFEXCommunicationState commState) {
        FileUploadClient uploadClient = new FileUploadClient(commState, (ITimeProvider)SystemTimeProvider.SYSTEM_TIME_PROVIDER, false);
        FileDownloadClient downloadClient = new FileDownloadClient(commState, (ITimeProvider)SystemTimeProvider.SYSTEM_TIME_PROVIDER, false);
        JTabbedPane tabbedPanel = new JTabbedPane();
        tabbedPanel.addTab("Uploader", null, uploadClient.getWindowFrame().getContentPane(), "Uploader Text");
        tabbedPanel.addTab("Downloader", null, downloadClient.getWindowFrame().getContentPane(), "Downloader Text");
        JFrame frame = new JFrame(TITLE);
        frame.setSize(830, 550);
        frame.setDefaultCloseOperation(3);
        frame.add((Component)tabbedPanel, "Center");
        frame.setVisible(true);
        return frame;
    }
}

