/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.gui;

import ch.systemsx.cisd.cifex.shared.basic.dto.FileInfoDTO;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Formatter;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class FileDetailsTableCellRenderer
implements TableCellRenderer {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private final JLabel fileName = new JLabel();
    private final JLabel fileSize = new JLabel();
    private final JPanel panel = new JPanel();

    public FileDetailsTableCellRenderer() {
        this.fileSize.setFont(this.fileName.getFont().deriveFont(0));
        this.panel.setLayout(new GridLayout(2, 0));
        this.panel.add(this.fileName);
        this.panel.add(this.fileSize);
        this.panel.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        FileInfoDTO fileInfo = (FileInfoDTO)value;
        Color backgroundColor = isSelected ? table.getSelectionBackground() : table.getBackground();
        this.panel.setBackground(backgroundColor);
        this.fileName.setText(fileInfo.getName());
        this.fileSize.setText(FileDetailsTableCellRenderer.numberOfBytesToDisplayString(fileInfo.getSize()));
        return this.panel;
    }

    static String numberOfBytesToDisplayString(long numBytes) {
        try (Formatter f = new Formatter();){
            float numKBytes = (float)numBytes / 1024.0f;
            if (numKBytes < 1.0f) {
                f.format("%d bytes", numBytes);
                String string = f.toString();
                return string;
            }
            if (numKBytes < 1000.0f) {
                f.format("%.2f kB", Float.valueOf(numKBytes));
                String string = f.toString();
                return string;
            }
            float numMBytes = (float)numBytes / 1048576.0f;
            if (numMBytes < 1000.0f) {
                f.format("%.2f MB", Float.valueOf(numMBytes));
                String string = f.toString();
                return string;
            }
            float numGBytes = numMBytes / 1024.0f;
            f.format("%.2f GB", Float.valueOf(numGBytes));
            String string = f.toString();
            return string;
        }
    }
}

