/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.gui;

import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXDownloader;
import ch.systemsx.cisd.cifex.rpc.client.PersistenceStore;
import ch.systemsx.cisd.cifex.rpc.client.gui.AbstractSwingGUI;
import ch.systemsx.cisd.cifex.rpc.client.gui.CIFEXCommunicationState;
import ch.systemsx.cisd.cifex.rpc.client.gui.DateTimeTableCellRenderer;
import ch.systemsx.cisd.cifex.rpc.client.gui.DownloadStatusTableCellEditor;
import ch.systemsx.cisd.cifex.rpc.client.gui.DownloadStatusTableCellRenderer;
import ch.systemsx.cisd.cifex.rpc.client.gui.FileChooserUtils;
import ch.systemsx.cisd.cifex.rpc.client.gui.FileDetailsTableCellRenderer;
import ch.systemsx.cisd.cifex.rpc.client.gui.FileDownloadClientModel;
import ch.systemsx.cisd.cifex.rpc.client.gui.PassphraseDialog;
import ch.systemsx.cisd.cifex.shared.basic.UserFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class FileDownloadClient
extends AbstractSwingGUI {
    private static final int BUTTON_WIDTH = 510;
    private static final int LABEL_WIDTH = 60;
    private static final int BUTTON_HEIGHT = 30;
    private static final String TITLE = "CIFEX Downloader";
    private final ICIFEXDownloader downloader;
    private final FileDownloadClientModel tableModel;
    private JButton decryptButton;
    private JButton directoryButton;
    private JCheckBox willDecrypt;
    private String passphrase = "";
    private boolean deleteEncryptedFileAfterSuccessfulDecryption = PersistenceStore.isDeleteEncryptedFiles();

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
    }

    public static void main(String[] args) throws UserFailureException, EnvironmentFailureException {
        FileDownloadClient.setLookAndFeelToNative();
        try {
            CIFEXCommunicationState commState = new CIFEXCommunicationState(args);
            FileDownloadClient newMe = new FileDownloadClient(commState, (ITimeProvider)SystemTimeProvider.SYSTEM_TIME_PROVIDER);
            newMe.show();
        }
        catch (RuntimeException ex) {
            JFrame frame = new JFrame(TITLE);
            frame.setVisible(true);
            JOptionPane.showMessageDialog(frame, ex.getMessage(), "Error", 0);
            System.exit(1);
        }
    }

    FileDownloadClient(CIFEXCommunicationState commState, ITimeProvider timeProvider) {
        this(commState, timeProvider, true);
    }

    FileDownloadClient(CIFEXCommunicationState commState, ITimeProvider timeProvider, boolean isShownByDefault) {
        super(commState);
        this.downloader = this.cifex.createDownloader(this.sessionId);
        this.tableModel = new FileDownloadClientModel(this, this.getWindowFrame(), timeProvider);
        this.createGUI(isShownByDefault);
        this.addProgressListener();
    }

    public ICIFEXComponent getCifex() {
        return this.cifex;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public ICIFEXDownloader getDownloader() {
        return this.downloader;
    }

    public IDecryptionChecker getDecryptionChecker() {
        return new IDecryptionChecker(){

            @Override
            public boolean willDecrypt() {
                return FileDownloadClient.this.willDecrypt.isSelected();
            }
        };
    }

    private void createGUI(boolean isShownByDefault) {
        JFrame window = this.getWindowFrame();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(0, 5));
        panel.add((Component)this.createFileListComponent(), "Center");
        panel.add((Component)this.createDirectoryAndPassphrasePanel(), "South");
        window.add((Component)panel, "Center");
        JLabel spacer = new JLabel("");
        spacer.setPreferredSize(new Dimension(5, 5));
        window.add((Component)spacer, "West");
        spacer = new JLabel("");
        spacer.setPreferredSize(new Dimension(5, 5));
        window.add((Component)spacer, "East");
        spacer = new JLabel("");
        spacer.setPreferredSize(new Dimension(1000, 15));
        window.add((Component)spacer, "South");
        window.pack();
        window.setLocationByPlatform(true);
        if (isShownByDefault) {
            window.setVisible(true);
        } else {
            window.setVisible(false);
        }
    }

    private JComponent createFileListComponent() {
        JTable fileTable = new JTable(this.tableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                JComponent jc = (JComponent)c;
                jc.setBorder(new MatteBorder(0, 0, 1, 1, Color.LIGHT_GRAY));
                return c;
            }
        };
        fileTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
                ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
                if (!selectionModel.isSelectionEmpty()) {
                    int minIndex = selectionModel.getMinSelectionIndex();
                    int maxIndex = selectionModel.getMaxSelectionIndex();
                    int i = minIndex;
                    while (i <= maxIndex) {
                        if (selectionModel.isSelectedIndex(i)) {
                            selectedIndices.add(i);
                        }
                        ++i;
                    }
                }
                FileDownloadClient.this.tableModel.setSelectedIndices(selectedIndices);
            }
        });
        this.tableModel.setTable(fileTable);
        fileTable.setRowHeight(fileTable.getRowHeight() * 2);
        TableColumn column = fileTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(320);
        column.setCellRenderer(new FileDetailsTableCellRenderer());
        column = fileTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(150);
        column = fileTable.getColumnModel().getColumn(2);
        column.setPreferredWidth(200);
        column = fileTable.getColumnModel().getColumn(3);
        column.setPreferredWidth(100);
        column.setCellRenderer(new DateTimeTableCellRenderer());
        column = fileTable.getColumnModel().getColumn(4);
        column.setPreferredWidth(100);
        column.setCellRenderer(new DateTimeTableCellRenderer());
        column = fileTable.getColumnModel().getColumn(5);
        column.setPreferredWidth(150);
        column.setCellRenderer(new DownloadStatusTableCellRenderer(this.tableModel));
        column.setCellEditor(new DownloadStatusTableCellEditor(this.tableModel));
        JScrollPane scrollPane = new JScrollPane(fileTable);
        return scrollPane;
    }

    private JComponent createDirectoryAndPassphrasePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        this.willDecrypt = new JCheckBox("Will Decrypt");
        this.willDecrypt.setEnabled(false);
        this.decryptButton = new JButton("Decrypt\u2026");
        this.decryptButton.setToolTipText("Decrypt files after downloading");
        this.decryptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PassphraseDialog.PassphraseAndFileDeletion newPassphraseAndFileDeletionOrNull = PassphraseDialog.tryGetPassphraseForDecrypt(FileDownloadClient.this.getWindowFrame(), FileDownloadClient.this.passphrase, FileDownloadClient.this.deleteEncryptedFileAfterSuccessfulDecryption, "Decrypt Files", "Enter Passphrase");
                if (newPassphraseAndFileDeletionOrNull != null) {
                    FileDownloadClient.this.passphrase = newPassphraseAndFileDeletionOrNull.getPassphrase();
                    FileDownloadClient.this.deleteEncryptedFileAfterSuccessfulDecryption = newPassphraseAndFileDeletionOrNull.tryGetDeleteEncrypted();
                    FileDownloadClient.this.tableModel.setPassphraseAndEncryptedFileDeletion(FileDownloadClient.this.passphrase, FileDownloadClient.this.deleteEncryptedFileAfterSuccessfulDecryption);
                    FileDownloadClient.this.willDecrypt.setSelected(FileDownloadClient.this.passphrase.length() > 0);
                }
            }
        });
        JLabel label = new JLabel("Save To", 11);
        label.setPreferredSize(new Dimension(60, 30));
        this.directoryButton = new JButton("");
        this.directoryButton.setPreferredSize(new Dimension(510, 30));
        this.directoryButton.setToolTipText("Click button to select a directory in which to save the downloaded files.");
        this.directoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File[] newDirOrNull = FileChooserUtils.tryChooseFile(FileDownloadClient.this.getWindowFrame(), FileDownloadClient.this.tableModel.getDownloadDirectory(), FileChooserUtils.FileChooserMode.Directory);
                if (newDirOrNull != null && newDirOrNull.length == 1) {
                    FileDownloadClient.this.tableModel.setDownloadDirectory(newDirOrNull[0]);
                    FileDownloadClient.this.updateDirectoryLabel();
                }
            }
        });
        this.updateDirectoryLabel();
        panel.add(this.willDecrypt);
        panel.add(this.decryptButton);
        panel.add(Box.createHorizontalGlue());
        panel.add(label);
        panel.add(this.directoryButton);
        return panel;
    }

    private void updateDirectoryLabel() {
        try {
            this.directoryButton.setText(this.tableModel.getDownloadDirectory().getCanonicalPath());
        }
        catch (IOException iOException) {
            this.directoryButton.setText(".");
        }
    }

    private void addProgressListener() {
        this.downloader.addProgressListener(this.createErrorLogListener());
    }

    private void show() {
        this.getWindowFrame().setVisible(true);
    }

    @Override
    protected final boolean cancel() {
        if (!this.downloader.isInProgress()) {
            return true;
        }
        int answer = JOptionPane.showConfirmDialog(this.getWindowFrame(), "Do you really want to stop downloading?");
        if (answer == 0) {
            this.downloader.cancel();
            return true;
        }
        return false;
    }

    @Override
    protected String getTitle() {
        return TITLE;
    }

    @Override
    protected File getWorkingDirectory() {
        return this.tableModel.getDownloadDirectory();
    }

    @Override
    protected boolean isDeleteEncryptedFile() {
        return this.deleteEncryptedFileAfterSuccessfulDecryption;
    }

    public static interface IDecryptionChecker {
        public boolean willDecrypt();
    }
}

