/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.NullAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.cifex.rpc.server.Session;
import ch.systemsx.cisd.cifex.server.business.IDomainModel;
import ch.systemsx.cisd.cifex.server.business.IUserActionLog;
import ch.systemsx.cisd.cifex.server.business.IUserManager;
import ch.systemsx.cisd.cifex.server.business.UserUtils;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.cifex.server.common.Password;
import ch.systemsx.cisd.cifex.server.util.FileUploadFeedbackProvider;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LoggingContextHandler;
import ch.systemsx.cisd.common.server.IRemoteHostProvider;
import ch.systemsx.cisd.common.servlet.IRequestContextProvider;
import ch.systemsx.cisd.common.servlet.RequestContextProviderAdapter;
import java.util.Date;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.springframework.dao.DataIntegrityViolationException;

public abstract class AbstractCIFEXService {
    public static final String SESSION_ATTRIBUTE_USER_NAME = "cifex-user";
    public static final String SESSION_ATTRIBUTE_RPC_SESSION = "rpc-session";
    static final String UPLOAD_FEEDBACK_QUEUE = "upload-feedback-queue";
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, AbstractCIFEXService.class);
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, AbstractCIFEXService.class);
    protected final IDomainModel domainModel;
    protected final IRequestContextProvider requestContextProvider;
    protected final IRemoteHostProvider remoteHostProvider;
    protected final LoggingContextHandler loggingContextHandler;
    protected final IAuthenticationService externalAuthenticationService;
    protected final IUserActionLog userActionLog;
    private final int sessionExpirationPeriodInSeconds;

    protected static LoggingContextHandler createLoggingContextHandler(IRequestContextProvider requestContextProvider) {
        if (requestContextProvider != null) {
            return new LoggingContextHandler((IRemoteHostProvider)new RequestContextProviderAdapter(requestContextProvider));
        }
        return null;
    }

    protected AbstractCIFEXService(IDomainModel domainModel, IRequestContextProvider requestContextProvider, IUserActionLog userActionLog, IAuthenticationService externalAuthenticationService, LoggingContextHandler loggingContextHandler, int sessionExpirationPeriodMinutes) {
        this.domainModel = domainModel;
        this.requestContextProvider = requestContextProvider;
        this.remoteHostProvider = new RequestContextProviderAdapter(requestContextProvider);
        this.userActionLog = userActionLog;
        this.externalAuthenticationService = externalAuthenticationService;
        this.loggingContextHandler = loggingContextHandler;
        this.sessionExpirationPeriodInSeconds = sessionExpirationPeriodMinutes * 60;
        this.checkAuthentication();
    }

    public static Session tryGetRPCSession(HttpSession httpSessionOrNull) {
        if (httpSessionOrNull != null) {
            return (Session)httpSessionOrNull.getAttribute(SESSION_ATTRIBUTE_RPC_SESSION);
        }
        return null;
    }

    private void checkAuthentication() throws HighLevelException {
        if (this.hasExternalAuthenticationService()) {
            try {
                this.externalAuthenticationService.check();
                operationLog.info((Object)("Configuration check of external authentication service " + this.externalAuthenticationService.getClass().getSimpleName() + " passed."));
            }
            catch (HighLevelException ex) {
                if (this.externalAuthenticationService.isRemote() && ex instanceof EnvironmentFailureException) {
                    notificationLog.error((Object)("Self-test failed for external authentication service '" + this.externalAuthenticationService.getClass().getSimpleName() + "'. This authentication service is remote and the resource may become " + "available later, thus continuing anyway."), (Throwable)ex);
                }
                notificationLog.error((Object)("Self-test failed for external authentication service '" + this.externalAuthenticationService.getClass().getSimpleName() + "'."), (Throwable)ex);
                throw ex;
            }
        }
    }

    protected final boolean hasExternalAuthenticationService() {
        return this.externalAuthenticationService != null && !(this.externalAuthenticationService instanceof NullAuthenticationService);
    }

    private final String createSession(UserDTO user) {
        HttpSession httpSession = this.getSession(true);
        httpSession.setMaxInactiveInterval(this.sessionExpirationPeriodInSeconds);
        httpSession.setAttribute(SESSION_ATTRIBUTE_USER_NAME, (Object)user);
        httpSession.setAttribute(UPLOAD_FEEDBACK_QUEUE, (Object)new FileUploadFeedbackProvider());
        return httpSession.getId();
    }

    protected final HttpSession getSession(boolean create) {
        return this.requestContextProvider.getHttpServletRequest().getSession(create);
    }

    private UserDTO finishLogin(UserDTO userDTO) {
        userDTO.setPassword(null);
        userDTO.setPasswordHash(null);
        UserDTO fullRegistrator = userDTO.getRegistrator();
        if (fullRegistrator != null) {
            UserDTO strippedRegistrator = new UserDTO();
            strippedRegistrator.setID(fullRegistrator.getID());
            strippedRegistrator.setUserCode(fullRegistrator.getUserCode());
            strippedRegistrator.setEmail(fullRegistrator.getEmail());
            strippedRegistrator.setUserFullName(fullRegistrator.getUserFullName());
            userDTO.setRegistrator(strippedRegistrator);
        }
        String sessionToken = this.createSession(userDTO);
        this.loggingContextHandler.addContext(sessionToken, "user (email):" + userDTO.getEmail() + ", session start:" + DateFormatUtils.format((Date)new Date(), (String)DATE_FORMAT_PATTERN));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)("Successfully created session for user " + userDTO));
        }
        return userDTO;
    }

    protected final UserDTO tryLoginUser(String userCode, String plainPassword) throws EnvironmentFailureException {
        IUserManager userManager;
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)("Try to login user '" + userCode + "'."));
        }
        if ((userManager = this.domainModel.getUserManager()).isDatabaseEmpty()) {
            UserDTO userDTO = AbstractCIFEXService.createAdminUserDTO(userCode, plainPassword);
            boolean success = false;
            try {
                userManager.createUser(userDTO, null);
                success = true;
            }
            finally {
                this.userActionLog.logCreateUser(userDTO, success);
            }
            return this.finishLogin(userDTO);
        }
        UserDTO userDTOOrNull = userManager.tryFindUserByCode(userCode);
        if (userDTOOrNull == null || userDTOOrNull.isExternallyAuthenticated()) {
            userDTOOrNull = this.tryExternalAuthenticationServiceLogin(userCode, plainPassword);
            if (userDTOOrNull != null) {
                return this.finishLogin(userDTOOrNull);
            }
        } else {
            Password password = new Password(plainPassword);
            if (userDTOOrNull.isActive() && password.matches(userDTOOrNull.getPasswordHash())) {
                return this.finishLogin(userDTOOrNull);
            }
            operationLog.info((Object)String.format("User '%s' failed to login: %s.", userDTOOrNull.getUserCode(), userDTOOrNull.isActive() ? "password mismatch" : "account deactivated"));
        }
        return null;
    }

    private static UserDTO createAdminUserDTO(String userCode, String plainPassword) {
        UserDTO userDTO = new UserDTO();
        userDTO.setUserCode(userCode);
        userDTO.setEmail(userCode);
        userDTO.setPassword(new Password(plainPassword));
        userDTO.setAdmin(true);
        return userDTO;
    }

    protected UserDTO tryExternalAuthenticationServiceLogin(String userId, String password) throws EnvironmentFailureException {
        if (!this.hasExternalAuthenticationService()) {
            return null;
        }
        Principal principalOrNull = this.externalAuthenticationService.tryGetAndAuthenticateUser(userId, password);
        boolean authenticated = Principal.isAuthenticated((Principal)principalOrNull);
        if (!authenticated) {
            return null;
        }
        UserDTO userDTO = this.createOrUpdateUserFromExternalAuthenticationService(principalOrNull, null);
        if (!userDTO.isActive()) {
            return null;
        }
        return userDTO;
    }

    protected UserDTO createOrUpdateUserFromExternalAuthenticationService(Principal principal, UserInfoDTO userOrNull) {
        UserDTO userDTO;
        block13: {
            String code = principal.getUserId();
            String email = principal.getEmail();
            String displayName = UserUtils.extractDisplayName(principal);
            IUserManager userManager = this.domainModel.getUserManager();
            userDTO = userManager.tryFindUserByCode(code);
            if (userDTO == null) {
                userDTO = new UserDTO();
                userDTO.setUserCode(code);
                userDTO.setUserFullName(displayName);
                userDTO.setEmail(email);
                userDTO.setPassword(null);
                userDTO.setExternallyAuthenticated(true);
                if (userOrNull != null) {
                    userDTO.setAdmin(userOrNull.isAdmin());
                    userDTO.setExpirationDate(userOrNull.getExpirationDate());
                    userDTO.setActive(userOrNull.isActive());
                } else {
                    userDTO.setAdmin(false);
                    userDTO.setActive(this.domainModel.getBusinessContext().isNewExternallyAuthenticatedUserStartActive());
                }
                boolean success = false;
                try {
                    try {
                        userManager.createUser(userDTO, null);
                        success = true;
                        break block13;
                    }
                    catch (UserFailureException ex) {
                        operationLog.error((Object)ex.getMessage(), (Throwable)ex);
                        throw new EnvironmentFailureException(ex.getMessage());
                    }
                }
                finally {
                    this.userActionLog.logCreateUser(userDTO, success);
                }
            }
            boolean changed = false;
            if (!StringUtils.equals((String)displayName, (String)userDTO.getUserFullName())) {
                userDTO.setUserFullName(displayName);
                changed = true;
            }
            if (!StringUtils.equals((String)email, (String)userDTO.getEmail())) {
                userDTO.setEmail(email);
                changed = true;
            }
            if (changed) {
                try {
                    userManager.updateUser(userDTO, null, null, this.userActionLog);
                }
                catch (DataIntegrityViolationException ex) {
                    String msg = "User '" + code + "' with email '" + email + "' cannot be updated.";
                    operationLog.error((Object)msg, (Throwable)ex);
                    throw new EnvironmentFailureException(msg);
                }
            }
        }
        return userDTO;
    }

    public final void logout() {
        HttpSession httpSession = this.getSession(false);
        if (httpSession != null) {
            this.loggingContextHandler.destroyContext(httpSession.getId());
            httpSession.invalidate();
        }
    }
}

