/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server;

import ch.systemsx.cisd.cifex.server.business.IDomainModel;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.common.string.Template;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

abstract class AbstractCIFEXServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String DOMAIN_MODEL_BEAN_NAME = "domain-model";
    private static final Template ERROR_MESSAGE = new Template("<html><meta><title>CIFEX Error</title></meta><body><h1>CIFEX Error</h1>${error-message}</body></html>");
    private static final Template FATAL_ERROR_MESSAGE = new Template("<html><meta><title>CIFEX Fatal Error</title></meta><body><h1>CIFEX Fatal Error</h1>A fatal error occured:<br>${error-message}</body></html>");
    protected final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ((Object)((Object)this)).getClass());
    protected final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, ((Object)((Object)this)).getClass());
    protected Properties serviceProperties;
    protected IDomainModel domainModel;

    private final void initServiceServlet() {
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.domainModel = (IDomainModel)context.getBean(DOMAIN_MODEL_BEAN_NAME);
        ExposablePropertyPlaceholderConfigurer configurer = (ExposablePropertyPlaceholderConfigurer)context.getBean("propertyConfigurer");
        this.serviceProperties = configurer.getResolvedProps();
        this.postInitialization();
    }

    protected final String getErrorMessage(Exception exception) {
        String exceptionMsg = exception.getMessage();
        String message = StringUtils.isNotBlank((String)exceptionMsg) ? exceptionMsg : String.format("The request could not be processed because an unknown problem [%s] occurred.", exception.getClass().getSimpleName());
        return message;
    }

    protected final UserDTO getUserDTO(HttpServletRequest request) throws InvalidSessionException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new InvalidSessionException("You are not logged in or your session expired. Please log in.");
        }
        return (UserDTO)session.getAttribute("cifex-user");
    }

    protected void postInitialization() {
    }

    public final void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            super.service(request, response);
        }
        catch (Throwable th) {
            this.operationLog.error((Object)("Error processing request for method '" + request.getMethod() + "'."), th);
            try {
                PrintWriter writer = response.getWriter();
                this.printPretty(writer, th);
            }
            catch (IllegalStateException illegalStateException) {
                if (th instanceof Error) {
                    throw (Error)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                if (th instanceof ServletException) {
                    throw (ServletException)th;
                }
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                throw new Error("Unexpected error: " + th.getMessage());
            }
        }
    }

    private void printPretty(PrintWriter writer, Throwable throwable) {
        if (throwable instanceof HighLevelException) {
            Template template = ERROR_MESSAGE.createFreshCopy();
            template.bind("error-message", ((HighLevelException)throwable).getMessage());
            writer.write(template.createText());
        } else {
            Template template = FATAL_ERROR_MESSAGE.createFreshCopy();
            template.bind("error-message", throwable.toString());
        }
        writer.flush();
        writer.close();
    }

    public final void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        LogInitializer.init();
        try {
            this.initServiceServlet();
            if (this.operationLog.isInfoEnabled()) {
                this.operationLog.info((Object)String.format("'%s' successfully initialized.", ((Object)((Object)this)).getClass().getName()));
            }
        }
        catch (Exception ex) {
            this.notificationLog.fatal((Object)("Failure during '" + servletConfig.getServletName() + "' servlet initialization."), (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
    }
}

