/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server;

import ch.systemsx.cisd.cifex.rpc.server.IExtendedCIFEXRPCService;
import ch.systemsx.cisd.cifex.server.AbstractCIFEXServiceServlet;
import ch.systemsx.cisd.cifex.server.HttpUtils;
import ch.systemsx.cisd.cifex.server.business.IDomainModel;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.string.Template;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class AbstractFileUploadDownloadServlet
extends AbstractCIFEXServiceServlet {
    private static final long serialVersionUID = 1L;
    public static final int MAX_FILENAME_LENGTH = 250;
    public static final Template JNLP_TEMPLATE = new Template("<?xml version='1.0' encoding='utf-8'?>\n<jnlp spec='1.0+' codebase='${base-URL}'>\n  <information>\n    <title>${title}</title>\n    <vendor>Center for Information Science and Databases</vendor>\n    <description>${description}</description>\n  </information>\n  <security>\n    <all-permissions/>\n  </security>\n  <resources>\n    <j2se version='1.5+'/>\n    <jar href='cifex.jar'/>\n    <jar href='sis-base.jar'/>\n    <jar href='spring-web.jar'/>\n    <jar href='spring-context.jar'/>\n    <jar href='spring-beans.jar'/>\n    <jar href='spring-aop.jar'/>\n    <jar href='spring-core.jar'/>\n    <jar href='aopalliance.jar'/>\n    <jar href='stream-supporting-httpinvoker.jar'/>\n    <jar href='commons-codec.jar'/>\n    <jar href='commons-httpclient.jar'/>\n    <jar href='commons-io.jar'/>\n    <jar href='commons-lang.jar'/>\n    <jar href='commons-logging.jar'/>\n    <extension name='Bouncy Castle Crypto Provider' href='cifex/bouncycastle.jnlp'/>\n  </resources>\n  <application-desc main-class='${main-class}'>\n    <argument>${service-URL}</argument>\n    <argument>${session-id}</argument>\n  </application-desc>\n</jnlp>\n");
    protected static final String RECIPIENTS_FIELD_NAME = "email-addresses";
    protected static final String COMMENT_FIELD_NAME = "upload-comment";
    protected static final long MB = 0x100000L;
    protected IExtendedCIFEXRPCService service;

    protected String getURLForEmail(HttpServletRequest request) {
        return HttpUtils.getURLForEmail(request, this.domainModel.getBusinessContext());
    }

    protected String createBaseURL(HttpServletRequest request) {
        String url = HttpUtils.getBasicURL(request);
        url = url.indexOf("localhost:8888") > 0 ? String.valueOf(url) + "/ch.systemsx.cisd.cifex.Cifex/" : String.valueOf(url) + "/";
        return url;
    }

    protected String createServiceURL(HttpServletRequest request) {
        String baseURL = HttpUtils.getBasicURL(request);
        return String.valueOf(baseURL) + "/cifex/rpc-service";
    }

    protected AbstractFileUploadDownloadServlet() {
    }

    protected AbstractFileUploadDownloadServlet(IExtendedCIFEXRPCService service, IDomainModel domainModel) {
        this.service = service;
        this.domainModel = domainModel;
    }

    public void init() throws ServletException {
        super.init();
        try {
            ServletContext servletContext = this.getServletContext();
            WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
            this.service = (IExtendedCIFEXRPCService)context.getBean("rpc-service");
        }
        catch (Exception ex) {
            this.notificationLog.fatal((Object)"Failure during file service servlet initialization.", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, InvalidSessionException {
        UserDTO user = this.getUserDTO(request);
        String url = this.getURLForEmail(request);
        String sessionID = this.service.createSession(user, url);
        if (this.operationLog.isInfoEnabled()) {
            this.operationLog.info((Object)("Start file " + this.getOperationName() + " session with ID " + sessionID));
        }
        response.setContentType("application/x-java-jnlp-file");
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        Template template = JNLP_TEMPLATE.createFreshCopy();
        template.attemptToBind("title", this.getTitle());
        template.attemptToBind("description", this.getDescription());
        template.attemptToBind("base-URL", this.createBaseURL(request));
        template.attemptToBind("main-class", this.getMainClassName());
        template.attemptToBind("service-URL", this.createServiceURL(request));
        template.attemptToBind("session-id", sessionID);
        writer.print(template.createText());
        writer.close();
    }

    protected abstract String getMainClassName();

    protected abstract String getOperationName();

    protected abstract String getTitle();

    protected String getDescription() {
        return this.getTitle();
    }
}

