/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.cifex.client.Configuration;
import ch.systemsx.cisd.cifex.client.FileNotFoundException;
import ch.systemsx.cisd.cifex.client.ICIFEXService;
import ch.systemsx.cisd.cifex.client.InsufficientPrivilegesException;
import ch.systemsx.cisd.cifex.client.InvalidSessionException;
import ch.systemsx.cisd.cifex.client.UserNotFoundException;
import ch.systemsx.cisd.cifex.server.AbstractCIFEXService;
import ch.systemsx.cisd.cifex.server.HttpUtils;
import ch.systemsx.cisd.cifex.server.business.EMailBuilderForUpdateUser;
import ch.systemsx.cisd.cifex.server.business.FileInformation;
import ch.systemsx.cisd.cifex.server.business.IDomainModel;
import ch.systemsx.cisd.cifex.server.business.IFileManager;
import ch.systemsx.cisd.cifex.server.business.IUserActionLog;
import ch.systemsx.cisd.cifex.server.business.IUserManager;
import ch.systemsx.cisd.cifex.server.business.dto.FileDTO;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.cifex.server.common.Password;
import ch.systemsx.cisd.cifex.server.util.FileUploadFeedbackProvider;
import ch.systemsx.cisd.cifex.shared.basic.EnvironmentFailureException;
import ch.systemsx.cisd.cifex.shared.basic.dto.CurrentUserInfoDTO;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileInfoDTO;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileUploadFeedback;
import ch.systemsx.cisd.cifex.shared.basic.dto.Message;
import ch.systemsx.cisd.cifex.shared.basic.dto.OwnerFileInfoDTO;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.reflection.BeanUtils;
import ch.systemsx.cisd.common.servlet.IRequestContextProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class CIFEXServiceImpl
extends AbstractCIFEXService
implements ICIFEXService {
    static final String FILES_TO_UPLOAD = "files-to-upload";
    private static final long DELAY_AFTER_FAILED_LOGIN_MILLIS = 500L;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, CIFEXServiceImpl.class);

    public CIFEXServiceImpl(IDomainModel domainModel, IRequestContextProvider requestContextProvider, IUserActionLog userActionLog, IAuthenticationService externalAuthenticationService, int sessionExpirationPeriodMinutes) {
        super(domainModel, requestContextProvider, userActionLog, externalAuthenticationService, CIFEXServiceImpl.createLoggingContextHandler(requestContextProvider), sessionExpirationPeriodMinutes);
    }

    @Override
    public final Boolean showSwitchToExternalOption(UserInfoDTO user) {
        if (this.hasExternalAuthenticationService() && !user.isExternallyAuthenticated()) {
            return true;
        }
        return false;
    }

    private final UserDTO privGetCurrentUser() throws InvalidSessionException {
        HttpSession session = this.getSession(false);
        if (session == null) {
            throw new InvalidSessionException("You are not logged in or your session has expired. Please log in.");
        }
        return (UserDTO)session.getAttribute("cifex-user");
    }

    private void updateCurrentUser(UserDTO user) throws InvalidSessionException {
        if (!user.getID().equals(this.privGetCurrentUser().getID())) {
            return;
        }
        this.getSession(false).setAttribute("cifex-user", (Object)user);
    }

    private static String describeUser(UserDTO user) {
        if (user.isAdmin()) {
            return "admin user " + user.getUserCode();
        }
        if (user.isPermanent()) {
            return "permanent user " + user.getUserCode();
        }
        return "temporary user " + user.getUserCode();
    }

    private final void checkAdmin(String methodName) throws InvalidSessionException, InsufficientPrivilegesException {
        UserDTO user = this.privGetCurrentUser();
        if (!this.privGetCurrentUser().isAdmin()) {
            throw new InsufficientPrivilegesException("Method '" + methodName + "': insufficient privileges for " + CIFEXServiceImpl.describeUser(user) + ".");
        }
    }

    @Override
    public Boolean keepSessionAlive() {
        try {
            this.privGetCurrentUser();
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)(String.valueOf(this.userActionLog.getUserHostSessionDescription()) + "Keep alive ping: OK"));
            }
            return true;
        }
        catch (InvalidSessionException invalidSessionException) {
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)(String.valueOf(this.userActionLog.getUserHostSessionDescription()) + "Keep alive ping: FAILED"));
            }
            return false;
        }
    }

    @Override
    public final CurrentUserInfoDTO tryLogin(String userCode, String plainPassword) throws EnvironmentFailureException {
        UserDTO userDTOOrNull;
        block3: {
            try {
                userDTOOrNull = super.tryLoginUser(userCode, plainPassword);
                if (userDTOOrNull != null) break block3;
                this.userActionLog.logFailedLoginAttempt(userCode);
                ConcurrencyUtilities.sleep((long)500L);
                return null;
            }
            catch (ch.systemsx.cisd.common.exceptions.EnvironmentFailureException ex) {
                throw new EnvironmentFailureException(ex.getMessage());
            }
        }
        this.userActionLog.logSuccessfulLogin();
        CurrentUserInfoDTO currentUser = (CurrentUserInfoDTO)BeanUtils.createBean(CurrentUserInfoDTO.class, (Object)userDTOOrNull);
        currentUser.setHasFilesForDownload(this.domainModel.getUserManager().hasUserFilesForDownload(userDTOOrNull));
        return currentUser;
    }

    @Override
    public final Configuration getConfiguration() throws InvalidSessionException {
        Configuration configuration = (Configuration)BeanUtils.createBean(Configuration.class, (Object)this.domainModel.getBusinessContext());
        configuration.setSystemHasExternalAuthentication(this.hasExternalAuthenticationService());
        return configuration;
    }

    @Override
    public final CurrentUserInfoDTO getCurrentUser() throws InvalidSessionException {
        UserDTO userOrNull = this.privGetCurrentUser();
        if (userOrNull == null) {
            return null;
        }
        CurrentUserInfoDTO currentUser = (CurrentUserInfoDTO)BeanUtils.createBean(CurrentUserInfoDTO.class, (Object)userOrNull);
        currentUser.setHasFilesForDownload(this.domainModel.getUserManager().hasUserFilesForDownload(userOrNull));
        return currentUser;
    }

    @Override
    public UserInfoDTO refreshQuotaInformationOfCurrentUser() throws InvalidSessionException {
        IUserManager userManager = this.domainModel.getUserManager();
        UserDTO currentUser = this.privGetCurrentUser();
        userManager.refreshQuotaInformation(currentUser);
        return (UserInfoDTO)BeanUtils.createBean(UserInfoDTO.class, (Object)currentUser);
    }

    @Override
    public final UserInfoDTO trySwitchToExternalAuthentication(String userCode, String plainPassword) throws EnvironmentFailureException, InvalidSessionException, InsufficientPrivilegesException {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)("Try to switch to external authentication user '" + userCode + "'."));
        }
        this.ensureHasExternalAuthentication(userCode);
        IUserManager userManager = this.domainModel.getUserManager();
        UserDTO userDTOOrNull = userManager.tryFindUserByCode(userCode);
        this.ensureUserExistsInDatabase(userCode, userDTOOrNull);
        this.ensureUserIsNotExternallyAuthenticated(userCode, userDTOOrNull);
        try {
            userDTOOrNull = this.tryExternalAuthenticationServiceLogin(userCode, plainPassword);
        }
        catch (ch.systemsx.cisd.common.exceptions.EnvironmentFailureException ex) {
            throw new EnvironmentFailureException(ex.getMessage());
        }
        if (userDTOOrNull != null) {
            userDTOOrNull.setExternallyAuthenticated(true);
            userDTOOrNull.setExpirationDate(null);
            userDTOOrNull.setRegistrator(null);
            userManager.updateUser(userDTOOrNull, null, this.privGetCurrentUser(), null);
            this.copyUserDetailsExceptCode(this.privGetCurrentUser(), userDTOOrNull);
            this.userActionLog.logSwitchToExternalAuthentication(userCode, true);
            return (UserInfoDTO)BeanUtils.createBean(UserInfoDTO.class, (Object)userDTOOrNull);
        }
        this.userActionLog.logSwitchToExternalAuthentication(userCode, false);
        throw new InsufficientPrivilegesException("Password incorrect.");
    }

    private void ensureUserIsNotExternallyAuthenticated(String userCode, UserDTO userDTOOrNull) throws EnvironmentFailureException {
        if (userDTOOrNull.isExternallyAuthenticated()) {
            this.userActionLog.logSwitchToExternalAuthentication(userCode, false);
            throw new EnvironmentFailureException(String.format("User with code '%s' is already authenticated externally.", userCode));
        }
    }

    private void ensureUserExistsInDatabase(String userCode, UserDTO userDTOOrNull) throws EnvironmentFailureException {
        if (userDTOOrNull == null) {
            this.userActionLog.logSwitchToExternalAuthentication(userCode, false);
            throw new EnvironmentFailureException(String.format("User with code '%s' does not exist.", userCode));
        }
    }

    private void ensureHasExternalAuthentication(String userCode) throws EnvironmentFailureException {
        if (!this.hasExternalAuthenticationService()) {
            this.userActionLog.logSwitchToExternalAuthentication(userCode, false);
            throw new EnvironmentFailureException("No external authentication service available.");
        }
    }

    private void copyUserDetailsExceptCode(UserDTO to, UserDTO from) {
        to.setAdmin(from.isAdmin());
        to.setEmail(from.getEmail());
        to.setExpirationDate(from.getExpirationDate());
        to.setExternallyAuthenticated(from.isExternallyAuthenticated());
        to.setRegistrationDate(from.getRegistrationDate());
        to.setRegistrator(from.getRegistrator());
        to.setUserFullName(from.getUserFullName());
    }

    @Override
    public final List<UserInfoDTO> listUsers() throws InvalidSessionException, InsufficientPrivilegesException {
        this.checkAdmin("listUsers");
        List<UserDTO> users = this.domainModel.getUserManager().listUsers();
        return BeanUtils.createBeanList(UserInfoDTO.class, users, null);
    }

    /*
     * Exception decompiling
     */
    @Override
    public UserInfoDTO createUser(UserInfoDTO user, String password, String comment) throws EnvironmentFailureException, InvalidSessionException, InsufficientPrivilegesException, ch.systemsx.cisd.cifex.shared.basic.UserFailureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void ensureCodeIsValid(String code) {
        Pattern userCodePattern = Pattern.compile("^^([a-zA-Z0-9_\\.\\-\\@])+$");
        if (code == null || code.length() == 0 || !userCodePattern.matcher(code).matches()) {
            throw new IllegalArgumentException("Invalid user code. User code must not be empty and must contain only allowed characters: letters, digits, '_', '.', '-', '@'. Note that whitespaces are not allowed.");
        }
    }

    private UserDTO tryCreateUserFromExternalAuthenticationService(UserInfoDTO user) throws EnvironmentFailureException, ch.systemsx.cisd.cifex.shared.basic.UserFailureException, InvalidSessionException {
        if (!this.hasExternalAuthenticationService()) {
            return null;
        }
        String userCode = user.getUserCode();
        Principal principalOrNull = this.externalAuthenticationService.tryGetAndAuthenticateUser(userCode, null);
        if (principalOrNull != null) {
            if (!this.privGetCurrentUser().isAdmin()) {
                String msg = "Cannot create user '" + user.getUserCode() + "': user exists.";
                operationLog.error((Object)msg);
                throw new ch.systemsx.cisd.cifex.shared.basic.UserFailureException(msg);
            }
            return this.createOrUpdateUserFromExternalAuthenticationService(principalOrNull, user);
        }
        return null;
    }

    private final String getBasicURL() {
        return HttpUtils.getBasicURL(this.requestContextProvider.getHttpServletRequest());
    }

    private void checkCreateUserAllowed(UserInfoDTO user) throws InvalidSessionException, InsufficientPrivilegesException {
        UserDTO currentUser = this.privGetCurrentUser();
        if (!currentUser.isPermanent()) {
            operationLog.warn((Object)String.format("Insufficient privileges: temporary user %s tried to create a user (%s).", currentUser.getUserCode(), user.getUserCode()));
            throw new InsufficientPrivilegesException("Method 'createUser': insufficient privileges for " + CIFEXServiceImpl.describeUser(currentUser) + ".");
        }
        if (!currentUser.isAdmin() && (user.isPermanent() || user.isAdmin())) {
            operationLog.warn((Object)String.format("Insufficient privileges: non-admin user %s tried to create a%s user (%s).", currentUser.getUserCode(), user.isAdmin() ? "n admin" : " permanent", user.getUserCode()));
            throw new InsufficientPrivilegesException("Method 'createUser': insufficient privileges for " + CIFEXServiceImpl.describeUser(currentUser) + ".");
        }
    }

    @Override
    public FileInfoDTO getFile(long fileId) throws InvalidSessionException, InsufficientPrivilegesException, IllegalArgumentException {
        FileDTO fileDTO;
        UserDTO requestUser = this.privGetCurrentUser();
        IFileManager fileManager = this.domainModel.getFileManager();
        if (!fileManager.isAllowedAccess(requestUser, fileDTO = fileManager.getFile(fileId))) {
            throw new InsufficientPrivilegesException("Insufficient privileges for " + CIFEXServiceImpl.describeUser(requestUser) + ".");
        }
        return (FileInfoDTO)BeanUtils.createBean(FileInfoDTO.class, (Object)fileDTO);
    }

    @Override
    public List<OwnerFileInfoDTO> listFiles() throws InvalidSessionException, InsufficientPrivilegesException {
        this.checkAdmin("listFiles");
        List<FileDTO> files = this.domainModel.getFileManager().listFiles();
        return BeanUtils.createBeanList(OwnerFileInfoDTO.class, files, null);
    }

    @Override
    public final List<FileInfoDTO> listDownloadFiles() throws InvalidSessionException {
        UserDTO user = this.privGetCurrentUser();
        List<FileDTO> files = this.domainModel.getFileManager().listDownloadFiles(user.getID());
        return BeanUtils.createBeanList(FileInfoDTO.class, files, null);
    }

    @Override
    public final List<OwnerFileInfoDTO> listOwnedFiles() throws InvalidSessionException {
        UserDTO user = this.privGetCurrentUser();
        List<FileDTO> files = this.domainModel.getFileManager().listOwnedFiles(user.getID());
        return BeanUtils.createBeanList(OwnerFileInfoDTO.class, files, null);
    }

    @Override
    public void deleteUser(long id) throws InvalidSessionException, InsufficientPrivilegesException, UserNotFoundException {
        UserDTO user = this.domainModel.getUserManager().getUser(id);
        this.checkUpdateOfUserIsAllowed(user, user);
        try {
            this.domainModel.getUserManager().deleteUser(id, this.privGetCurrentUser(), this.userActionLog);
        }
        catch (UserFailureException ex) {
            throw new UserNotFoundException(ex.getMessage());
        }
    }

    @Override
    public void deleteFile(long id) throws InvalidSessionException, InsufficientPrivilegesException, FileNotFoundException {
        UserDTO requestUser = this.privGetCurrentUser();
        IFileManager fileManager = this.domainModel.getFileManager();
        FileInformation fileInfo = fileManager.getFileInformationFilestoreUnimportant(id);
        if (!fileInfo.isFileAvailable()) {
            throw new FileNotFoundException(fileInfo.getErrorMessage());
        }
        boolean success = false;
        try {
            if (!fileManager.isControlling(requestUser, fileInfo.getFileDTO())) {
                throw new InsufficientPrivilegesException("Insufficient privileges for " + CIFEXServiceImpl.describeUser(requestUser) + ".");
            }
            fileManager.deleteFile(fileInfo.getFileDTO());
            success = true;
        }
        finally {
            this.userActionLog.logDeleteFile(fileInfo.getFileDTO(), success);
        }
    }

    @Override
    public final void registerFilenamesForUpload(String[] filenamesForUpload) throws InvalidSessionException {
        assert (filenamesForUpload != null && filenamesForUpload.length > 0) : "No file path found.";
        this.privGetCurrentUser();
        HttpSession session = this.getSession(false);
        session.setAttribute(FILES_TO_UPLOAD, (Object)filenamesForUpload);
        FileUploadFeedbackProvider feedbackProvider = (FileUploadFeedbackProvider)session.getAttribute("upload-feedback-queue");
        feedbackProvider.set(new FileUploadFeedback());
    }

    @Override
    public final FileUploadFeedback getFileUploadFeedback() throws InvalidSessionException {
        this.privGetCurrentUser();
        HttpSession session = this.getSession(false);
        FileUploadFeedbackProvider feedbackProvider = (FileUploadFeedbackProvider)session.getAttribute("upload-feedback-queue");
        assert (feedbackProvider != null) : "Provider must not be null.";
        try {
            return feedbackProvider.take();
        }
        catch (InterruptedException ex) {
            FileUploadFeedback feedback = new FileUploadFeedback();
            feedback.setMessage(new Message(Message.Type.ERROR, ex.getClass().getSimpleName()));
            return feedback;
        }
    }

    @Override
    public UserInfoDTO updateUser(UserInfoDTO user, String plainPassword, boolean sendUpdateInformationToUser) throws InvalidSessionException, InsufficientPrivilegesException, EnvironmentFailureException {
        assert (user != null) : "User can't be null";
        IUserManager userManager = this.domainModel.getUserManager();
        UserDTO newUserDTO = (UserDTO)BeanUtils.createBean(UserDTO.class, (Object)user);
        UserDTO oldUserDTO = userManager.tryFindUserByCode(user.getUserCode());
        UserDTO newUserRegistratorOrNull = newUserDTO.getRegistrator();
        if (newUserRegistratorOrNull != null && (oldUserDTO.getRegistrator().getID().equals(newUserRegistratorOrNull.getID()) || newUserRegistratorOrNull.getID() == 0L)) {
            newUserRegistratorOrNull.setID(null);
        }
        this.checkUpdateOfUserIsAllowed(oldUserDTO, newUserDTO);
        UserDTO updatedUser = userManager.updateUser(oldUserDTO, newUserDTO, new Password(plainPassword), this.privGetCurrentUser(), this.userActionLog);
        UserInfoDTO updatedUserInfo = (UserInfoDTO)BeanUtils.createBean(UserInfoDTO.class, (Object)updatedUser);
        this.updateCurrentUser(updatedUser);
        if (sendUpdateInformationToUser) {
            if (StringUtils.isEmpty((String)user.getEmail())) {
                operationLog.warn((Object)String.format("Sending email to user '%s' not possible: email address is empty.", user));
                return updatedUserInfo;
            }
            try {
                IMailClient mailClient = this.domainModel.getMailClient();
                EMailBuilderForUpdateUser builder = new EMailBuilderForUpdateUser(mailClient, this.privGetCurrentUser(), newUserDTO);
                builder.setURL(this.getBasicURL());
                if (StringUtils.isNotBlank((String)plainPassword)) {
                    builder.setPassword(plainPassword);
                }
                builder.sendEMail();
            }
            catch (Exception ex) {
                String msg = "Sending email to email '" + user.getEmail() + "' failed: " + ex.getMessage();
                operationLog.error((Object)msg, (Throwable)ex);
                throw new EnvironmentFailureException(msg);
            }
        }
        return updatedUserInfo;
    }

    @Override
    public final void changeUserCode(String before, String after) throws InvalidSessionException, InsufficientPrivilegesException, EnvironmentFailureException {
        IUserManager userManager = this.domainModel.getUserManager();
        UserDTO requestUser = this.privGetCurrentUser();
        this.ensureCodeIsValid(after);
        UserDTO userBefore = userManager.tryFindUserByCode(before);
        if (!(!requestUser.isAdmin() || requestUser.getUserCode().equals(before) || userBefore != null && userBefore.isExternallyAuthenticated())) {
            boolean success = false;
            try {
                userManager.changeUserCode(before, after);
                success = true;
            }
            finally {
                this.userActionLog.logChangeUserCode(before, after, success);
            }
            UserDTO user = userManager.tryFindUserByCode(after);
            if (StringUtils.isEmpty((String)user.getEmail())) {
                operationLog.warn((Object)String.format("Sending email to user '%s' not possible: email address is empty.", user));
                return;
            }
            try {
                IMailClient mailClient = this.domainModel.getMailClient();
                EMailBuilderForUpdateUser builder = new EMailBuilderForUpdateUser(mailClient, this.privGetCurrentUser(), user);
                builder.setURL(this.getBasicURL());
                builder.sendEMail();
            }
            catch (Exception ex) {
                String msg = "Sending email to email '" + user.getEmail() + "' failed: " + ex.getMessage();
                operationLog.error((Object)msg, (Throwable)ex);
                throw new EnvironmentFailureException(msg);
            }
        }
        throw new InsufficientPrivilegesException("Insufficient privileges for " + CIFEXServiceImpl.describeUser(requestUser) + ".");
    }

    private final void checkUpdateOfUserIsAllowed(UserDTO oldUser, UserDTO userToUpdate) throws InvalidSessionException, InsufficientPrivilegesException {
        CIFEXServiceImpl.checkUpdateOfUserIsAllowed(oldUser, userToUpdate, this.privGetCurrentUser(), this.domainModel.getUserManager());
    }

    @Private
    static final void checkUpdateOfUserIsAllowed(UserDTO oldUser, UserDTO userToUpdate, UserDTO requestUser, IUserManager userManager) throws InvalidSessionException, InsufficientPrivilegesException {
        if (!requestUser.isActive()) {
            throw new InsufficientPrivilegesException("Insufficient privileges for " + CIFEXServiceImpl.describeUser(requestUser) + ".");
        }
        if (requestUser.isAdmin()) {
            return;
        }
        if (!requestUser.isPermanent()) {
            throw new InsufficientPrivilegesException("Insufficient privileges for " + CIFEXServiceImpl.describeUser(requestUser) + ".");
        }
        if (userToUpdate.isActive() != oldUser.isActive() || userToUpdate.isPermanent() != oldUser.isPermanent() || userToUpdate.isAdmin() != oldUser.isAdmin()) {
            throw new InsufficientPrivilegesException("Insufficient privileges for " + CIFEXServiceImpl.describeUser(requestUser) + ".");
        }
        if (requestUser.getUserCode().equals(userToUpdate.getUserCode())) {
            return;
        }
        List<UserDTO> usersCreatedByRequestUser = userManager.listUsersRegisteredBy(requestUser.getID());
        for (UserDTO user : usersCreatedByRequestUser) {
            if (!user.getUserCode().equals(userToUpdate.getUserCode())) continue;
            if (user.isAdmin() || user.isPermanent() || userToUpdate.isAdmin() || userToUpdate.isPermanent()) {
                throw new InsufficientPrivilegesException("Insufficient privileges for " + CIFEXServiceImpl.describeUser(requestUser) + ".");
            }
            return;
        }
        throw new InsufficientPrivilegesException("Insufficient privileges for " + CIFEXServiceImpl.describeUser(requestUser) + ".");
    }

    @Override
    public UserInfoDTO getUser(long id) throws InvalidSessionException, InsufficientPrivilegesException {
        IUserManager userManager = this.domainModel.getUserManager();
        UserDTO userDTO = userManager.getUser(id);
        this.checkUpdateOfUserIsAllowed(userDTO, userDTO);
        return (UserInfoDTO)BeanUtils.createBean(UserInfoDTO.class, (Object)userDTO);
    }

    @Override
    public UserInfoDTO tryFindUserByUserCode(String userCode) throws InvalidSessionException {
        this.privGetCurrentUser();
        IUserManager userManager = this.domainModel.getUserManager();
        UserDTO userDTO = userManager.tryFindUserByCode(userCode);
        return (UserInfoDTO)BeanUtils.createBean(UserInfoDTO.class, (Object)userDTO);
    }

    @Override
    public UserInfoDTO tryFindUserByUserCodeOrCreate(String userCode) throws InvalidSessionException, ch.systemsx.cisd.cifex.shared.basic.UserFailureException, EnvironmentFailureException {
        Collection<UserDTO> users;
        block5: {
            this.privGetCurrentUser();
            IUserManager userManager = this.domainModel.getUserManager();
            users = userManager.getUsers(Arrays.asList(userCode), null, this.userActionLog);
            if (!users.isEmpty()) break block5;
            return null;
        }
        try {
            assert (users.size() == 1);
            return (UserInfoDTO)BeanUtils.createBean(UserInfoDTO.class, (Object)users.iterator().next());
        }
        catch (UserFailureException e) {
            throw new ch.systemsx.cisd.cifex.shared.basic.UserFailureException(e.getMessage());
        }
        catch (ConfigurationFailureException e) {
            throw new EnvironmentFailureException(e.getMessage());
        }
    }

    @Override
    public List<UserInfoDTO> findUserByEmail(String email) throws InvalidSessionException, ch.systemsx.cisd.cifex.shared.basic.UserFailureException, EnvironmentFailureException {
        try {
            this.privGetCurrentUser();
            IUserManager userManager = this.domainModel.getUserManager();
            Collection<UserDTO> users = userManager.getUsers(null, Arrays.asList(email), this.userActionLog);
            return BeanUtils.createBeanList(UserInfoDTO.class, users);
        }
        catch (UserFailureException e) {
            throw new ch.systemsx.cisd.cifex.shared.basic.UserFailureException(e.getMessage());
        }
        catch (ConfigurationFailureException e) {
            throw new EnvironmentFailureException(e.getMessage());
        }
    }

    @Override
    public List<UserInfoDTO> listUsersOwnedBy(long userId) throws InvalidSessionException, InsufficientPrivilegesException {
        UserDTO requestUser = this.privGetCurrentUser();
        if (!requestUser.isAdmin() && requestUser.getID() != userId) {
            throw new InsufficientPrivilegesException("Insufficient privileges for " + CIFEXServiceImpl.describeUser(requestUser) + ".");
        }
        IUserManager userManager = this.domainModel.getUserManager();
        List<UserDTO> users = userManager.listUsersRegisteredBy(userId);
        return BeanUtils.createBeanList(UserInfoDTO.class, users, null);
    }

    @Override
    public Date updateFileUserData(long fileId, String name, String commentOrNull, Date expirationDate) throws InvalidSessionException, InsufficientPrivilegesException {
        UserDTO requestUser = this.privGetCurrentUser();
        IFileManager fileManager = this.domainModel.getFileManager();
        FileDTO file = fileManager.getFile(fileId);
        Date newExpirationDate = null;
        boolean success = false;
        try {
            if (!fileManager.isControlling(requestUser, file)) {
                throw new InsufficientPrivilegesException("Insufficient privileges for " + CIFEXServiceImpl.describeUser(requestUser) + ".");
            }
            newExpirationDate = fileManager.updateFileUserData(fileId, name, commentOrNull, expirationDate, requestUser);
            success = true;
            Date date = newExpirationDate;
            this.userActionLog.logEditFile(fileId, name, newExpirationDate, success);
            return date;
        }
        catch (Throwable throwable) {
            this.userActionLog.logEditFile(fileId, name, newExpirationDate, success);
            throw throwable;
        }
    }

    @Override
    public List<UserInfoDTO> listUsersFileSharedWith(long fileId) throws InvalidSessionException, InsufficientPrivilegesException {
        FileDTO file;
        UserDTO requestUser = this.privGetCurrentUser();
        IFileManager fileManager = this.domainModel.getFileManager();
        if (!fileManager.isAllowedAccess(requestUser, file = fileManager.getFile(fileId))) {
            throw new InsufficientPrivilegesException("Insufficient privileges for " + CIFEXServiceImpl.describeUser(requestUser) + ".");
        }
        IUserManager userManager = this.domainModel.getUserManager();
        List<UserDTO> users = userManager.listUsersFileSharedWith(fileId);
        return BeanUtils.createBeanList(UserInfoDTO.class, users, null);
    }

    @Override
    public void updateSharingLinks(long fileId, List<String> usersToAdd, List<String> usersToRemove) throws InvalidSessionException, InsufficientPrivilegesException, FileNotFoundException, ch.systemsx.cisd.cifex.shared.basic.UserFailureException, EnvironmentFailureException {
        for (String user : usersToAdd) {
            this.createSharingLink(fileId, user);
        }
        for (String user : usersToRemove) {
            this.deleteSharingLink(fileId, user);
        }
    }

    private void deleteSharingLink(long fileId, String userCode) throws InvalidSessionException, InsufficientPrivilegesException, FileNotFoundException {
        UserDTO requestUser = this.privGetCurrentUser();
        IFileManager fileManager = this.domainModel.getFileManager();
        FileInformation fileInfo = fileManager.getFileInformationFilestoreUnimportant(fileId);
        if (!fileInfo.isFileAvailable()) {
            throw new FileNotFoundException(fileInfo.getErrorMessage());
        }
        boolean success = false;
        try {
            if (!fileManager.isControlling(requestUser, fileInfo.getFileDTO())) {
                throw new InsufficientPrivilegesException("Insufficient privileges for " + CIFEXServiceImpl.describeUser(requestUser) + ".");
            }
            fileManager.deleteSharingLink(fileId, userCode);
            success = true;
        }
        finally {
            this.userActionLog.logDeleteSharingLink(fileId, userCode, success);
        }
    }

    private void createSharingLink(long fileId, String userIdentifiers) throws ch.systemsx.cisd.cifex.shared.basic.UserFailureException, InvalidSessionException, InsufficientPrivilegesException, FileNotFoundException, EnvironmentFailureException {
        List<String> invalidEmailAddresses;
        UserDTO requestUser = this.privGetCurrentUser();
        IFileManager fileManager = this.domainModel.getFileManager();
        FileInformation fileInfo = fileManager.getFileInformation(fileId);
        if (!fileInfo.isFileAvailable()) {
            throw new FileNotFoundException(fileInfo.getErrorMessage());
        }
        if (!fileManager.isControlling(requestUser, fileInfo.getFileDTO())) {
            throw new InsufficientPrivilegesException("Insufficient privileges for " + CIFEXServiceImpl.describeUser(requestUser) + ".");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(userIdentifiers, ", \t\n\r\f");
        ArrayList<String> userIdentifierList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            userIdentifierList.add(stringTokenizer.nextToken());
        }
        ArrayList<FileDTO> files = new ArrayList<FileDTO>();
        files.add(fileInfo.getFileDTO());
        String url = this.domainModel.getBusinessContext().getOverrideURL();
        if (StringUtils.isBlank((String)url)) {
            url = this.getBasicURL();
        }
        try {
            invalidEmailAddresses = fileManager.shareFilesWith(url, requestUser, userIdentifierList, files, fileInfo.getFileDTO().getComment(), this.userActionLog);
        }
        catch (UserFailureException e) {
            throw new ch.systemsx.cisd.cifex.shared.basic.UserFailureException(e.getMessage());
        }
        catch (ConfigurationFailureException e) {
            throw new EnvironmentFailureException(e.getMessage());
        }
        if (!invalidEmailAddresses.isEmpty()) {
            String msg = "Some email addresses are invalid: " + CollectionUtils.abbreviate(invalidEmailAddresses, (int)10);
            throw new ch.systemsx.cisd.cifex.shared.basic.UserFailureException(msg);
        }
    }
}

