/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server;

import ch.systemsx.cisd.cifex.client.Configuration;
import ch.systemsx.cisd.cifex.client.FileNotFoundException;
import ch.systemsx.cisd.cifex.client.ICIFEXService;
import ch.systemsx.cisd.cifex.client.InsufficientPrivilegesException;
import ch.systemsx.cisd.cifex.client.InvalidSessionException;
import ch.systemsx.cisd.cifex.client.UserNotFoundException;
import ch.systemsx.cisd.cifex.shared.basic.EnvironmentFailureException;
import ch.systemsx.cisd.cifex.shared.basic.UserFailureException;
import ch.systemsx.cisd.cifex.shared.basic.dto.CurrentUserInfoDTO;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileInfoDTO;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileUploadFeedback;
import ch.systemsx.cisd.cifex.shared.basic.dto.OwnerFileInfoDTO;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.servlet.GWTSpringController;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class CIFEXServiceServlet
extends GWTSpringController
implements ICIFEXService {
    private static final String CIFEX_SERVICE_BEAN_NAME = "cifex-service";
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, CIFEXServiceServlet.class);
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, CIFEXServiceServlet.class);
    private static final long serialVersionUID = 1L;
    private ICIFEXService cifexServiceDelegate;

    private final void initService(ServletContext servletContext) {
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        this.cifexServiceDelegate = (ICIFEXService)context.getBean(CIFEX_SERVICE_BEAN_NAME);
    }

    @Override
    public Configuration getConfiguration() throws InvalidSessionException {
        return this.cifexServiceDelegate.getConfiguration();
    }

    @Override
    public final CurrentUserInfoDTO getCurrentUser() throws InvalidSessionException {
        return this.cifexServiceDelegate.getCurrentUser();
    }

    @Override
    public UserInfoDTO refreshQuotaInformationOfCurrentUser() throws InvalidSessionException {
        return this.cifexServiceDelegate.refreshQuotaInformationOfCurrentUser();
    }

    @Override
    public Boolean keepSessionAlive() {
        return this.cifexServiceDelegate.keepSessionAlive();
    }

    @Override
    public final UserInfoDTO tryLogin(String user, String password) throws UserFailureException, EnvironmentFailureException {
        return this.cifexServiceDelegate.tryLogin(user, password);
    }

    @Override
    public final void logout() {
        this.cifexServiceDelegate.logout();
    }

    @Override
    public List<FileInfoDTO> listDownloadFiles() throws InvalidSessionException {
        return this.cifexServiceDelegate.listDownloadFiles();
    }

    @Override
    public List<OwnerFileInfoDTO> listOwnedFiles() throws InvalidSessionException {
        return this.cifexServiceDelegate.listOwnedFiles();
    }

    @Override
    public List<OwnerFileInfoDTO> listFiles() throws InvalidSessionException, InsufficientPrivilegesException {
        return this.cifexServiceDelegate.listFiles();
    }

    @Override
    public List<UserInfoDTO> listUsers() throws InvalidSessionException, InsufficientPrivilegesException {
        return this.cifexServiceDelegate.listUsers();
    }

    @Override
    public UserInfoDTO createUser(UserInfoDTO user, String password, String comment) throws EnvironmentFailureException, UserFailureException, InvalidSessionException, InsufficientPrivilegesException {
        return this.cifexServiceDelegate.createUser(user, password, comment);
    }

    @Override
    public void deleteUser(long code) throws InvalidSessionException, InsufficientPrivilegesException, UserNotFoundException {
        this.cifexServiceDelegate.deleteUser(code);
    }

    @Override
    public FileInfoDTO getFile(long fileId) throws InvalidSessionException, InsufficientPrivilegesException, IllegalArgumentException {
        return this.cifexServiceDelegate.getFile(fileId);
    }

    @Override
    public void deleteFile(long id) throws InvalidSessionException, InsufficientPrivilegesException, FileNotFoundException {
        this.cifexServiceDelegate.deleteFile(id);
    }

    @Override
    public void registerFilenamesForUpload(String[] filenamesForUpload) throws InvalidSessionException {
        this.cifexServiceDelegate.registerFilenamesForUpload(filenamesForUpload);
    }

    @Override
    public FileUploadFeedback getFileUploadFeedback() throws InvalidSessionException {
        return this.cifexServiceDelegate.getFileUploadFeedback();
    }

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.initService(config.getServletContext());
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)String.format("'%s' successfully initialized.", this.getClass().getName()));
            }
        }
        catch (Exception ex) {
            notificationLog.fatal((Object)"Failure during CIFEX service servlet initialization.", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
    }

    @Override
    public UserInfoDTO updateUser(UserInfoDTO user, String password, boolean sendUpdateInformationToUser) throws InvalidSessionException, InsufficientPrivilegesException, EnvironmentFailureException {
        return this.cifexServiceDelegate.updateUser(user, password, sendUpdateInformationToUser);
    }

    @Override
    public UserInfoDTO getUser(long id) throws InvalidSessionException, InsufficientPrivilegesException {
        return this.cifexServiceDelegate.getUser(id);
    }

    @Override
    public UserInfoDTO tryFindUserByUserCode(String userCode) throws InvalidSessionException {
        return this.cifexServiceDelegate.tryFindUserByUserCode(userCode);
    }

    @Override
    public UserInfoDTO tryFindUserByUserCodeOrCreate(String userCode) throws UserFailureException, EnvironmentFailureException {
        return this.cifexServiceDelegate.tryFindUserByUserCodeOrCreate(userCode);
    }

    @Override
    public List<UserInfoDTO> findUserByEmail(String email) throws UserFailureException, EnvironmentFailureException {
        return this.cifexServiceDelegate.findUserByEmail(email);
    }

    @Override
    public List<UserInfoDTO> listUsersOwnedBy(long userId) throws InvalidSessionException, InsufficientPrivilegesException {
        return this.cifexServiceDelegate.listUsersOwnedBy(userId);
    }

    @Override
    public Date updateFileUserData(long fileId, String name, String commentOrNull, Date expirationDate) throws InvalidSessionException, InsufficientPrivilegesException {
        return this.cifexServiceDelegate.updateFileUserData(fileId, name, commentOrNull, expirationDate);
    }

    @Override
    public List<UserInfoDTO> listUsersFileSharedWith(long fileId) throws InvalidSessionException, InsufficientPrivilegesException {
        return this.cifexServiceDelegate.listUsersFileSharedWith(fileId);
    }

    @Override
    public void updateSharingLinks(long fileId, List<String> usersToAdd, List<String> usersToRemove) throws InvalidSessionException, InsufficientPrivilegesException, FileNotFoundException, UserFailureException, EnvironmentFailureException {
        this.cifexServiceDelegate.updateSharingLinks(fileId, usersToAdd, usersToRemove);
    }

    @Override
    public void changeUserCode(String before, String after) throws InvalidSessionException, InsufficientPrivilegesException, EnvironmentFailureException {
        this.cifexServiceDelegate.changeUserCode(before, after);
    }

    @Override
    public UserInfoDTO trySwitchToExternalAuthentication(String userCode, String plainPassword) throws EnvironmentFailureException, InvalidSessionException, InsufficientPrivilegesException {
        return this.cifexServiceDelegate.trySwitchToExternalAuthentication(userCode, plainPassword);
    }

    @Override
    public Boolean showSwitchToExternalOption(UserInfoDTO user) {
        return this.cifexServiceDelegate.showSwitchToExternalOption(user);
    }
}

