/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server;

import ch.systemsx.cisd.cifex.server.business.IDomainModel;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.Date;
import java.util.TimerTask;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;

public final class CleanUpDaemon
extends TimerTask {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, CleanUpDaemon.class);
    private final Stopwatch timer = new Stopwatch();
    private final IDomainModel domainModel;
    private Date dayLastRun;

    public CleanUpDaemon(IDomainModel domainModel) {
        this.domainModel = domainModel;
    }

    private final void deleteExpiredFiles() {
        this.domainModel.getFileManager().deleteExpiredFiles(this.domainModel.getBusinessContext().getUserActionLogHttp());
    }

    private final void deleteExpiredUsers() {
        this.domainModel.getUserManager().deleteExpiredUsers(this.domainModel.getBusinessContext().getUserActionLogHttp());
    }

    @Override
    public final void run() {
        Date today = DateUtils.truncate((Date)new Date(), (int)5);
        if (today.equals(this.dayLastRun)) {
            return;
        }
        this.dayLastRun = today;
        try {
            this.timer.start();
            this.deleteExpiredUsers();
            this.deleteExpiredFiles();
            this.timer.stop();
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)("Cleaning time: " + this.timer.getTimeElapsed() + " ms"));
            }
        }
        catch (Throwable th) {
            operationLog.error((Object)"Unexpected exception or error, thread is still running.", th);
        }
    }

    private static final class Stopwatch {
        private long start = 0L;
        private long stop = 0L;

        private Stopwatch() {
        }

        void start() {
            this.start = System.currentTimeMillis();
        }

        void stop() {
            this.stop = System.currentTimeMillis();
        }

        long getTimeElapsed() {
            return this.stop - this.start;
        }
    }
}

