/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.cifex.server.business.IBusinessContext;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public final class HttpUtils {
    public static final String getBasicURL(HttpServletRequest request) {
        String scheme = request.getScheme();
        String serverName = request.getServerName();
        int port = request.getServerPort();
        String contextPath = StringUtils.defaultString((String)request.getContextPath());
        try {
            return new URL(scheme, serverName, port, contextPath).toString();
        }
        catch (MalformedURLException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    public static final String getURLForEmail(HttpServletRequest request, IBusinessContext businessContext) {
        String overrideURL = businessContext.getOverrideURL();
        if (StringUtils.isBlank((String)overrideURL)) {
            return HttpUtils.getBasicURL(request);
        }
        return overrideURL;
    }

    private HttpUtils() {
    }
}

