/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.cifex.rpc.server.Session;
import ch.systemsx.cisd.cifex.server.AbstractCIFEXService;
import ch.systemsx.cisd.cifex.server.business.IUserActionLog;
import ch.systemsx.cisd.cifex.server.business.dto.FileDTO;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.cifex.server.common.Password;
import ch.systemsx.cisd.common.servlet.AbstractActionLog;
import ch.systemsx.cisd.common.servlet.IActionLog;
import ch.systemsx.cisd.common.servlet.IRequestContextProvider;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.mock.web.MockHttpServletRequest;

public final class UserActionLog
extends AbstractActionLog
implements IUserActionLog {
    private static final String USER_SESSION_RPC_TEMPLATE = "{USER: %s, RPCSESSION: %s} logout%s";
    private static final String USER_HOST_RPC_SESSION_TEMPLATE = "{USER: %s, HOST: %s, RPCSESSION: %s} ";
    private static final String TEMPORARY_UNTIL_STR = "TEMPORARY until ";
    private static final String REGULAR_STR = "REGULAR";
    private static final String ADMIN_STR = "ADMIN";
    private static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss zzz";
    private static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz");
    private final boolean useRPCSession;

    public UserActionLog(IRequestContextProvider requestContextProvider, boolean useRPCSession, String testingFlag) {
        super("true".equals(testingFlag) ? new IRequestContextProvider(){

            public HttpServletRequest getHttpServletRequest() {
                return new MockHttpServletRequest();
            }
        } : requestContextProvider);
        this.useRPCSession = useRPCSession;
    }

    protected String getUserCode(HttpSession httpSession) {
        Session sessionOrNull = AbstractCIFEXService.tryGetRPCSession(httpSession);
        if (this.useRPCSession && sessionOrNull != null) {
            return sessionOrNull.getUser().getUserCode();
        }
        UserDTO userDTOOrNull = (UserDTO)httpSession.getAttribute("cifex-user");
        if (userDTOOrNull != null) {
            return userDTOOrNull.getUserCode();
        }
        return "-";
    }

    @Override
    public String getUserHostSessionDescription() {
        Session sessionOrNull = AbstractCIFEXService.tryGetRPCSession(this.getHttpSession());
        if (this.useRPCSession && sessionOrNull != null) {
            String remoteHost = this.remoteHostProvider.getRemoteHost();
            String userName = sessionOrNull.getUser().getUserCode();
            String id = sessionOrNull.getSessionID();
            return String.format(USER_HOST_RPC_SESSION_TEMPLATE, userName, remoteHost, id);
        }
        return super.getUserHostSessionDescription();
    }

    @Override
    public void logCreateUser(UserDTO user, boolean success) {
        if (this.trackingLog.isInfoEnabled()) {
            this.trackingLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("create_user '%s': %s", UserActionLog.getUserDescription(user), UserActionLog.getSuccessString((boolean)success))));
        }
    }

    private static String getMessageWhatChanged(UserDTO oldUser, UserDTO newUser) {
        assert (oldUser != null);
        assert (newUser != null);
        StringBuilder result = new StringBuilder();
        UserState oldState = UserState.getState(oldUser);
        UserState newState = UserState.getState(newUser);
        if (!newState.equals((Object)oldState)) {
            result.append("STATE: ");
            result.append((Object)oldState);
            result.append("->");
            result.append((Object)newState);
            result.append(", ");
        }
        if (!Password.equals(oldUser.getPassword(), newUser.getPassword())) {
            result.append("PASSWORD, ");
        }
        if (UserActionLog.changed(oldUser.getUserFullName(), newUser.getUserFullName())) {
            result.append("FULLNAME, ");
        }
        if (UserActionLog.changed(oldUser.getEmail(), newUser.getEmail())) {
            result.append("EMAIL, ");
        }
        if (UserState.TEMPORARY.equals((Object)oldState) && UserState.TEMPORARY.equals((Object)newState)) {
            Date oldExpirationDate = oldUser.getExpirationDate();
            Date newExpirationDate = newUser.getExpirationDate();
            if (newExpirationDate != null && !newExpirationDate.equals(oldExpirationDate)) {
                result.append("RENEW, ");
            }
        }
        if (result.length() == 0) {
            result.append("UNCHANGED");
        } else {
            result.setLength(result.length() - 2);
        }
        return result.toString();
    }

    @Private
    static boolean changed(String string1OrNull, String string2OrNull) {
        return !StringUtils.equals((String)string1OrNull, (String)string2OrNull) && (!StringUtils.isBlank((String)string1OrNull) || !StringUtils.isBlank((String)string2OrNull));
    }

    @Override
    public void logUpdateUser(UserDTO oldUser, UserDTO newUser, boolean success) {
        if (this.trackingLog.isInfoEnabled()) {
            String whatChanged = UserActionLog.getMessageWhatChanged(oldUser, newUser);
            this.trackingLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("update_user '%s' [%s]: %s", UserActionLog.getUserDescription(newUser), whatChanged, UserActionLog.getSuccessString((boolean)success))));
        }
    }

    @Override
    public void logDeleteUser(UserDTO user, boolean success) {
        if (this.trackingLog.isInfoEnabled()) {
            this.trackingLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("delete_user '%s': %s", UserActionLog.getUserDescription(user), UserActionLog.getSuccessString((boolean)success))));
        }
    }

    @Override
    public void logExpireUser(UserDTO user, boolean success) {
        if (this.trackingLog.isInfoEnabled()) {
            this.trackingLog.info((Object)String.format("{SYSTEM} delete_user '%s': %s", UserActionLog.getUserDescription(user), UserActionLog.getSuccessString((boolean)success)));
        }
    }

    private static String getUserDescription(UserDTO user) {
        Date expirationDateOrNull;
        String state = user.isAdmin() ? ADMIN_STR : (user.isPermanent() ? REGULAR_STR : ((expirationDateOrNull = user.getExpirationDate()) != null ? TEMPORARY_UNTIL_STR + dateTimeFormat.format(expirationDateOrNull) : "TEMPORARY until ???"));
        return String.valueOf(user.getUserCode()) + " [" + state + "]";
    }

    @Override
    public void logUploadFileStart(String filename, FileDTO fileOrNull, long startPosition) {
        if (this.trackingLog.isInfoEnabled()) {
            if (startPosition > 0L) {
                this.trackingLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("upload_file_resume %s [pos: %d]", this.getFileDescription(fileOrNull, filename), startPosition)));
            } else {
                this.trackingLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("upload_file_start %s", this.getFileDescription(fileOrNull, filename))));
            }
        }
    }

    @Override
    public void logUploadFileFinished(String filename, FileDTO fileOrNull, boolean success) {
        if (this.trackingLog.isInfoEnabled()) {
            this.trackingLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("upload_file_finished %s: %s", this.getFileDescription(fileOrNull, filename), UserActionLog.getSuccessString((boolean)success))));
        }
    }

    @Override
    public void logShareFiles(Collection<FileDTO> files, Collection<UserDTO> usersToShareWith, Collection<String> emailsOfUsersToShareWith, Collection<String> invalidEmailAddresses, boolean success) {
        if (this.trackingLog.isInfoEnabled()) {
            String invalidEmailDesc;
            String string = invalidEmailDesc = invalidEmailAddresses.size() > 0 ? " [invalid: " + this.getStringDescription(invalidEmailAddresses) + "]" : "";
            if (success) {
                this.trackingLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("share_files %s with %s: %s%s", this.getFileDescriptions(files), this.getUserDescription(usersToShareWith), UserActionLog.getSuccessString((boolean)success), invalidEmailDesc)));
            } else {
                this.trackingLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("share_files %s with %s: %s%s", this.getFileDescriptions(files), this.getStringDescription(emailsOfUsersToShareWith), UserActionLog.getSuccessString((boolean)success), invalidEmailDesc)));
            }
        }
    }

    @Override
    public void logShareFilesAuthorizationFailure(Collection<FileDTO> files, Collection<String> recipientsToShareWith) {
        if (this.trackingLog.isInfoEnabled()) {
            this.trackingLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("share_files %s with %s: FAILED [insufficient privileges]", this.getFileDescriptions(files), this.getStringDescription(recipientsToShareWith))));
        }
    }

    private <T> String getDescription(Iterable<T> objects, Descriptor<T> descriptor) {
        StringBuilder b = new StringBuilder();
        b.append('{');
        for (T object : objects) {
            b.append(descriptor.getDescription(object));
            b.append(',');
        }
        if (b.length() > 1) {
            b.setLength(b.length() - 1);
        }
        b.append('}');
        return b.toString();
    }

    private String getFileDescription(FileDTO fileOrNull, String filenameOrNull) {
        assert (fileOrNull != null || filenameOrNull != null);
        if (fileOrNull != null) {
            UserDTO registratorOrNull = fileOrNull.getOwner();
            if (registratorOrNull != null) {
                return "'" + registratorOrNull.getUserCode() + "::" + fileOrNull.getName() + "' (" + fileOrNull.getID() + ")";
            }
            return fileOrNull.getName();
        }
        return "'" + filenameOrNull + "'";
    }

    private String getFileDescriptions(Iterable<FileDTO> files) {
        return this.getDescription(files, new Descriptor<FileDTO>(){

            @Override
            public String getDescription(FileDTO file) {
                return UserActionLog.this.getFileDescription(file, null);
            }
        });
    }

    private String getUserDescription(Iterable<UserDTO> users) {
        return this.getDescription(users, new Descriptor<UserDTO>(){

            @Override
            public String getDescription(UserDTO user) {
                return user.getUserCode();
            }
        });
    }

    private String getStringDescription(Iterable<String> users) {
        return this.getDescription(users, new Descriptor<String>(){

            @Override
            public String getDescription(String str) {
                return str;
            }
        });
    }

    @Override
    public void logDeleteFile(FileDTO file, boolean success) {
        if (this.trackingLog.isInfoEnabled()) {
            this.trackingLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("delete_file %s: %s", this.getFileDescription(file, null), UserActionLog.getSuccessString((boolean)success))));
        }
    }

    @Override
    public void logExpireFile(FileDTO file, boolean success) {
        if (this.trackingLog.isInfoEnabled()) {
            this.trackingLog.info((Object)String.format("{SYSTEM} delete_file %s: %s", this.getFileDescription(file, null), UserActionLog.getSuccessString((boolean)success)));
        }
    }

    @Override
    public void logEditFile(long fileId, String newName, Date fileExpirationDateOrNull, boolean success) {
        if (this.trackingLog.isInfoEnabled()) {
            this.trackingLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("edit_file '%s' (%d) until %s: %s", newName, fileId, fileExpirationDateOrNull == null ? "UNKNOWN" : dateTimeFormat.format(fileExpirationDateOrNull), UserActionLog.getSuccessString((boolean)success))));
        }
    }

    @Override
    public void logDownloadFileStart(FileDTO file, long startPosition) {
        if (this.accessLog.isInfoEnabled()) {
            if (startPosition > 0L) {
                this.accessLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("download_file_resume %s [pos: %d]", this.getFileDescription(file, null), startPosition)));
            } else {
                this.accessLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("download_file_start %s", this.getFileDescription(file, null))));
            }
        }
    }

    @Override
    public void logDownloadFileFinished(FileDTO file, boolean success) {
        if (this.accessLog.isInfoEnabled()) {
            this.accessLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("download_file_finished %s: %s", this.getFileDescription(file, null), UserActionLog.getSuccessString((boolean)success))));
        }
    }

    @Override
    public void logDownloadFileFailedNotAuthorized(FileDTO file) {
        if (this.accessLog.isInfoEnabled()) {
            this.accessLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("download_file %s: NOT AUTHORIZED", this.getFileDescription(file, null))));
        }
    }

    @Override
    public void logDownloadFileFailedNotFound(FileDTO file) {
        if (this.accessLog.isInfoEnabled()) {
            this.accessLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("download_file %s: NOT FOUND", this.getFileDescription(file, null))));
        }
    }

    @Override
    public void logDeleteSharingLink(long fileId, String userCode, boolean success) {
        if (this.trackingLog.isInfoEnabled()) {
            this.trackingLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("delete_sharing_link between file id %d and user '%s': %s", fileId, userCode, UserActionLog.getSuccessString((boolean)success))));
        }
    }

    @Override
    public void logChangeUserCode(String before, String after, boolean success) {
        if (this.trackingLog.isInfoEnabled()) {
            this.trackingLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("change_user_code from '%s' to '%s': %s", before, after, UserActionLog.getSuccessString((boolean)success))));
        }
    }

    @Override
    public void logSwitchToExternalAuthentication(String userCode, boolean success) {
        if (this.accessLog.isInfoEnabled()) {
            this.accessLog.info((Object)(String.valueOf(this.getUserHostSessionDescription()) + String.format("switch_to_external_authentication user '%s': %s", userCode, UserActionLog.getSuccessString((boolean)success))));
        }
    }

    @Override
    public void logLogout(Session session, IActionLog.LogoutReason reason) {
        if (this.authenticationLog.isInfoEnabled()) {
            UserDTO userOrNull = session.getUser();
            String userName = userOrNull == null ? "UNKNOWN" : userOrNull.getUserCode();
            String id = session.getSessionID();
            String logoutMsg = String.format(USER_SESSION_RPC_TEMPLATE, userName, id, reason.getLogText());
            this.authenticationLog.info((Object)logoutMsg);
        }
    }

    private static interface Descriptor<T> {
        public String getDescription(T var1);
    }

    private static enum UserState {
        TEMPORARY,
        REGULAR,
        ADMIN;


        static UserState getState(UserDTO user) {
            if (user.isAdmin()) {
                return ADMIN;
            }
            if (user.isPermanent()) {
                return REGULAR;
            }
            return TEMPORARY;
        }
    }
}

