/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server;

import ch.systemsx.cisd.cifex.server.AbstractCIFEXService;
import ch.systemsx.cisd.cifex.server.business.IUserActionLog;
import ch.systemsx.cisd.cifex.server.business.UserHttpSessionHolder;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class UserHttpSessionListener
implements HttpSessionListener {
    private static final UserHttpSessionHolder getUserHttpSessionHolder(HttpSession session) throws ConfigurationFailureException {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)session.getServletContext());
        UserHttpSessionHolder sessionHolder = (UserHttpSessionHolder)ctx.getBean("user-session-holder");
        if (sessionHolder == null) {
            throw ConfigurationFailureException.fromTemplate((String)"No bean '%s' defined.", (Object[])new Object[]{"user-session-holder"});
        }
        return sessionHolder;
    }

    private static final IUserActionLog getUserBehaviorLog(HttpSession session) throws ConfigurationFailureException {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)session.getServletContext());
        try {
            IUserActionLog userBehaviorLog = (IUserActionLog)ctx.getBean("user-action-log-http");
            return userBehaviorLog;
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            throw ConfigurationFailureException.fromTemplate((String)"No bean '%s' defined.", (Object[])new Object[]{"user-action-log-http"});
        }
    }

    public final void sessionCreated(HttpSessionEvent sessionEvent) {
        HttpSession session = sessionEvent.getSession();
        if (session == null) {
            return;
        }
        UserHttpSessionListener.getUserHttpSessionHolder(session).addUserSession(session);
    }

    public final void sessionDestroyed(HttpSessionEvent sessionEvent) {
        HttpSession session = sessionEvent.getSession();
        if (session == null) {
            return;
        }
        UserHttpSessionListener.getUserHttpSessionHolder(session).removeUserSession(session);
        if (AbstractCIFEXService.tryGetRPCSession(session) == null) {
            UserHttpSessionListener.getUserBehaviorLog(session).logLogout(session);
        }
    }
}

