/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business;

import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.io.PropertyIOUtils;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.string.Template;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

abstract class AbstractEMailBuilder {
    private static final String EMAIL_PROPERTIES_FILE_PATH = "etc/email.properties";
    protected final UserDTO registrator;
    protected String comment;
    protected String url;
    private String fullName;
    private final IMailClient mailClient;
    private final String email;
    protected String password;
    protected Map<String, String> emailDict = new HashMap<String, String>();

    protected AbstractEMailBuilder(IMailClient mailClient, UserDTO registrator, String email) {
        assert (mailClient != null) : "Unspecified mail client.";
        assert (registrator != null) : "Unspecified registrator.";
        assert (StringUtils.isNotEmpty((String)email)) : "Empty email.";
        this.mailClient = mailClient;
        this.registrator = registrator;
        this.email = email;
    }

    private static final String encodeURLParam(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return value;
        }
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void sendEMail() {
        assert (this.url != null) : "Missing URL.";
        this.emailDict.clear();
        this.populateDict();
        EMailAddress from = new EMailAddress(this.registrator.getEmail(), this.getShortRegistratorDescription());
        this.mailClient.sendEmailMessage("[CIFEX] " + this.createSubject(), this.createContent(), from, from, new EMailAddress[]{new EMailAddress(this.email)});
    }

    protected void populateDict() {
        Properties emailProps = PropertyIOUtils.loadProperties((String)EMAIL_PROPERTIES_FILE_PATH);
        SimpleDateFormat dateFormat = new SimpleDateFormat(emailProps.getProperty("date-format"));
        this.emailDict.put("user-id", this.getUserCode());
        this.emailDict.put("login-link", this.createURL("user", this.getUserCode()));
        if (this.password != null) {
            this.emailDict.put("password", this.password);
        }
        if (StringUtils.isBlank((String)this.fullName)) {
            this.emailDict.put("user-name", this.getUserCode());
        } else {
            this.emailDict.put("user-name", this.fullName);
        }
        this.emailDict.put("uploader-name", this.getShortRegistratorDescription());
        this.emailDict.put("uploader-email", this.registrator.getEmail());
        if (this.comment != null) {
            this.emailDict.put("comment", this.comment);
        }
        if (this.tryGetExpirationDate() != null) {
            this.emailDict.put("expiration-date", dateFormat.format(this.tryGetExpirationDate()));
        }
        this.addToDict(emailProps, dateFormat);
        this.addPropertiesToDict(emailProps);
        if (!this.emailDict.containsKey("password")) {
            this.emailDict.put("password", "-");
        }
        if (!this.emailDict.containsKey("comment")) {
            this.emailDict.put("comment", "-");
        }
    }

    private void addPropertiesToDict(Properties emailProps) {
        Enumeration<?> enumeration = emailProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (key.endsWith("-EMPTY")) continue;
            String value = emailProps.getProperty(key).replace("<br>", "\n");
            Template template = new Template(value);
            for (String placeholder : template.getPlaceholderNames()) {
                if (!this.emailDict.containsKey(placeholder)) continue;
                template.bind(placeholder, this.emailDict.get(placeholder));
            }
            if (template.allVariablesAreBound()) {
                this.emailDict.put(key, template.createText());
                continue;
            }
            this.emailDict.put(key, emailProps.getProperty(String.valueOf(key) + "-EMPTY", ""));
        }
    }

    protected final String getShortRegistratorDescription() {
        String registratorFullName = this.registrator.getUserFullName();
        return StringUtils.isBlank((String)registratorFullName) ? this.registrator.getUserCode() : registratorFullName;
    }

    protected final String getLongRegistratorDescription() {
        return String.valueOf(this.getShortRegistratorDescription()) + " <" + this.registrator.getEmail() + ">";
    }

    protected final StringBuilder addURL(StringBuilder builder, Object ... paramValues) {
        assert (paramValues.length % 2 == 0);
        builder.append(this.url);
        if (!this.url.endsWith("/")) {
            builder.append('/');
        }
        boolean firstParam = true;
        int i = 0;
        while (i < paramValues.length / 2) {
            if (firstParam) {
                builder.append("?");
            } else {
                builder.append("&");
            }
            builder.append(paramValues[2 * i].toString()).append("=").append(AbstractEMailBuilder.encodeURLParam(paramValues[2 * i + 1].toString()));
            firstParam = false;
            ++i;
        }
        return builder;
    }

    protected final String createURL(Object ... paramValues) {
        return this.addURL(new StringBuilder(), paramValues).toString();
    }

    protected final String createContent(String templateFilename) {
        Template template = new Template(FileUtilities.loadExactToString((File)new File(templateFilename)));
        for (String placeholder : template.getPlaceholderNames()) {
            if (this.emailDict.containsKey(placeholder)) {
                template.bind(placeholder, this.emailDict.get(placeholder));
                continue;
            }
            template.bind(placeholder, "?{" + placeholder + "}");
        }
        return template.createText();
    }

    protected void addToDict(Properties emailProps, DateFormat dateFormat) {
    }

    protected abstract String createSubject();

    protected abstract String createContent();

    protected abstract String getUserCode();

    protected abstract Date tryGetExpirationDate();
}

