/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.cifex.BuildAndEnvironmentInfo;
import ch.systemsx.cisd.cifex.server.business.BusinessContext;
import ch.systemsx.cisd.cifex.server.business.FileManager;
import ch.systemsx.cisd.cifex.server.business.IBusinessContext;
import ch.systemsx.cisd.cifex.server.business.IDomainModel;
import ch.systemsx.cisd.cifex.server.business.IFileManager;
import ch.systemsx.cisd.cifex.server.business.ITriggerManager;
import ch.systemsx.cisd.cifex.server.business.IUserActionLog;
import ch.systemsx.cisd.cifex.server.business.IUserManager;
import ch.systemsx.cisd.cifex.server.business.TriggerManager;
import ch.systemsx.cisd.cifex.server.business.UserHttpSessionHolder;
import ch.systemsx.cisd.cifex.server.business.UserManager;
import ch.systemsx.cisd.cifex.server.business.bo.BusinessObjectFactory;
import ch.systemsx.cisd.cifex.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.cifex.server.business.dataaccess.IDAOFactory;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.io.PropertyIOUtils;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInvocationHandler;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.common.security.PasswordGenerator;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.config.BeanPostProcessor;

public final class DomainModel
implements IDomainModel {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DomainModel.class);
    private IUserManager userManager;
    private IFileManager fileManager;
    private ITriggerManager triggerManager;
    private final IDAOFactory daoFactory;
    private final BeanPostProcessor processor;
    private final BusinessContext businessContext;
    private final BusinessObjectFactory boFactory;
    private final IAuthenticationService externalAuthenticationService;
    public static final String SERVICE_PROPERTIES_FILE = "etc/service.properties";

    public DomainModel(IDAOFactory daoFactory, IUserActionLog userActionLogHttp, IUserActionLog userActionLogRpc, BeanPostProcessor processor, UserHttpSessionHolder userSessionHolder, String overrideURL, IAuthenticationService externalAuthenticationService) {
        assert (daoFactory != null) : "Undefined DAO Factory";
        assert (userSessionHolder != null) : "Undefined user session holder";
        this.daoFactory = daoFactory;
        this.processor = processor;
        this.externalAuthenticationService = externalAuthenticationService;
        this.businessContext = new BusinessContext();
        try {
            Properties serviceProperties = PropertyIOUtils.loadProperties((String)SERVICE_PROPERTIES_FILE);
            if (serviceProperties.isEmpty()) {
                throw new ConfigurationFailureException("Empty service.properties for mail client.");
            }
            MailClient newMailClient = new MailClient(serviceProperties);
            this.businessContext.setMailClient((IMailClient)newMailClient);
        }
        catch (Exception ex) {
            operationLog.error((Object)"Exception loading service.properties for mail client.", (Throwable)ex);
        }
        this.businessContext.setPasswordGenerator(new PasswordGenerator());
        this.businessContext.setUserHttpSessionHolder(userSessionHolder);
        this.businessContext.setUserActionLogHttp(userActionLogHttp);
        this.businessContext.setUserActionLogRpc(userActionLogRpc);
        this.businessContext.setOverrideURL(overrideURL);
        this.businessContext.setSystemVersion(BuildAndEnvironmentInfo.INSTANCE.getFullVersion());
        this.boFactory = new BusinessObjectFactory(daoFactory, this.businessContext);
    }

    public final void setFileStorePath(String fileStorePath) {
        this.businessContext.setFileStore(new File(fileStorePath));
        File fileStore = this.businessContext.getFileStore();
        if (fileStore.exists() && !fileStore.isDirectory()) {
            throw new EnvironmentFailureException("File store '" + fileStore.getAbsolutePath() + "' already exists but is not a directory.");
        }
        if (!fileStore.exists()) {
            boolean successful = fileStore.mkdirs();
            if (!successful) {
                throw new EnvironmentFailureException("Couldn't create file store '" + fileStore.getAbsolutePath() + "' for some unknown reason.");
            }
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)String.format("File store '%s' has been set and is ready to accept files.", fileStore.getAbsolutePath()));
            }
        }
    }

    public void setSessionTimeoutMin(int sessionTimeoutMin) {
        this.businessContext.setSessionTimeoutMin(sessionTimeoutMin);
    }

    public final void setFileRetention(int fileRetention) {
        this.businessContext.setFileRetention(fileRetention);
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("File retention set to %d days.", fileRetention));
        }
    }

    public final void setUserRetention(int userRetention) {
        this.businessContext.setUserRetention(userRetention);
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("User retention set to %d days.", userRetention));
        }
    }

    public final void setMaxFileRetention(int maxFileRetention) {
        this.businessContext.setMaxFileRetention(maxFileRetention);
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Maximum file retention set to %d days.", maxFileRetention));
        }
    }

    public final void setMaxUserRetention(int maxUserRetention) {
        this.businessContext.setMaxUserRetention(maxUserRetention);
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Maximum user retention set to %d days.", maxUserRetention));
        }
    }

    public void setMaxFileCountPerQuotaGroup(Integer maxFileCountPerQuotaGroup) {
        this.businessContext.setMaxFileCountPerQuotaGroup(maxFileCountPerQuotaGroup);
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Quota for number of files set to %s.", maxFileCountPerQuotaGroup == null ? "'no quota'" : maxFileCountPerQuotaGroup));
        }
    }

    public void setMaxFileSizePerQuotaGroupInMB(Long maxFileSizePerQuotaGroupInMB) {
        this.businessContext.setMaxFileSizePerQuotaGroupInMB(maxFileSizePerQuotaGroupInMB);
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Quota for sum of size of files set to %s MB.", maxFileSizePerQuotaGroupInMB == null ? "'no quota'" : maxFileSizePerQuotaGroupInMB));
        }
    }

    public void setNewExternallyAuthenticatedUserStartActive(boolean newExternallyAuthenticatedUserStartActive) {
        this.businessContext.setNewExternallyAuthenticatedUserStartActive(newExternallyAuthenticatedUserStartActive);
    }

    public void setTriggerPermits(int triggerPermits) {
        this.businessContext.setTriggerPermits(triggerPermits);
    }

    public void setAllowedIPsForSetSessionUser(String allowedIPs) {
        this.businessContext.setAllowedIPsForSetSessionUser(allowedIPs);
    }

    private final <T> T createLoggingProxy(T manager) {
        Object proxy = this.processor.postProcessAfterInitialization(manager, "proxy of " + manager.getClass().getName());
        Class<?> clazz = this.getClass();
        LogInvocationHandler invocationHandler = new LogInvocationHandler(proxy, manager.getClass().getSimpleName(), Level.DEBUG, clazz);
        Class<?>[] interfaces = manager.getClass().getInterfaces();
        return this.cast(Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, (InvocationHandler)invocationHandler));
    }

    private <T> T cast(Object proxy) {
        return (T)proxy;
    }

    @Override
    public final IUserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = this.createLoggingProxy(new UserManager(this.daoFactory, (IBusinessObjectFactory)this.boFactory, (IBusinessContext)this.businessContext, this.externalAuthenticationService));
        }
        return this.userManager;
    }

    @Override
    public final IFileManager getFileManager() {
        if (this.fileManager == null) {
            this.fileManager = this.createLoggingProxy(new FileManager(this.daoFactory, this.boFactory, this.getUserManager(), this.businessContext, this.getTriggerManager()));
        }
        return this.fileManager;
    }

    public ITriggerManager getTriggerManager() {
        if (this.triggerManager == null) {
            this.triggerManager = this.createLoggingProxy(new TriggerManager(this.businessContext));
        }
        return this.triggerManager;
    }

    @Override
    public final IMailClient getMailClient() {
        return this.businessContext.getMailClient();
    }

    @Override
    public final IBusinessContext getBusinessContext() {
        return this.businessContext;
    }

    @Override
    public final PasswordGenerator getPasswordGenerator() {
        return this.businessContext.getPasswordGenerator();
    }
}

