/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.cifex.rpc.CRCCheckumMismatchException;
import ch.systemsx.cisd.cifex.rpc.FilePreregistrationDTO;
import ch.systemsx.cisd.cifex.rpc.io.CopyUtils;
import ch.systemsx.cisd.cifex.rpc.io.ISimpleChecksummingProgressListener;
import ch.systemsx.cisd.cifex.rpc.io.ResumingAndChecksummingOutputStream;
import ch.systemsx.cisd.cifex.server.business.AbstractManager;
import ch.systemsx.cisd.cifex.server.business.EMailBuilderForUploadedFiles;
import ch.systemsx.cisd.cifex.server.business.FileInformation;
import ch.systemsx.cisd.cifex.server.business.IBusinessContext;
import ch.systemsx.cisd.cifex.server.business.IFileManager;
import ch.systemsx.cisd.cifex.server.business.ITriggerManager;
import ch.systemsx.cisd.cifex.server.business.IUserActionLog;
import ch.systemsx.cisd.cifex.server.business.IUserManager;
import ch.systemsx.cisd.cifex.server.business.PreCreatedFileDTO;
import ch.systemsx.cisd.cifex.server.business.UserUtils;
import ch.systemsx.cisd.cifex.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.cifex.server.business.bo.IUserBO;
import ch.systemsx.cisd.cifex.server.business.dataaccess.IDAOFactory;
import ch.systemsx.cisd.cifex.server.business.dataaccess.IFileDAO;
import ch.systemsx.cisd.cifex.server.business.dto.BasicFileDTO;
import ch.systemsx.cisd.cifex.server.business.dto.FileContent;
import ch.systemsx.cisd.cifex.server.business.dto.FileDTO;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.cifex.server.common.Password;
import ch.systemsx.cisd.cifex.server.util.ExpirationUtilities;
import ch.systemsx.cisd.cifex.server.util.FilenameUtilities;
import ch.systemsx.cisd.cifex.shared.basic.Constants;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.collection.TableMapNonUniqueKey;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.reflection.BeanUtils;
import ch.systemsx.cisd.common.string.StringUtilities;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.transaction.annotation.Transactional;

final class FileManager
extends AbstractManager
implements IFileManager {
    private static final String FILE_CHECKSUM_TEMPLATE = "File %s has crc32 checksum %x.";
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final int PROGRESS_UPDATE_CHUNK_SIZE = 131072;
    private static final int PROGRESS_UPDATE_MIN_INTERVAL_MILLIS = 2000;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, FileManager.class);
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, FileManager.class);
    private final ITriggerManager triggerManager;
    private final IUserManager userManager;

    FileManager(IDAOFactory daoFactory, IBusinessObjectFactory boFactory, IUserManager userManager, IBusinessContext businessContext, ITriggerManager triggerManager) {
        this(daoFactory, boFactory, userManager, businessContext, triggerManager, (ITimeProvider)SystemTimeProvider.SYSTEM_TIME_PROVIDER);
    }

    FileManager(IDAOFactory daoFactory, IBusinessObjectFactory boFactory, IUserManager userManager, IBusinessContext businessContext, ITriggerManager triggerManager, ITimeProvider timeProvider) {
        super(daoFactory, boFactory, businessContext, timeProvider);
        this.userManager = userManager;
        this.triggerManager = triggerManager;
    }

    private static final boolean containsUser(UserDTO userDTO, List<UserDTO> sharingUsers) {
        for (UserDTO user : sharingUsers) {
            if (!user.getID().equals(userDTO.getID())) continue;
            return true;
        }
        return false;
    }

    private final boolean deleteFromFileSystem(String path) {
        File file = new File(this.businessContext.getFileStore(), path);
        return this.deleteFromFileSystem(file);
    }

    private final boolean deleteFromFileSystem(File file) {
        if (file.exists()) {
            if (file.delete()) {
                return true;
            }
            notificationLog.error((Object)("File [" + file.getAbsolutePath() + "] can not be deleted."));
            return false;
        }
        operationLog.warn((Object)("File [" + file.getAbsolutePath() + "] requested to be deleted, but doesn't exist."));
        return true;
    }

    @Override
    public final List<FileDTO> listDownloadFiles(long userId) {
        return this.daoFactory.getFileDAO().listDownloadFiles(userId);
    }

    @Override
    @Transactional
    public final List<FileDTO> listOwnedFiles(long userId) {
        List<FileDTO> list = this.daoFactory.getFileDAO().listDirectlyAndIndirectlyOwnedFiles(userId);
        HashMap<Long, String> idToCodeMap = new HashMap<Long, String>();
        for (FileDTO file : list) {
            for (UserDTO user : file.getSharingUsers()) {
                user.setUserCode(this.getUserCodeForId(idToCodeMap, user.getID()));
            }
        }
        return list;
    }

    @Override
    @Transactional
    public final void deleteExpiredFiles(IUserActionLog logOrNull) {
        List<FileDTO> expiredFiles = this.daoFactory.getFileDAO().getExpiredFiles();
        if (operationLog.isInfoEnabled() && expiredFiles.size() > 0) {
            operationLog.info((Object)("Found " + expiredFiles.size() + " expired files."));
        }
        RuntimeException firstExceptionOrNull = null;
        for (FileDTO file : expiredFiles) {
            try {
                boolean success = this.daoFactory.getFileDAO().deleteFile(file.getID());
                if (success) {
                    if (operationLog.isInfoEnabled()) {
                        operationLog.info((Object)("Expired file '" + file.getPath() + "' removed from database."));
                    }
                } else {
                    operationLog.warn((Object)("Expired file '" + file.getPath() + "' could not be found in the database."));
                }
                success &= this.deleteFromFileSystem(file.getPath());
                if (logOrNull == null) continue;
                logOrNull.logExpireFile(file, success);
            }
            catch (RuntimeException ex) {
                if (logOrNull != null) {
                    logOrNull.logExpireFile(file, false);
                }
                operationLog.error((Object)("Error deleting file '" + file.getPath() + "'."), (Throwable)ex);
                if (firstExceptionOrNull != null) continue;
                firstExceptionOrNull = ex;
            }
        }
        if (firstExceptionOrNull != null) {
            throw firstExceptionOrNull;
        }
    }

    @Override
    public final FileInformation getFileInformation(long fileId) {
        return this.getFileInformation(fileId, true);
    }

    @Override
    public final FileInformation getFileInformationFilestoreUnimportant(long fileId) {
        return this.getFileInformation(fileId, false);
    }

    private final FileInformation getFileInformation(long fileId, boolean fileStoreImportant) {
        FileDTO fileDTOOrNull = this.daoFactory.getFileDAO().tryGetFile(fileId);
        File realFile = null;
        if (fileDTOOrNull == null) {
            return new FileInformation(fileId, Constants.getErrorMessageForFileNotFound(fileId));
        }
        if (fileStoreImportant && !(realFile = new File(this.businessContext.getFileStore(), fileDTOOrNull.getPath())).exists()) {
            if (!this.businessContext.getFileStore().canRead()) {
                notificationLog.error((Object)("CIFEX file store is not readable any more (" + this.businessContext.getFileStore().getAbsolutePath() + ")"));
                return new FileInformation(fileId, String.format("Unexpected: File '%s' [id=%d] can not be read (CIFEX file store unreadable).", realFile.getPath(), fileId));
            }
            return new FileInformation(fileId, String.format("Unexpected: File '%s' [id=%d] is missing in CIFEX file store.", realFile.getPath(), fileId));
        }
        return new FileInformation(fileId, fileDTOOrNull, realFile);
    }

    @Override
    public final FileContent getFileContent(FileDTO fileDTO) {
        File realFile = this.getRealFile(fileDTO);
        try {
            FileContent content = new FileContent((BasicFileDTO)BeanUtils.createBean(BasicFileDTO.class, (Object)fileDTO), new FileInputStream(realFile));
            return content;
        }
        catch (FileNotFoundException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    @Override
    public File getRealFile(FileDTO fileDTO) {
        File realFile = new File(this.businessContext.getFileStore(), fileDTO.getPath());
        if (!realFile.exists()) {
            throw new IllegalStateException(String.format("File '%s' does not exist on the file system.", realFile.getAbsolutePath()));
        }
        return realFile;
    }

    @Override
    public final boolean isAllowedAccess(UserDTO userDTO, FileDTO fileDTO) {
        if (this.isControlling(userDTO, fileDTO)) {
            return true;
        }
        List<UserDTO> sharingUsers = fileDTO.getSharingUsers();
        return FileManager.containsUser(userDTO, sharingUsers);
    }

    @Override
    public boolean isControlling(UserDTO userDTO, FileDTO fileDTO) {
        if (userDTO.isAdmin()) {
            return true;
        }
        if (userDTO.getID().equals(fileDTO.getOwnerId())) {
            return true;
        }
        UserDTO owner = fileDTO.getOwner();
        return owner != null && owner.getRegistrator() != null && userDTO.getID().equals(owner.getRegistrator().getID());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Transactional
    public final FileDTO saveFile(UserDTO user, String fileName, String comment, String contentTypeOrNull, InputStream inputStream) {
        assert (user != null) : "Unspecified user.";
        assert (user.getEmail() != null) : "Unspecified email of user " + user;
        assert (StringUtils.isNotBlank((String)fileName)) : "Unspecified file name.";
        assert (inputStream != null) : "Unspecified input stream.";
        String contentType = contentTypeOrNull != null ? contentTypeOrNull : DEFAULT_CONTENT_TYPE;
        File file = this.createFile(user, fileName);
        try {
            ResumingAndChecksummingOutputStream outputStream;
            block11: {
                FileDTO fileDTO;
                outputStream = null;
                outputStream = new ResumingAndChecksummingOutputStream(file, 1024L, null);
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
                outputStream.close();
                long byteCount = outputStream.getByteCount();
                int crc32Value = outputStream.getCrc32Value();
                if (byteCount <= 0L) break block11;
                FileDTO fileDTO2 = fileDTO = this.registerFile(user, fileName, comment, contentType, file, byteCount, crc32Value);
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
                return fileDTO2;
            }
            try {
                this.deleteFromFileSystem(file);
                this.throwExceptionOnFileDoesNotExist(fileName);
            }
            catch (IOException ex) {
                try {
                    operationLog.error((Object)("Error saving file " + fileName + ": " + ex.getMessage()));
                    throw EnvironmentFailureException.fromTemplate((Throwable)ex, (String)"Error saving file '%s' (Is it a file?).", (Object[])new Object[]{fileName});
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)inputStream);
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
            return null;
        }
        catch (RuntimeException e) {
            this.deleteFromFileSystem(file);
            throw e;
        }
    }

    @Override
    public final FileDTO saveFile(final UserDTO user, String fileName, String comment, String contentTypeOrNull, final long fileSize, InputStream inputStream) {
        FileDTO fileDTO;
        assert (user != null) : "Unspecified user.";
        assert (user.getEmail() != null) : "Unspecified email of user " + user;
        assert (StringUtils.isNotBlank((String)fileName)) : "Unspecified file name.";
        assert (inputStream != null) : "Unspecified input stream.";
        PreCreatedFileDTO fileContainer = this.createFile(user, fileName, fileSize, comment);
        File file = fileContainer.getFile();
        final FileDTO fileDTO2 = fileContainer.getFileDTO();
        ResumingAndChecksummingOutputStream outputStream = null;
        try {
            outputStream = new ResumingAndChecksummingOutputStream(file, 131072L, new ISimpleChecksummingProgressListener(){
                long lastUpdated = System.currentTimeMillis();

                @Override
                public void update(long bytesWritten, int crc32Value) {
                    long now = System.currentTimeMillis();
                    if (now - this.lastUpdated > 2000L && bytesWritten != fileSize) {
                        fileDTO2.setSize(bytesWritten);
                        fileDTO2.setCrc32Value(crc32Value);
                        FileManager.this.updateUploadProgress(fileDTO2, user);
                        this.lastUpdated = now;
                    }
                }

                @Override
                public void exceptionThrown(IOException e) {
                }
            });
            int remoteCrc32Value = CopyUtils.copyAndReturnChecksum(inputStream, outputStream, fileSize, 0L);
            outputStream.close();
            long byteCount = outputStream.getByteCount();
            fileDTO2.setSize(byteCount);
            int crc32Value = outputStream.getCrc32Value();
            fileDTO2.setCrc32Value(crc32Value);
            if (remoteCrc32Value != crc32Value) {
                this.deleteFromFileSystem(file);
                this.daoFactory.getFileDAO().deleteFile(fileDTO2.getID());
                throw new CRCCheckumMismatchException(fileName, crc32Value, remoteCrc32Value);
            }
            if (byteCount != fileSize) {
                this.deleteFromFileSystem(file);
                this.daoFactory.getFileDAO().deleteFile(fileDTO2.getID());
                throw EnvironmentFailureException.fromTemplate((String)"Wrong file size of file %s [expected: %d, found: %d]", (Object[])new Object[]{fileName, fileSize, byteCount});
            }
            operationLog.info((Object)String.format(FILE_CHECKSUM_TEMPLATE, fileName, crc32Value));
            this.updateUploadProgress(fileDTO2, user);
            fileDTO = fileDTO2;
        }
        catch (IOException ex) {
            try {
                throw EnvironmentFailureException.fromTemplate((Throwable)ex, (String)"Error saving file '%s'.", (Object[])new Object[]{fileName});
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
        return fileDTO;
    }

    @Override
    public final void resumeSaveFile(final UserDTO user, final FileDTO fileDTO, File file, String comment, long startPos, InputStream inputStream) throws IllegalArgumentException {
        assert (user != null) : "Unspecified user.";
        assert (user.getEmail() != null) : "Unspecified email of user " + user;
        assert (fileDTO != null) : "Unspecified file link.";
        assert (file != null) : "Unspecified file.";
        assert (inputStream != null) : "Unspecified input stream.";
        String fileName = fileDTO.getName();
        final long fileSize = fileDTO.getCompleteSize();
        if (startPos > fileDTO.getSize()) {
            throw new IllegalArgumentException(String.format("File id=%d: requested start position %d for resume is larger than transferred size %d.", fileDTO.getID(), startPos, fileDTO.getSize()));
        }
        if (StringUtils.isNotBlank((String)comment) && !ObjectUtils.equals((Object)comment, (Object)fileDTO.getComment())) {
            this.daoFactory.getFileDAO().updateFileUserEdit(fileDTO.getID(), fileName, comment, this.calculateNewExpirationDate(fileDTO, user));
        }
        ResumingAndChecksummingOutputStream outputStream = null;
        try {
            try {
                int partialCrc32Value = fileDTO.getCrc32Value() != null ? fileDTO.getCrc32Value() : 0;
                outputStream = new ResumingAndChecksummingOutputStream(file, 131072L, new ISimpleChecksummingProgressListener(){
                    long lastUpdated = System.currentTimeMillis();

                    @Override
                    public void update(long bytesWritten, int crc32Value) {
                        long now = System.currentTimeMillis();
                        if (now - this.lastUpdated > 2000L && bytesWritten != fileSize) {
                            fileDTO.setSize(bytesWritten);
                            fileDTO.setCrc32Value(crc32Value);
                            FileManager.this.updateUploadProgress(fileDTO, user);
                            this.lastUpdated = now;
                        }
                    }

                    @Override
                    public void exceptionThrown(IOException e) {
                    }
                }, startPos, partialCrc32Value);
                int remoteCrc32Value = CopyUtils.copyAndReturnChecksum(inputStream, outputStream, fileSize, startPos);
                outputStream.close();
                long byteCount = outputStream.getByteCount();
                fileDTO.setSize(byteCount);
                int crc32Value = outputStream.getCrc32Value();
                fileDTO.setCrc32Value(crc32Value);
                if (remoteCrc32Value != crc32Value) {
                    this.deleteFromFileSystem(file);
                    this.daoFactory.getFileDAO().deleteFile(fileDTO.getID());
                    throw new CRCCheckumMismatchException(fileName, crc32Value, remoteCrc32Value);
                }
                if (byteCount != fileSize) {
                    this.deleteFromFileSystem(file);
                    this.daoFactory.getFileDAO().deleteFile(fileDTO.getID());
                    throw EnvironmentFailureException.fromTemplate((String)"Wrong file size of file %s [expected: %d, found: %d]", (Object[])new Object[]{fileName, fileSize, byteCount});
                }
                operationLog.info((Object)String.format(FILE_CHECKSUM_TEMPLATE, fileName, crc32Value));
                this.updateUploadProgress(fileDTO, user);
            }
            catch (IOException ex) {
                throw EnvironmentFailureException.fromTemplate((Throwable)ex, (String)"Error saving file '%s'.", (Object[])new Object[]{fileName});
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    @Override
    @Transactional
    public List<String> registerFileLinkAndInformRecipients(UserDTO user, String fileName, String comment, String contentTypeOrNull, File file, int crc32Value, String[] recipients, String url, IUserActionLog logOrNull) {
        String contentType = contentTypeOrNull != null ? contentTypeOrNull : DEFAULT_CONTENT_TYPE;
        FileDTO fileDTO = this.registerFile(user, fileName, comment, contentType, file, file.length(), crc32Value);
        return this.shareFilesWith(url, user, Arrays.asList(recipients), Collections.singleton(fileDTO), comment, logOrNull);
    }

    private FileDTO registerFile(UserDTO user, String fileName, String comment, String contentType, File file, long byteCount, int crc32Value) {
        operationLog.info((Object)String.format(FILE_CHECKSUM_TEMPLATE, fileName, crc32Value));
        FileDTO fileDTO = new FileDTO(user);
        fileDTO.setName(FilenameUtilities.ensureMaximumSize(fileName, 250));
        fileDTO.setContentType(contentType);
        fileDTO.setPath(FileUtilities.getRelativeFilePath((File)this.businessContext.getFileStore(), (File)file));
        fileDTO.setComment(comment);
        fileDTO.setExpirationDate(this.calculateNewExpirationDate(fileDTO, user));
        fileDTO.setSize(byteCount);
        fileDTO.setCompleteSize(byteCount);
        fileDTO.setCrc32Value(crc32Value);
        this.daoFactory.getFileDAO().createFile(fileDTO);
        return fileDTO;
    }

    @Override
    public PreCreatedFileDTO createFile(UserDTO user, FilePreregistrationDTO fileInfoDTO, String comment) {
        String fileName = FilenameUtils.getName((String)fileInfoDTO.getFilePathOnClient());
        return this.createFile(user, fileName, fileInfoDTO.getFileSize(), comment);
    }

    private PreCreatedFileDTO createFile(UserDTO user, String fileName, long fileSize, String comment) {
        String contentType = FilenameUtilities.getMimeType(fileName);
        File fileInStore = this.createFile(user, fileName);
        FileDTO fileInDB = this.preRegisterFileLink(user, fileName, fileSize, comment, contentType, fileInStore);
        return new PreCreatedFileDTO(fileInStore, fileInDB);
    }

    @Override
    public File createFile(UserDTO user, String fileName) {
        File folder = this.createFolderFor(user);
        File fileInStore = FileUtilities.createNextNumberedFile((File)new File(folder, fileName), null);
        return fileInStore;
    }

    private File createFolderFor(UserDTO user) {
        File folder = new File(this.businessContext.getFileStore(), user.getUserCode());
        if (folder.exists()) {
            if (!folder.isDirectory()) {
                throw new EnvironmentFailureException("Folder '" + folder.getAbsolutePath() + "' exists but is not a directory.");
            }
        } else {
            boolean successful = folder.mkdirs();
            if (!successful) {
                if (!this.businessContext.getFileStore().canWrite()) {
                    notificationLog.error((Object)("CIFEX file store is not writable any more (" + this.businessContext.getFileStore().getAbsolutePath() + ")"));
                    throw new EnvironmentFailureException("Folder '" + folder.getAbsolutePath() + "' can not be created as CIFEX file store is not writable.");
                }
                throw new EnvironmentFailureException("Folder '" + folder.getAbsolutePath() + "' can not be created for some unknown reason.");
            }
        }
        return folder;
    }

    private FileDTO preRegisterFileLink(UserDTO user, String fileName, long fileSize, String comment, String contentType, File file) {
        FileDTO fileDTO = new FileDTO(user);
        fileDTO.setName(FilenameUtilities.ensureMaximumSize(fileName, 250));
        fileDTO.setContentType(contentType);
        fileDTO.setPath(FileUtilities.getRelativeFilePath((File)this.businessContext.getFileStore(), (File)file));
        fileDTO.setComment(comment);
        fileDTO.setExpirationDate(this.calculateNewExpirationDate(fileDTO, user));
        fileDTO.setSize(0L);
        fileDTO.setCompleteSize(fileSize);
        this.daoFactory.getFileDAO().createFile(fileDTO);
        return fileDTO;
    }

    @Override
    public void throwExceptionOnFileDoesNotExist(String fileName) {
        String msg = String.format("File '%s' does not seem to exist. It has not been saved.", fileName);
        operationLog.warn((Object)msg);
        throw new UserFailureException(msg);
    }

    @Override
    public void updateUploadProgress(FileDTO fileDTO, UserDTO requestUser) {
        this.daoFactory.getFileDAO().updateFileUploadProgress(fileDTO.getID(), fileDTO.getSize(), fileDTO.getCrc32Value(), this.calculateNewExpirationDate(fileDTO, requestUser));
    }

    @Override
    public FileDTO tryGetUploadResumeCandidate(long userId, String fileName, long completeSize) {
        return this.daoFactory.getFileDAO().tryGetResumeCandidate(userId, fileName, completeSize);
    }

    @Override
    @Transactional
    public final List<String> shareFilesWith(String url, UserDTO requestUser, Collection<String> userIdentifiers, Collection<FileDTO> files, String comment, IUserActionLog logOrNull) throws UserFailureException {
        if (userIdentifiers.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<UserDTO> users = new LinkedHashSet<UserDTO>();
        ArrayList<String> invalidIdentifiers = new ArrayList<String>();
        boolean success = false;
        try {
            ArrayList<String> userCodes = new ArrayList<String>();
            ArrayList<String> emailAddresses = new ArrayList<String>();
            this.extractUserCodesAndEmailAddresses(userIdentifiers, userCodes, emailAddresses, invalidIdentifiers);
            Collection<UserDTO> relevantUsers = this.userManager.getUsers(userCodes, emailAddresses, logOrNull);
            TableMapNonUniqueKey<String, UserDTO> existingUsers = UserUtils.createTableMapOfExistingUsersWithEmailAsKey(relevantUsers);
            TableMap<String, UserDTO> existingUniqueUsers = UserUtils.createTableMapOfExistingUsersWithUserCodeAsKey(relevantUsers);
            for (String userCode : userCodes) {
                this.handleUserCode(userCode, requestUser, existingUsers, existingUniqueUsers, invalidIdentifiers, users);
            }
            for (String emailAddress : emailAddresses) {
                this.handleEmailAddress(emailAddress, requestUser, existingUsers, existingUniqueUsers, invalidIdentifiers, users);
            }
            RuntimeException exception = this.createLinksAndCallTriggersAndSendEmails(users, files, url, comment, requestUser);
            boolean bl = success = exception == null;
            if (exception != null) {
                throw exception;
            }
            ArrayList<String> arrayList = invalidIdentifiers;
            return arrayList;
        }
        finally {
            if (logOrNull != null) {
                logOrNull.logShareFiles(files, users, userIdentifiers, invalidIdentifiers, success);
            }
        }
    }

    private void extractUserCodesAndEmailAddresses(Collection<String> identifiers, List<String> userCodes, List<String> validEmailAddresses, List<String> invalidIdentifiers) {
        for (String identifier : identifiers) {
            String trimmedIdentifier = identifier.trim();
            if (UserUtils.isUserCodeWithIdPrefix(trimmedIdentifier)) {
                userCodes.add(UserUtils.extractUserCode(trimmedIdentifier));
                continue;
            }
            if (UserUtils.isEmail(trimmedIdentifier)) {
                validEmailAddresses.add(trimmedIdentifier.toLowerCase());
                continue;
            }
            invalidIdentifiers.add(trimmedIdentifier);
        }
    }

    private void handleUserCode(String userCode, UserDTO requestUser, TableMapNonUniqueKey<String, UserDTO> existingUsers, TableMap<String, UserDTO> existingUniqueUsers, List<String> invalidIdentifiers, Set<UserDTO> users) {
        UserDTO userOrNull = (UserDTO)existingUniqueUsers.tryGet((Object)userCode);
        if (userOrNull != null && StringUtils.isNotBlank((String)userOrNull.getEmail())) {
            users.add(userOrNull);
        } else {
            invalidIdentifiers.add(userCode);
        }
    }

    private void handleEmailAddress(String emailAddress, UserDTO requestUser, TableMapNonUniqueKey<String, UserDTO> existingUsers, TableMap<String, UserDTO> existingUniqueUsers, List<String> invalidIdentifiers, Set<UserDTO> users) {
        String lowerCaseIdentifier = emailAddress.toLowerCase();
        Set<UserDTO> existingUsersOrNull = FileManager.removeUnsuitableUsersForSharing(requestUser, existingUsers.tryGet((Object)lowerCaseIdentifier));
        if (existingUsersOrNull == null) {
            String password = this.businessContext.getPasswordGenerator().generatePassword(20);
            UserDTO user = this.tryCreateUser(requestUser, lowerCaseIdentifier, password);
            if (user != null) {
                existingUsers.add((Object)user);
                users.add(user);
            } else {
                invalidIdentifiers.add(lowerCaseIdentifier);
            }
        } else {
            users.addAll(existingUsersOrNull);
        }
    }

    private static Set<UserDTO> removeUnsuitableUsersForSharing(UserDTO requestUser, Set<UserDTO> usersByEmailOrNull) {
        if (usersByEmailOrNull == null) {
            return null;
        }
        UserDTO acceptedOwner = requestUser.isPermanent() ? requestUser : requestUser.getRegistrator();
        Iterator<UserDTO> it = usersByEmailOrNull.iterator();
        while (it.hasNext()) {
            UserDTO user = it.next();
            if (user.getExpirationDate() == null || acceptedOwner.equals(user.getRegistrator())) continue;
            it.remove();
        }
        return usersByEmailOrNull.isEmpty() ? null : usersByEmailOrNull;
    }

    private Date getMaxExpirationTime(Collection<FileDTO> files) {
        Date maxExpirationTime = new Date(this.timeProvider.getTimeInMilliseconds());
        for (FileDTO file : files) {
            if (file.getExpirationDate() == null || maxExpirationTime.compareTo(file.getExpirationDate()) >= 0) continue;
            maxExpirationTime = file.getExpirationDate();
        }
        return maxExpirationTime;
    }

    private RuntimeException createLinksAndCallTriggersAndSendEmails(Set<UserDTO> users, Collection<FileDTO> files, String url, String comment, UserDTO requestUser) {
        Date maxFileExirationTime = this.getMaxExpirationTime(files);
        IFileDAO fileDAO = this.daoFactory.getFileDAO();
        IMailClient mailClient = this.businessContext.getMailClient();
        HashMap<String, UserDTO> emailToUserMap = new HashMap<String, UserDTO>();
        for (UserDTO user : users) {
            Date newUserExpirationDateOrNull;
            if (!this.triggerManager.isTriggerUser(user)) {
                emailToUserMap.put(user.getEmail(), user);
            }
            if ((newUserExpirationDateOrNull = ExpirationUtilities.tryExtendExpiration(new Date(this.timeProvider.getTimeInMilliseconds()), user.getExpirationDate(), user.getRegistrationDate(), maxFileExirationTime, this.businessContext.getMaxUserRetention())) != null) {
                user.setExpirationDate(newUserExpirationDateOrNull);
                this.userManager.updateUser(user, user, null, requestUser, null);
            }
            for (FileDTO fileDTO : files) {
                try {
                    fileDAO.createSharingLink(fileDTO.getID(), user.getID());
                }
                catch (DataIntegrityViolationException ex) {
                    operationLog.warn((Object)String.format("Trying to share file %s with user %s for the second time, skipped.", fileDTO.getPath(), user.getUserCode()), (Throwable)ex);
                }
            }
        }
        HashSet<FileDTO> filesLeft = new HashSet<FileDTO>(files);
        RuntimeException firstExceptionOrNull = null;
        for (FileDTO fileDTO : files) {
            boolean dismiss = false;
            for (UserDTO userDTO : users) {
                if (!this.triggerManager.isTriggerUser(userDTO)) continue;
                try {
                    dismiss |= this.triggerManager.handle(userDTO, fileDTO, this);
                }
                catch (RuntimeException ex) {
                    String msg = "Error calling trigger for file '" + fileDTO.getPath() + "' with trigger user '" + userDTO.getUserCode() + "'.";
                    operationLog.error((Object)msg, (Throwable)ex);
                    if (firstExceptionOrNull != null) continue;
                    firstExceptionOrNull = new RuntimeException(String.valueOf(msg) + " [" + ex.getClass().getSimpleName() + ":" + ex.getMessage() + "]", ex);
                }
            }
            if (!dismiss) continue;
            filesLeft.remove(fileDTO);
        }
        if (filesLeft.size() == 0) {
            return null;
        }
        boolean notified = false;
        for (Map.Entry entry : emailToUserMap.entrySet()) {
            String email = (String)entry.getKey();
            UserDTO user = (UserDTO)entry.getValue();
            EMailBuilderForUploadedFiles builder = new EMailBuilderForUploadedFiles(mailClient, requestUser, email);
            builder.setURL(url);
            String passwordOrNull = user.getPassword() == null ? null : user.getPassword().tryGetPlain();
            builder.setPassword(passwordOrNull);
            builder.setUserCode(user.getUserCode());
            builder.setFullName(user.getUserFullName());
            for (FileDTO fileDTO : filesLeft) {
                builder.addFile(fileDTO);
            }
            if (StringUtils.isNotBlank((String)comment)) {
                builder.setComment(comment);
            }
            try {
                builder.sendEMail();
                notified = false;
            }
            catch (EnvironmentFailureException ex) {
                if (!notified && ex.getMessage().indexOf("email addresses are invalid") < 0) {
                    notificationLog.error((Object)"A problem has occurred while sending email.", (Throwable)ex);
                    notified = true;
                }
                mailClient.sendEmailMessage("CIFEX was unable to send an email to your recipient", ex.getMessage(), null, null, new EMailAddress[]{new EMailAddress(requestUser.getEmail())});
            }
        }
        return firstExceptionOrNull;
    }

    private UserDTO tryCreateUser(UserDTO requestUser, String email, String password) {
        if (requestUser.isPermanent()) {
            UserDTO user = new UserDTO();
            user.setUserCode(StringUtilities.createUniqueString((String)email, (StringUtilities.IUniquenessChecker)new StringUtilities.IUniquenessChecker(){

                public boolean isUnique(String code) {
                    return !FileManager.this.daoFactory.getUserDAO().hasUserCode(code);
                }
            }));
            user.setEmail(email);
            user.setPassword(new Password(password));
            user.setRegistrator(requestUser);
            IUserBO userBO = this.boFactory.createUserBO();
            userBO.defineForCreate(user, requestUser, true);
            userBO.save();
            return user;
        }
        return null;
    }

    @Override
    @Transactional
    public final List<FileDTO> listFiles() throws UserFailureException {
        List<FileDTO> list = this.daoFactory.getFileDAO().listFiles();
        HashMap<Long, String> idToCodeMap = new HashMap<Long, String>();
        for (FileDTO file : list) {
            for (UserDTO user : file.getSharingUsers()) {
                user.setUserCode(this.getUserCodeForId(idToCodeMap, user.getID()));
            }
        }
        return list;
    }

    private String getUserCodeForId(Map<Long, String> idToCodeMap, long id) {
        String code = idToCodeMap.get(id);
        if (code == null) {
            code = this.daoFactory.getUserDAO().tryFindUserCodeById(id);
            idToCodeMap.put(id, code);
        }
        return code;
    }

    @Override
    @Transactional
    public void deleteFile(FileDTO fileDTO) {
        assert (fileDTO != null) : "Given file can not be null";
        this.daoFactory.getFileDAO().deleteFile(fileDTO.getID());
        this.deleteFromFileSystem(fileDTO.getPath());
    }

    @Override
    public Date updateFileUserData(long fileId, String name, String commentOrNull, Date expirationDate, UserDTO requestUser) {
        Date newExpirationDate = this.fixFileExpiration(fileId, expirationDate, requestUser);
        this.daoFactory.getFileDAO().updateFileUserEdit(fileId, name, commentOrNull, newExpirationDate);
        return newExpirationDate;
    }

    @Override
    public FileDTO getFile(long fileId) throws IllegalArgumentException {
        FileDTO fileOrNull = this.daoFactory.getFileDAO().tryGetFile(fileId);
        if (fileOrNull == null) {
            String msg = "No file found for fileId " + fileId + ".";
            operationLog.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        return fileOrNull;
    }

    private Date calculateNewExpirationDate(FileDTO file, UserDTO requestUser) {
        Integer maxUserRetentionDaysOrNull = this.tryGetMaxFileRetentionDays(requestUser);
        int fileRetentionDays = this.businessContext.getFileRetention();
        Date now = new Date(this.timeProvider.getTimeInMilliseconds());
        Date newExpirationDate = DateUtils.addDays((Date)now, (int)fileRetentionDays);
        if (maxUserRetentionDaysOrNull != null) {
            Date registrationDate = file.getRegistrationDate() == null ? now : file.getRegistrationDate();
            Date maxExpirationDate = DateUtils.addDays((Date)registrationDate, (int)maxUserRetentionDaysOrNull);
            if (newExpirationDate.getTime() > maxExpirationDate.getTime()) {
                return DateTimeUtils.extendUntilEndOfDay((Date)maxExpirationDate);
            }
        }
        return DateTimeUtils.extendUntilEndOfDay((Date)newExpirationDate);
    }

    @Override
    public void updateFile(FileDTO file, UserDTO requestUser) {
        this.checkAndFixFileExpiration(file, requestUser);
        this.daoFactory.getFileDAO().updateFile(file);
    }

    private void checkAndFixFileExpiration(FileDTO file, UserDTO requestUser) {
        file.setExpirationDate(this.fixFileExpiration(file.getID(), file.getExpirationDate(), requestUser));
    }

    private Date fixFileExpiration(long fileId, Date proposedExpirationDate, UserDTO requestUser) {
        Integer maxRetentionDaysOrNull = this.tryGetMaxFileRetentionDays(requestUser);
        Date registrationDateOrNull = maxRetentionDaysOrNull == null ? null : this.daoFactory.getFileDAO().getFileRegistrationDate(fileId);
        return ExpirationUtilities.fixExpiration(new Date(this.timeProvider.getTimeInMilliseconds()), proposedExpirationDate, registrationDateOrNull, maxRetentionDaysOrNull, this.businessContext.getFileRetention());
    }

    private Integer tryGetMaxFileRetentionDays(UserDTO requestUserOrNull) {
        if (requestUserOrNull == null) {
            return this.businessContext.getMaxFileRetention();
        }
        if (requestUserOrNull.isAdmin()) {
            return null;
        }
        return requestUserOrNull.getMaxFileRetention() == null ? this.businessContext.getMaxFileRetention() : requestUserOrNull.getMaxFileRetention().intValue();
    }

    @Override
    public void deleteSharingLink(long fileId, String userCode) {
        this.daoFactory.getFileDAO().deleteSharingLink(fileId, userCode);
    }
}

