/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.namedthread.NamingThreadPoolExecutor;
import ch.systemsx.cisd.base.unix.Unix;
import ch.systemsx.cisd.cifex.server.business.BusinessContext;
import ch.systemsx.cisd.cifex.server.business.IFileManager;
import ch.systemsx.cisd.cifex.server.business.ITriggerManager;
import ch.systemsx.cisd.cifex.server.business.IUserActionLog;
import ch.systemsx.cisd.cifex.server.business.dto.FileDTO;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.cifex.server.trigger.AsynchronousTrigger;
import ch.systemsx.cisd.cifex.server.trigger.ITrigger;
import ch.systemsx.cisd.cifex.server.trigger.ITriggerConsole;
import ch.systemsx.cisd.cifex.server.trigger.ITriggerRequest;
import ch.systemsx.cisd.cifex.server.trigger.SingletonTrigger;
import ch.systemsx.cisd.cifex.server.util.FilenameUtilities;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.io.PropertyIOUtils;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.mail.From;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import javax.activation.DataHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

class TriggerManager
implements ITriggerManager {
    private static final String TRIGGERS_RESOURCE = "/triggers.txt";
    private static final String TRIGGERS_FILE = "etc/triggers.txt";
    private final ExecutorService triggerExecutor;
    private final int maxTriggerPermits;
    private final Semaphore permits;
    private final Map<String, TriggerDescription> triggerMap;
    private final IMailClient mailClient;
    private final String url;
    private final IUserActionLog userActionLog;

    TriggerManager(BusinessContext context) {
        this.mailClient = context.getMailClient();
        this.maxTriggerPermits = context.getTriggerPermits();
        this.userActionLog = context.getUserActionLogHttp();
        this.triggerMap = this.getTriggers();
        if (TriggerDescription.hasAsyncTriggers(this.triggerMap)) {
            this.triggerExecutor = new NamingThreadPoolExecutor("Triggers").corePoolSize(3).daemonize();
            this.permits = new Semaphore(this.maxTriggerPermits);
        } else {
            this.triggerExecutor = null;
            this.permits = null;
        }
        try {
            this.url = context.getOverrideURL() == null ? "https://" + InetAddress.getLocalHost().getCanonicalHostName() + "/index.html" : context.getOverrideURL();
        }
        catch (UnknownHostException ex) {
            throw new EnvironmentFailureException("Cannot determine ip address of local host.", (Throwable)ex);
        }
    }

    private Map<String, TriggerDescription> getTriggers() {
        List triggerLines = null;
        File triggersFile = new File(TRIGGERS_FILE);
        if (!triggersFile.exists()) {
            InputStream is = TriggerManager.class.getResourceAsStream(TRIGGERS_RESOURCE);
            if (is != null) {
                triggerLines = FileUtilities.loadToStringList((InputStream)is);
            }
        } else {
            triggerLines = FileUtilities.loadToStringList((File)triggersFile);
        }
        if (triggerLines == null) {
            return Collections.emptyMap();
        }
        HashMap<String, TriggerDescription> triggers = new HashMap<String, TriggerDescription>();
        for (String triggerLine : triggerLines) {
            if (StringUtils.isBlank((String)triggerLine) || triggerLine.startsWith("#")) continue;
            String[] splitted = StringUtils.split((String)triggerLine.trim(), (char)'\t');
            if (splitted.length == 2) {
                triggers.put(splitted[0], new TriggerDescription(splitted[1], null));
                continue;
            }
            if (splitted.length == 3) {
                triggers.put(splitted[0], new TriggerDescription(splitted[1], splitted[2]));
                continue;
            }
            throw new ConfigurationFailureException("Illegal line in file /triggers.txt: lines need to have 2 or 3 columns, separated by TAB, this line has " + splitted.length + " columns: '" + triggerLine.trim() + "'.");
        }
        return triggers;
    }

    @Override
    public boolean handle(final UserDTO triggerUser, FileDTO fileDTO, IFileManager fileManager) {
        if (!this.isTriggerUser(triggerUser)) {
            throw new IllegalArgumentException("User " + triggerUser.getUserCode() + " is not a trigger user.");
        }
        File file = fileManager.getRealFile(fileDTO);
        final TriggerRequest request = new TriggerRequest(fileDTO, file, null);
        final TriggerDescription triggerDesc = this.triggerMap.get(triggerUser.getUserCode());
        final ITrigger trigger = triggerDesc.getTrigger();
        final TriggerConsole console = new TriggerConsole(trigger, fileManager, request, fileDTO.getOwner(), triggerUser);
        if (triggerDesc.isAsync()) {
            if (triggerDesc.getPermitsNeeded() > this.maxTriggerPermits) {
                throw ConfigurationFailureException.fromTemplate((String)"Number of permits needed to run trigger '%s' (%d) is more than all available permits (%d).", (Object[])new Object[]{triggerDesc.getTriggerClassName(), triggerDesc.getPermitsNeeded(), this.maxTriggerPermits});
            }
            this.triggerExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    int permitsHeld = 0;
                    try {
                        try {
                            TriggerManager.this.permits.acquire(triggerDesc.getPermitsNeeded());
                            permitsHeld = triggerDesc.getPermitsNeeded();
                            trigger.handle(request, console);
                        }
                        catch (Throwable th) {
                            String msg = "Your request '" + request.getFileName() + "' to user '" + triggerUser.getUserCode() + "' failed:\n" + th.getClass().getSimpleName() + ": " + th.getMessage();
                            TriggerManager.this.mailClient.sendEmailMessage("Your request '" + request.getFileName() + "'", msg, null, null, new EMailAddress[]{new EMailAddress(request.getUploadingUserEmail())});
                            throw CheckedExceptionTunnel.wrapIfNecessary((Throwable)th);
                        }
                    }
                    finally {
                        if (permitsHeld > 0) {
                            TriggerManager.this.permits.release(permitsHeld);
                        }
                        request.setDismiss(triggerDesc.willDismissRequest());
                        console.deleteDismissables();
                    }
                }
            });
            return triggerDesc.willDismissRequest();
        }
        try {
            trigger.handle(request, console);
        }
        finally {
            console.deleteDismissables();
        }
        return request.isDismissed();
    }

    @Override
    public boolean isTriggerUser(UserDTO user) {
        return this.triggerMap.containsKey(user.getUserCode());
    }

    private File copy(IFileManager fileManager, UserDTO triggerUser, File fileToUpload) {
        File uploadedFile = fileManager.createFile(triggerUser, fileToUpload.getName());
        boolean linked = false;
        if (Unix.isOperational()) {
            try {
                Unix.createHardLink((String)fileToUpload.getPath(), (String)uploadedFile.getPath());
                linked = true;
            }
            catch (IOExceptionUnchecked iOExceptionUnchecked) {}
        }
        if (!linked) {
            FileOperations.getInstance().copy(fileToUpload, uploadedFile);
        }
        return uploadedFile;
    }

    private int checksumCRC32(File uploadedFile) {
        int crc32Value;
        try {
            crc32Value = (int)FileUtils.checksumCRC32((File)uploadedFile);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        return crc32Value;
    }

    private final class TriggerConsole
    implements ITriggerConsole {
        private final ITrigger trigger;
        private final IFileManager fileManager;
        private final TriggerRequest triggerRequest;
        private final UserDTO triggerUser;
        private final UserDTO requestUser;
        private final Set<FileDTO> toBeDeleted = new HashSet<FileDTO>();

        private TriggerConsole(ITrigger trigger, IFileManager fileManager, TriggerRequest triggerRequest, UserDTO requestUser, UserDTO triggerUser) {
            this.trigger = trigger;
            triggerRequest.setToBeDeletedOrNull(this.toBeDeleted);
            this.fileManager = fileManager;
            this.triggerRequest = triggerRequest;
            this.requestUser = requestUser;
            this.triggerUser = triggerUser;
        }

        @Override
        public List<ITriggerRequest> getAllPendingRequests() {
            return this.getPendingRequests(null, null);
        }

        @Override
        public List<ITriggerRequest> getAllPendingRequests(String fileNameWildCard) {
            return this.getPendingRequests(null, fileNameWildCard);
        }

        @Override
        public List<ITriggerRequest> getPendingRequests() {
            return this.getPendingRequests(this.requestUser.getID(), null);
        }

        @Override
        public List<ITriggerRequest> getPendingRequests(String fileNameWildCard) {
            return this.getPendingRequests(this.requestUser.getID(), fileNameWildCard);
        }

        private List<ITriggerRequest> getPendingRequests(Long userIdOrNull, String fileNameWildCardOrNull) {
            List<FileDTO> files = this.fileManager.listDownloadFiles(this.triggerUser.getID());
            ArrayList<ITriggerRequest> requests = new ArrayList<ITriggerRequest>(files.size());
            for (FileDTO fileDTO : files) {
                if (fileDTO.getID().longValue() == this.triggerRequest.getFileID() || userIdOrNull != null && userIdOrNull != fileDTO.getOwnerId() || fileNameWildCardOrNull != null && !FilenameUtils.wildcardMatch((String)fileDTO.getName(), (String)fileNameWildCardOrNull)) continue;
                File realFile = this.fileManager.getRealFile(fileDTO);
                requests.add(new TriggerRequest(fileDTO, realFile, this.toBeDeleted));
            }
            return requests;
        }

        @Override
        public void upload(File fileToUpload, String[] recipients) {
            this.upload(fileToUpload, recipients, "Upload by trigger " + this.trigger.getClass().getSimpleName());
        }

        @Override
        public void upload(File fileToUpload, String[] recipients, String comment) {
            this.upload(fileToUpload, FilenameUtilities.getMimeType(fileToUpload.getName()), recipients, comment);
        }

        @Override
        public void upload(File fileToUpload, String mimeType, String[] recipients, String comment) {
            File uploadedFile = TriggerManager.this.copy(this.fileManager, this.triggerUser, fileToUpload);
            int crc32Value = TriggerManager.this.checksumCRC32(uploadedFile);
            this.fileManager.registerFileLinkAndInformRecipients(this.triggerUser, uploadedFile.getName(), comment, mimeType, uploadedFile, crc32Value, recipients, TriggerManager.this.url, TriggerManager.this.userActionLog);
        }

        public void sendMessage(String subject, String content, String replyTo, From fromOrNull, String ... recipients) throws EnvironmentFailureException {
            TriggerManager.this.mailClient.sendMessage(subject, content, replyTo, null, recipients);
        }

        public void sendMessageWithAttachment(String subject, String content, String filename, DataHandler attachmentContent, String replyToOrNull, From fromOrNull, String ... recipients) throws EnvironmentFailureException {
            TriggerManager.this.mailClient.sendMessageWithAttachment(subject, content, filename, attachmentContent, replyToOrNull, fromOrNull, recipients);
        }

        public void sendEmailMessage(String subject, String content, EMailAddress replyToOrNull, EMailAddress fromOrNull, EMailAddress ... recipients) throws EnvironmentFailureException {
            TriggerManager.this.mailClient.sendEmailMessage(subject, content, replyToOrNull, fromOrNull, recipients);
        }

        public void sendEmailMessageWithAttachment(String subject, String content, String filename, DataHandler attachmentContent, EMailAddress replyToOrNull, EMailAddress fromOrNull, EMailAddress ... recipients) throws EnvironmentFailureException {
            TriggerManager.this.mailClient.sendEmailMessageWithAttachment(subject, content, filename, attachmentContent, replyToOrNull, fromOrNull, recipients);
        }

        public void sendTestEmail() {
            TriggerManager.this.mailClient.sendTestEmail();
        }

        void deleteDismissables() {
            for (FileDTO fileDTO : this.toBeDeleted) {
                boolean success = false;
                try {
                    this.fileManager.deleteFile(fileDTO);
                    success = true;
                }
                finally {
                    TriggerManager.this.userActionLog.logDeleteFile(fileDTO, success);
                }
            }
        }
    }

    private static class TriggerDescription {
        private final String triggerClassName;
        private final String triggerPropertyFileOrNull;
        private final ITrigger triggerObjectOrNull;
        private final boolean asynchronous;
        private final boolean willDismiss;
        private final int permitsNeeded;

        static boolean hasAsyncTriggers(Map<String, TriggerDescription> triggerMap) {
            for (TriggerDescription desc : triggerMap.values()) {
                if (!desc.isAsync()) continue;
                return true;
            }
            return false;
        }

        TriggerDescription(String triggerClassName, String triggerPropertyFileOrNull) {
            this.triggerClassName = triggerClassName;
            this.triggerPropertyFileOrNull = triggerPropertyFileOrNull;
            try {
                Class<?> triggerClass = Class.forName(triggerClassName);
                if (triggerClass.isAnnotationPresent(SingletonTrigger.class)) {
                    this.triggerObjectOrNull = this.createTrigger();
                } else {
                    this.createTrigger();
                    this.triggerObjectOrNull = null;
                }
                AsynchronousTrigger asyncTrigger = triggerClass.getAnnotation(AsynchronousTrigger.class);
                if (asyncTrigger != null) {
                    this.asynchronous = true;
                    this.willDismiss = asyncTrigger.willDismissRequest();
                    this.permitsNeeded = asyncTrigger.triggerPermits();
                } else {
                    this.asynchronous = false;
                    this.willDismiss = false;
                    this.permitsNeeded = 0;
                }
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationFailureException("Class '" + triggerClassName + "' not found", (Throwable)ex);
            }
        }

        String getTriggerClassName() {
            return this.triggerClassName;
        }

        String getTriggerPropertyFileOrNull() {
            return this.triggerPropertyFileOrNull;
        }

        ITrigger getTrigger() {
            if (this.triggerObjectOrNull != null) {
                return this.triggerObjectOrNull;
            }
            return this.createTrigger();
        }

        boolean isAsync() {
            return this.asynchronous;
        }

        boolean willDismissRequest() {
            return this.willDismiss;
        }

        int getPermitsNeeded() {
            return this.permitsNeeded;
        }

        private ITrigger createTrigger() {
            try {
                if (this.getTriggerPropertyFileOrNull() == null) {
                    return (ITrigger)ClassUtils.create(ITrigger.class, (String)this.getTriggerClassName(), (Object[])new Object[0]);
                }
                Properties props = this.getProperties(this.getTriggerPropertyFileOrNull());
                return (ITrigger)ClassUtils.create(ITrigger.class, (String)this.getTriggerClassName(), (Object[])new Object[]{props});
            }
            catch (Exception ex) {
                throw new ConfigurationFailureException("Cannot create trigger '" + this.getTriggerClassName() + "'", (Throwable)CheckedExceptionTunnel.unwrapIfNecessary((Exception)ex));
            }
        }

        private Properties getProperties(String triggerPropertyFile) {
            File propFile = new File(triggerPropertyFile);
            if (propFile.exists()) {
                return PropertyIOUtils.loadProperties((String)propFile.getPath());
            }
            InputStream is = TriggerManager.class.getResourceAsStream("/" + triggerPropertyFile);
            if (is == null) {
                throw new ConfigurationFailureException("Cannot find trigger configuration file '" + triggerPropertyFile + "'.");
            }
            return PropertyIOUtils.loadProperties((InputStream)is, (String)triggerPropertyFile);
        }
    }

    private static class TriggerRequest
    implements ITriggerRequest {
        private final FileDTO fileDTO;
        private final File file;
        private Set<FileDTO> toBeDeletedOrNull;
        private boolean dismiss;
        private Date timeOfRequest;
        private Date timeOfExpiration;

        TriggerRequest(FileDTO fileDTO, File file, Set<FileDTO> toBeDeletedOrNull) {
            this.fileDTO = fileDTO;
            this.file = file;
            this.toBeDeletedOrNull = toBeDeletedOrNull;
            this.timeOfRequest = fileDTO.getRegistrationDate();
            this.timeOfExpiration = fileDTO.getExpirationDate();
            this.dismiss = false;
        }

        void setToBeDeletedOrNull(Set<FileDTO> toBeDeletedOrNull) {
            this.toBeDeletedOrNull = toBeDeletedOrNull;
        }

        @Override
        public String getComment() {
            return this.fileDTO.getComment();
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public String getFileName() {
            return this.fileDTO.getName();
        }

        @Override
        public String getUploadingUserEmail() {
            return this.fileDTO.getOwner().getEmail();
        }

        @Override
        public String getUploadingUserId() {
            return this.fileDTO.getOwner().getUserCode();
        }

        @Override
        public String getUploadingUserFullName() {
            return this.fileDTO.getOwner().getUserFullName();
        }

        public long getFileID() {
            return this.fileDTO.getID();
        }

        @Override
        public void dismiss() {
            this.dismiss = true;
            if (this.toBeDeletedOrNull != null) {
                this.toBeDeletedOrNull.add(this.fileDTO);
            }
        }

        public void setDismiss(boolean dismiss) {
            this.dismiss = dismiss;
            if (this.toBeDeletedOrNull != null) {
                if (dismiss) {
                    this.toBeDeletedOrNull.add(this.fileDTO);
                } else {
                    this.toBeDeletedOrNull.remove(this.fileDTO);
                }
            }
        }

        public boolean isDismissed() {
            return this.dismiss;
        }

        @Override
        public Date getRequestTime() {
            return this.timeOfRequest;
        }

        @Override
        public Date getExpirationTime() {
            return this.timeOfExpiration;
        }
    }
}

